/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class DurableStatsEvent
extends LogEvent {
    private ArrayList m_stats = new ArrayList();

    DurableStatsEvent() {
    }

    @Override
    public short type() {
        return 65;
    }

    public void addStat(long clientId, long count, long size) {
        DurableStat stat = new DurableStat();
        stat.m_count = count;
        stat.m_size = size;
        stat.m_clientId = clientId;
        this.m_stats.add(stat);
    }

    public ArrayList getStats() {
        return this.m_stats;
    }

    @Override
    protected int memSizeBody() {
        int size = this.m_stats.size() * 192 + 4;
        return size;
    }

    @Override
    public int streamSizeBody() {
        return 8 + this.m_stats.size() * 192;
    }

    @Override
    public int serializedSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        int size = this.m_stats.size();
        StreamUtil.writeInt(size, os);
        if (size > 0) {
            for (DurableStat stat : this.m_stats) {
                StreamUtil.writeLong(stat.m_clientId, os);
                StreamUtil.writeLong(stat.m_count, os);
                StreamUtil.writeLong(stat.m_size, os);
            }
        }
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        int size = StreamUtil.readInt(in);
        if (size > 0) {
            for (int count = 0; count < size; ++count) {
                DurableStat stat = new DurableStat();
                stat.m_clientId = StreamUtil.readLong(in);
                stat.m_count = StreamUtil.readLong(in);
                stat.m_size = StreamUtil.readLong(in);
                this.m_stats.add(stat);
            }
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoDurableStats(this.m_stats);
    }

    @Override
    public String toString() {
        String result = super.toString() + "Durable Stats Event: ";
        Iterator iter = this.m_stats.iterator();
        while (iter.hasNext()) {
            result = result + "\n";
            DurableStat stat = (DurableStat)iter.next();
            result = result + "\tID: " + stat.m_clientId + " Count: " + stat.m_count + " Size: " + stat.m_size;
        }
        return result;
    }

    public static class DurableStat {
        public long m_clientId;
        public long m_size;
        public long m_count;
    }
}

