/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.TxnAckPool;
import progress.message.broker.TxnPrepareEvt;
import progress.message.xa.XidImpl;

class GlobalTxnPrepareEvt
extends TxnPrepareEvt {
    private XidImpl m_xid;

    GlobalTxnPrepareEvt(int tid, String userXid, Object xid, long time, TxnAckPool txnAckPool, byte persistenceType, long requestId) {
        super(tid, userXid, time, txnAckPool, persistenceType, requestId);
        if (xid instanceof XidImpl) {
            this.m_xid = (XidImpl)xid;
        } else {
            System.out.println("[GlobalTxnPrepareEvt]unknow xid type");
        }
    }

    GlobalTxnPrepareEvt(short type) {
        super(type);
        this.m_xid = new XidImpl();
    }

    XidImpl getXid() {
        return this.m_xid;
    }

    @Override
    public short type() {
        return 96;
    }

    @Override
    protected int memSizeBody() {
        return super.memSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    public int streamSizeBody() {
        return super.streamSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    public int serializedSizeBody() {
        return super.serializedSizeBody() + this.m_xid.getMemorySize();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        super.writeBodyToLog(out, maxbytes);
        this.m_xid.writebody(out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        super.writeBodyToStream(os, tteTTLConvert);
        this.m_xid.writebody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        super.readBodyFromStream(in, tteTTLConvert);
        this.m_xid.readbody(in);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.m_xid.toString() + "]";
    }
}

