/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

class ReportSenderUnblocked
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    ReportSenderUnblocked(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ReportSenderUnblocked" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session context, Envelope env) {
        Message msg = env.getMessage();
        ISubject subject = msg.getSubject();
        String senderUid = SessionConfig.getUidFromAdminSubject(subject);
        String senderAppid = SessionConfig.getAppidFromAdminSubject(subject);
        try {
            IClientContext senderCC = this.m_reg.getClient(SessionConfig.stringToClientId(senderUid, senderAppid));
            BrokerManagementNotificationsHelper.sendFlowControlSendResumeNotification(Config.BROKER_NAME, senderCC, SessionConfig.getConnectIDFromSessionAppID(senderAppid));
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }
}

