/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSRequest;
import progress.message.broker.gs.GSTopicInfo;

public class GSNodeInfo {
    private String m_nodeName;
    private Hashtable m_topicInfoList = new Hashtable();
    private Hashtable m_requestList = new Hashtable();

    GSNodeInfo(String nodeName) {
        this.m_nodeName = nodeName;
    }

    boolean addOrUpdateTopic(String topic, boolean newSubscription, Vector addedSelectors, Vector removedSelectors) {
        boolean updateNeeded = false;
        boolean firstSubscriber = false;
        GSTopicInfo ti = (GSTopicInfo)this.m_topicInfoList.get(topic);
        if (ti == null) {
            firstSubscriber = true;
            ti = new GSTopicInfo(topic);
            this.m_topicInfoList.put(topic, ti);
        }
        updateNeeded = ti.addOrUpdateSubscriber(newSubscription, addedSelectors, removedSelectors);
        return firstSubscriber || updateNeeded;
    }

    boolean deleteTopic(String topic, String[] selectors) {
        GSTopicInfo ti = (GSTopicInfo)this.m_topicInfoList.get(topic);
        if (ti != null) {
            boolean updateNeeded = ti.deleteSubscriber(selectors);
            if (ti.getSubscriberCount() == 0) {
                this.m_topicInfoList.remove(topic);
                updateNeeded = true;
            }
            return updateNeeded;
        }
        return false;
    }

    Hashtable getTopicInfoList() {
        return this.m_topicInfoList;
    }

    String getNodeName() {
        return this.m_nodeName;
    }

    boolean isConfigured() {
        Vector allNodes = GSManager.getAllRoutingNodes();
        return allNodes.contains(this.m_nodeName.intern());
    }

    void dump() {
        System.out.println("    [GSNodeInfo Dump] for [node] " + this.m_nodeName);
        Enumeration enums = this.m_topicInfoList.elements();
        while (enums.hasMoreElements()) {
            ((GSTopicInfo)enums.nextElement()).dump();
        }
    }

    public void register(GSRequest req) {
        this.m_requestList.put(req.getTopic(), req);
    }

    public void unregister(GSRequest req) {
        this.m_requestList.remove(req.getTopic());
    }

    public void unregister(String key) {
        this.m_requestList.remove(key);
    }

    private void dumpRequestList() {
        System.out.println("[RequestList Dump]: ");
        Enumeration enums = this.m_requestList.elements();
        while (enums.hasMoreElements()) {
            ((GSRequest)enums.nextElement()).dump();
        }
    }

    public Hashtable getRequestList() {
        return this.m_requestList;
    }
}

