/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.gr.RouteInfo;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class RouteRequest
extends DebugObject {
    public static final int ADVERTISE = 1;
    public static final int UPDATE = 2;
    public static final int REMOVE = 3;
    public static final int CLUSTERED_ADVERTISE = 4;
    public static final int CLUSTERED_REMOVE = 5;
    private int m_requestType;
    private Vector m_infoVector;
    private Date m_requestDate;
    private Hashtable m_versionedRequests = new Hashtable(4);

    public RouteRequest() {
        super(DebugState.GLOBAL_DEBUG_ON ? "RouteRequest" : null);
        this.m_requestDate = new Date();
        this.m_infoVector = new Vector();
    }

    public RouteRequest(int requestType) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RouteRequest" : null);
        this.m_requestType = requestType;
        this.m_requestDate = new Date();
        this.m_infoVector = new Vector();
    }

    public int getRequestType() {
        return this.m_requestType;
    }

    public void setRequestDate(Date d) {
        this.m_requestDate = d;
    }

    public Date getRequestDate() {
        return this.m_requestDate;
    }

    public void addInfo(RouteInfo ri) {
        this.m_infoVector.addElement(ri);
    }

    public void removeInfo(int index) {
        this.m_infoVector.removeElementAt(index);
    }

    public RouteInfo getInfo(int index) {
        return (RouteInfo)this.m_infoVector.elementAt(index);
    }

    public int getInfoCount() {
        return this.m_infoVector.size();
    }

    public IMgram getIMgram(short requiredVersion) {
        Short version = new Short(requiredVersion);
        IMgram result = (IMgram)this.m_versionedRequests.get(version);
        if (result != null) {
            return result;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(byteStream);
        try {
            for (int i = 0; i < this.m_infoVector.size(); ++i) {
                RouteInfo ri = (RouteInfo)this.m_infoVector.elementAt(i);
                ri.writeToStream(dos, requiredVersion);
            }
            byte[] ba = byteStream.toByteArray();
            IMgram m = MgramFactory.getMgramFactory().buildRouteRequest(0, this.m_requestType, this.m_requestDate.getTime(), this.m_infoVector.size(), ba);
            this.m_versionedRequests.put(version, m);
            return m;
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return null;
        }
    }

    public void fromIMgramPayload(byte[] routeInfo, short receivedVersion) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(routeInfo));
            this.m_requestType = dis.readInt();
            this.m_requestDate.setTime(dis.readLong());
            int infoSize = dis.readInt();
            this.m_infoVector.removeAllElements();
            for (int i = 0; i < infoSize; ++i) {
                RouteInfo ri = new RouteInfo();
                ri.readFromStream(dis, receivedVersion);
                this.m_infoVector.addElement(ri);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

