/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import java.util.ArrayList;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Config;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.zclient.SubjectUtil;

public final class InterbrokerConfig {
    static boolean FORWARD_SUBSCRIPTIONS = true;
    static boolean DEBUG = true;
    static boolean CONFIGURED = false;
    static volatile String CONFIG_SERVER = "";
    public static final String PREFIX = new String("$IB");
    public static final String PREFIX_CAT = "$ISYS.IB";
    public static final String ACK_XCHG_SUBLEVEL = "ACK_EXCHANGE";
    public static volatile FTPairPeerInfoHolder INTERBROKER_IB_CONNECT_INFO;
    public static String HOSTS_SEPARATOR;
    public static final String BROKER_CONNECT_APPID = "Broker connect";
    public static final int BROKER_CONNECT_APPID_SCODE;
    public static final int CONFIG_CONNECT_RETRY_INTERVAL = 20000;
    public static final int CONFIG_CONNECT_KEEPALIVE_INTERVAL = 30000;
    public static final String CONFIG_CONNECT_KEEPALIVE_SUBJECT = "$ISYS.null";
    public static final int CONFIG_REQ_TIMEOUT_SEC = 30;
    public static final String S_CONFIG_PREFIX;
    public static final int S_CONFIG_PREFIX_NUM_LEVELS = 3;
    public static final String S_GET_CONFIG = "getConfiguration";
    public static final String S_GET_START_TIME = "getStartTime";
    public static final String S_NEW_COLLECTIVE = "newCollective";
    public static final String S_DEL_COLLECTIVE = "delCollective";
    public static final String S_NEW_BROKER = "newBroker";
    public static final String S_DEL_BROKER = "delBroker";
    public static final String S_ADD_BROKER = "addBroker";
    public static final String S_REMOVE_BROKER = "removeBroker";
    public static final String S_SET_ROUTING = "setRouting";
    public static final String S_DEL_ROUTING = "delRouting";
    public static final String S_EVENT = "event";
    public static final String S_ROUTING_EVENT = "routingEvent";
    public static final String S_CONFIG_CHANGE = "$ISYS.IB.config";
    public static final String S_ACCEPTOR_CONFIG_CHANGE = "$ISYS.IB.config.ACCEPTOR_CONFIG_CHANGE";
    public static final int GET_CONFIG_REPLY_MSG_LEN = 10000;

    public static final String addPrefix(String subject) {
        return "$ISYS.IB." + subject;
    }

    public static String addConfigPrefix(String s) {
        return S_CONFIG_PREFIX + "." + s;
    }

    public static boolean loadConfig() {
        Acceptor ia;
        AcceptorHolder ah = AcceptorHolder.getAcceptorHolder();
        String interbrokerURL = null;
        if (ah != null && (ia = ah.getInterbrokerAcceptor()) != null) {
            interbrokerURL = ia.getURL();
        }
        ArrayList<String> ibConnectUrls = new ArrayList<String>(1);
        ibConnectUrls.add(interbrokerURL);
        INTERBROKER_IB_CONNECT_INFO = new FTPairPeerInfoHolder(null, null, ibConnectUrls, null);
        boolean success = false;
        if (Config.CONFIGURED) {
            DEBUG = Config.getBooleanProperty("IB_DEBUG", false);
            FORWARD_SUBSCRIPTIONS = Config.getBooleanProperty("IB_FORWARD_SUBSCRIPTIONS", true);
            CONFIG_SERVER = Config.getProperty("IB_CONFIG_SERVER", "");
            success = true;
            CONFIGURED = true;
        } else {
            CONFIGURED = true;
            success = true;
        }
        return success;
    }

    static {
        HOSTS_SEPARATOR = ",";
        BROKER_CONNECT_APPID_SCODE = SubjectUtil.computeSCode(BROKER_CONNECT_APPID, 0, BROKER_CONNECT_APPID.length());
        S_CONFIG_PREFIX = InterbrokerConfig.addPrefix("config");
    }
}

