/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Objects;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.MessageHandlerQueue;
import progress.message.zclient.SearchResults;

final class HandlerIHandlerContainer
implements ISubjectMatchObject {
    private MessageHandler m_mh;
    private IMessageHandler m_imh;
    private MessageHandlerQueue m_queue;
    private int m_bindCount;
    private int m_lastMsgNo;

    HandlerIHandlerContainer(MessageHandler mh, IMessageHandler imh) {
        this.m_mh = mh;
        this.m_imh = imh;
        this.m_queue = mh.getMessageQueue();
    }

    MessageHandler getHandler() {
        return this.m_mh;
    }

    IMessageHandler getIHandler() {
        return this.m_imh;
    }

    int incBindCount() {
        return ++this.m_bindCount;
    }

    int decBindCount() {
        return --this.m_bindCount;
    }

    void newMessage(Envelope env, int msgno) {
        if (msgno != this.m_lastMsgNo) {
            this.newMessage(env);
            this.m_lastMsgNo = msgno;
        }
    }

    void newMessage(Envelope env) {
        boolean guar = this.m_mh.isGuaranteed();
        if (!guar && env.isGuaranteed() && env.isSuccessor()) {
            return;
        }
        env.addHandler(guar);
        if (this.m_mh.isNoThread()) {
            this.m_mh.deliverToClient(env, this.m_imh);
        } else {
            this.m_queue.addElement(env, this.m_imh);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HandlerIHandlerContainer)) {
            return false;
        }
        HandlerIHandlerContainer hih = (HandlerIHandlerContainer)obj;
        return hih.m_mh.equals(this.m_mh) && hih.m_imh.equals(this.m_imh);
    }

    public int hashCode() {
        return Objects.hash(this.m_mh, this.m_imh);
    }

    @Override
    public final void prefixMatch(ISubject subject, SearchResults result) {
    }

    @Override
    public final boolean localEffect() {
        return true;
    }

    @Override
    public boolean isBatchable() {
        return false;
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        return false;
    }
}

