/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import progress.message.client.EInvalidSubjectOperation;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.HashList;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SubjectUtil;

public class Subject
implements ISubject {
    private static final boolean DEBUG = false;
    private static final byte VERSION = 1;
    private static final short SUBJECT_STRING_MASK = 1;
    private static final short SUBJECT_TRACKING_MASK = 6;
    private static final short MULTI_SUBJECT_MASK = 8;
    private static final short GROUP_MASK = 16;
    private static final short SYSTEM_MASK = 32;
    private static final short TEMPORARY_MASK = 64;
    private static final short QUEUE_MASK = 128;
    private static final short REPLY_MASK = 256;
    private static final short SONICMQ_MASK = 512;
    public static final String HTTP_CONTENT_REPLY_SUBJECT_PREFIX = "HttpProtocolHandlerResponse";
    private short m_flags;
    private byte m_trackingType = 0;
    private String m_subject = null;
    private byte[] m_subjectUTF = null;
    private String m_groupPrefix = null;
    private int m_hashCode = -1;
    private int m_memoryLengthCache = -1;
    private boolean m_dirtyMemoryLengthCache = false;
    private int[] m_matchVector = null;
    private long m_tracking = -1L;
    private volatile boolean m_protected = false;
    private boolean m_readOnly = false;
    private HashList<ISubject> m_multiSubjectTable = null;
    private transient String[] m_leveledSubject = null;
    private transient short m_tempSubjectCount = 0;
    private int m_serialLength = -1;
    private byte[] m_serialized = null;

    public Subject() {
    }

    public Subject(String subject) {
        this(subject, null);
    }

    public Subject(String subject, boolean parseMulti) {
        this(subject, null, parseMulti);
    }

    public Subject(String subject, int[] matchVector) {
        this(subject, matchVector, false);
    }

    public Subject(String subject, int[] matchVector, boolean parseMulti) {
        this.initSubjectString(subject, parseMulti);
        this.m_matchVector = matchVector;
    }

    private Subject(Subject s) {
        this.m_subject = s.m_subject;
        this.m_groupPrefix = s.m_groupPrefix;
        this.m_subjectUTF = s.m_subjectUTF;
        this.m_multiSubjectTable = s.m_multiSubjectTable;
        this.m_tracking = s.m_tracking;
        this.m_trackingType = s.m_trackingType;
        this.m_matchVector = s.m_matchVector;
        this.m_tempSubjectCount = s.m_tempSubjectCount;
        this.m_hashCode = s.m_hashCode;
        this.m_serialized = s.m_serialized;
        this.m_flags = s.m_flags;
        this.m_memoryLengthCache = s.m_memoryLengthCache;
        this.m_dirtyMemoryLengthCache = s.m_dirtyMemoryLengthCache;
    }

    private final void initSubjectString(String subject, boolean parseMulti) {
        this.m_dirtyMemoryLengthCache = true;
        if (subject != null && subject.startsWith("[[")) {
            int i = subject.indexOf("]]");
            if (i == -1) {
                throw new EInvalidSubjectOperation("Unclosed group prefix.");
            }
            this.m_groupPrefix = subject.substring("[[".length(), i);
            this.m_subject = subject.substring(i + "]]".length());
            this.m_subjectUTF = null;
            this.m_flags = (short)(this.m_flags | 0x11);
            this.computeSubjectFlags();
        } else {
            this.m_subject = subject;
            if (subject != null) {
                this.m_flags = (short)(this.m_flags | 1);
                this.computeSubjectFlags();
            }
        }
        if (parseMulti) {
            if (this.m_subject == null) {
                throw new NullPointerException("'String m_subject' in " + this.getClass().getName() + ".initSubjectString(String subject, boolean parseMulti) cannot be null.");
            }
            if (this.m_subject.startsWith("MULTITOPIC:")) {
                this.m_subject = this.m_subject.substring("MULTITOPIC:".length());
                StringTokenizer tok = new StringTokenizer(this.m_subject, "||");
                while (tok.hasMoreTokens()) {
                    Subject s = new Subject(tok.nextToken());
                    s.setGroupName(this.m_groupPrefix);
                    this.addSubject(s);
                }
                this.m_subject = null;
                this.m_flags = (short)(this.m_flags & 0xFFFFFFFE);
                this.m_flags = (short)(this.m_flags | 8);
            }
        }
    }

    private void computeSubjectFlags() {
        if (SessionConfig.isSystemSubject(this.m_subject)) {
            this.m_flags = (short)(this.m_flags | 0x20);
            if (this.m_subject.startsWith("$ISYS.USERS.reply")) {
                this.m_flags = (short)(this.m_flags | 0x100);
            }
            if (this.m_subject.startsWith("$ISYS.USERS.TemporaryTopics")) {
                this.m_flags = (short)(this.m_flags | 0x40);
            }
        }
        if (this.m_subject.startsWith("$Q.")) {
            if (this.m_subject.startsWith("$Q.$ISYS.USERS.TemporaryQueues")) {
                this.m_flags = (short)(this.m_flags | 0x40);
            }
            this.m_flags = (short)(this.m_flags | 0x80);
        }
        if (this.m_subject.startsWith("SonicMQ.")) {
            this.m_flags = (short)(this.m_flags | 0x200);
        }
        if (this.m_subject.indexOf(HTTP_CONTENT_REPLY_SUBJECT_PREFIX) != -1) {
            this.m_flags = (short)(this.m_flags | 0x40);
        }
    }

    public final void addSubject(ISubject s) {
        this.dirty();
        if (this.m_multiSubjectTable == null) {
            this.m_flags = (short)(this.m_flags | 8);
            this.m_multiSubjectTable = new HashList();
        }
        if (this.m_multiSubjectTable.add(s) && s.isTemporary()) {
            this.m_tempSubjectCount = (short)(this.m_tempSubjectCount + 1);
        }
    }

    public final void removeSubject(ISubject s) throws IllegalStateException {
        if (this.m_multiSubjectTable != null) {
            this.dirty();
            if (this.m_multiSubjectTable.remove(s)) {
                if (this.m_multiSubjectTable.size() == 0) {
                    this.m_groupPrefix = null;
                    this.m_flags = (short)(this.m_flags & 0xFFFFFFEF);
                }
                if (s.isTemporary()) {
                    this.m_tempSubjectCount = (short)(this.m_tempSubjectCount - 1);
                }
            }
        } else if (this.isSubjectSet()) {
            throw new IllegalStateException("Can't remove from non multisubect: " + this);
        }
    }

    public final void setGroupName(String groupName) {
        this.dirty();
        this.m_groupPrefix = groupName;
        this.m_flags = this.m_groupPrefix != null ? (short)(this.m_flags | 0x10) : (short)(this.m_flags & 0xFFFFFFEF);
    }

    @Override
    public final boolean isMultiSubject() {
        return (this.m_flags & 8) > 0;
    }

    @Override
    public final Iterator<ISubject> getMultiSubjects() {
        if (this.isMultiSubject()) {
            return this.getSingleSubjects();
        }
        return null;
    }

    @Override
    public final Iterator<ISubject> getSingleSubjects() {
        if (!this.isSubjectSet()) {
            return null;
        }
        if (this.isMultiSubject()) {
            return new Iterator<ISubject>(){
                Iterator<ISubject> i;
                ISubject last;
                {
                    this.i = Subject.this.m_multiSubjectTable.iterator();
                    this.last = null;
                }

                @Override
                public void remove() {
                    Subject.this.unprotect();
                    if (this.last == null) {
                        throw new IllegalStateException("remove cannot be called until next has been called.");
                    }
                    Subject.this.removeSubject(this.last);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public ISubject next() {
                    this.last = this.i.next();
                    return this.last;
                }
            };
        }
        return new Iterator<ISubject>(){
            boolean hasNext = true;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't call remove on a single subject");
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public ISubject next() {
                this.hasNext = false;
                return Subject.this;
            }
        };
    }

    @Override
    public final int getMultiSubjectCount() {
        return this.m_multiSubjectTable == null ? 0 : this.m_multiSubjectTable.size();
    }

    public final void initSubjectUTF(byte[] utfString) {
        this.m_dirtyMemoryLengthCache = true;
        this.m_subjectUTF = utfString;
        if (utfString == null) {
            return;
        }
        try {
            this.initSubjectString(StringUtil.UTFToString(this.m_subjectUTF, 0), false);
        }
        catch (UTFDataFormatException ex) {
            throw new EAssertFailure("UTF Format Exception in given subject");
        }
    }

    public final void initMatchVector(int[] mv) {
        this.m_dirtyMemoryLengthCache = true;
        this.m_matchVector = mv;
    }

    public final void initSubjectTracking(int tracking) {
        this.m_dirtyMemoryLengthCache = true;
        this.m_tracking = tracking;
        this.m_trackingType = 1;
        this.m_flags = (short)(this.m_flags & 0xFFFFFFF9 | 2);
    }

    @Override
    public ISubject assignTrackingNumbers(long tracking, byte type) {
        Subject ret = new Subject(this);
        ret.m_trackingType = type;
        ret.m_tracking = tracking;
        ret.m_flags = (short)(this.m_flags & 0xFFFFFFF9 | type << 1);
        if (this.isMultiSubject()) {
            ret.m_multiSubjectTable = new HashList(this.m_multiSubjectTable.size());
            int t = 1;
            Iterator<ISubject> i = this.m_multiSubjectTable.iterator();
            while (i.hasNext()) {
                ret.m_multiSubjectTable.add(i.next().assignTrackingNumbers(t++, (byte)2));
            }
        }
        ret.dirty();
        ret.m_hashCode = this.m_hashCode;
        return ret;
    }

    @Override
    public final ISubject clearSubjectTracking() {
        if (this.m_trackingType == 0) {
            return this;
        }
        Subject ret = new Subject(this);
        ret.m_trackingType = 0;
        ret.m_tracking = -1L;
        ret.m_flags = (short)(this.m_flags & 0xFFFFFFF9 | 0);
        if (this.isMultiSubject()) {
            ret.m_multiSubjectTable = new HashList(this.m_multiSubjectTable.size());
            Iterator<ISubject> i = this.m_multiSubjectTable.iterator();
            while (i.hasNext()) {
                ret.m_multiSubjectTable.add(i.next().clearSubjectTracking());
            }
        }
        ret.dirty();
        ret.m_hashCode = this.m_hashCode;
        return ret;
    }

    @Override
    public final int getSerializedLength() {
        if (this.m_serialized == null) {
            this.m_dirtyMemoryLengthCache = true;
            this.toByteArray();
        }
        return this.m_serialized.length;
    }

    private int getSerializedLengthInternal() {
        if (this.m_serialLength > 0) {
            return this.m_serialLength;
        }
        int ret = 7;
        switch (this.m_trackingType) {
            case 3: {
                ret += 8;
                break;
            }
            case 1: {
                ret += 4;
                break;
            }
            case 2: {
                ret += 2;
                break;
            }
        }
        if (this.hasGroup()) {
            try {
                ret += StringUtil.stringToUTF(this.m_groupPrefix).length;
            }
            catch (UTFDataFormatException ex) {
                SessionConfig.logMessage("Error with subject group prefix", ex, SessionConfig.SEVERE);
            }
        }
        if (!this.isMultiSubject()) {
            return ret + (this.isSubjectSet() ? this.getSubjectUTFLength() : 0);
        }
        ret += 2;
        Iterator<ISubject> i = this.getMultiSubjects();
        while (i.hasNext()) {
            ret += ((Subject)i.next()).getSerializedLengthInternal();
        }
        return ret;
    }

    public static final ISubject createFromStream(InputStream is) throws IOException {
        Subject s = new Subject();
        s.initFromStream(is);
        return s;
    }

    public static final ISubject createFromBytes(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            return Subject.createFromStream(bis);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final int initFromStream(InputStream is) throws IOException {
        this.m_dirtyMemoryLengthCache = true;
        int version = is.read();
        if (version > 1 || version == 0) {
            SessionConfig.logMessage(new RuntimeException("Incompatible subject stream version: " + version), SessionConfig.SEVERE);
        }
        int count = 7;
        this.m_flags = StreamUtil.readShort(is);
        if ((this.m_flags & 0x10) > 0) {
            byte[] groupUTF = StreamUtil.readUTFString(is);
            count += groupUTF.length;
            this.m_groupPrefix = StringUtil.UTFToString(groupUTF, 0);
        }
        if ((this.m_flags & 1) > 0) {
            this.m_subjectUTF = StreamUtil.readUTFString(is);
            count += this.m_subjectUTF.length;
            this.m_subject = StringUtil.UTFToString(this.m_subjectUTF, 0);
        }
        if ((this.m_flags & 6) > 0) {
            this.m_trackingType = (byte)((this.m_flags & 6) >> 1);
            switch (this.m_trackingType) {
                case 3: {
                    this.m_tracking = StreamUtil.readLong(is);
                    count += 8;
                    break;
                }
                case 1: {
                    this.m_tracking = StreamUtil.readInt(is);
                    count += 4;
                    break;
                }
                case 2: {
                    this.m_tracking = StreamUtil.readShort(is);
                    count += 2;
                    break;
                }
            }
        }
        if ((this.m_flags & 8) > 0) {
            count += 2;
            int c = StreamUtil.readShort(is);
            this.m_multiSubjectTable = new HashList();
            for (int i = 0; i < c; ++i) {
                Subject s = new Subject();
                count += s.initFromStream(is);
                this.addSubject(s);
            }
        }
        this.m_serialLength = count;
        this.m_hashCode = StreamUtil.readInt(is);
        return this.m_serialLength;
    }

    @Override
    public final byte[] toByteArray() {
        this.m_dirtyMemoryLengthCache = true;
        if (this.m_serialized != null) {
            return this.m_serialized;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.getSerializedLengthInternal());
        try {
            this.writeToStream(bos);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.m_serialized = bos.toByteArray();
        return this.m_serialized;
    }

    @Override
    public final int writeToStream(OutputStream os) throws IOException {
        if (this.m_serialized != null) {
            os.write(this.m_serialized);
            return this.m_serialized.length;
        }
        int count = 7;
        os.write(1);
        StreamUtil.writeShort(this.m_flags, os);
        if ((this.m_flags & 0x10) > 0) {
            byte[] groupUTF = StringUtil.stringToUTF(this.m_groupPrefix);
            os.write(groupUTF);
            count += groupUTF.length;
        }
        if ((this.m_flags & 1) > 0) {
            os.write(this.getSubjectUTF());
            count += this.m_subjectUTF.length;
        }
        switch (this.m_trackingType) {
            case 2: {
                StreamUtil.writeShort((short)this.m_tracking, os);
                count += 2;
                break;
            }
            case 1: {
                StreamUtil.writeInt((int)this.m_tracking, os);
                count += 4;
                break;
            }
            case 3: {
                StreamUtil.writeLong(this.m_tracking, os);
                count += 8;
                break;
            }
        }
        if ((this.m_flags & 8) > 0) {
            count += 2;
            StreamUtil.writeShort((short)this.m_multiSubjectTable.size(), os);
            Iterator<ISubject> i = this.getMultiSubjects();
            while (i.hasNext()) {
                count += i.next().writeToStream(os);
            }
        }
        StreamUtil.writeInt(this.hashCode(), os);
        return count;
    }

    @Override
    public final Object clone() {
        Subject clone = new Subject(this);
        clone.protect();
        clone.unprotect();
        return clone;
    }

    @Override
    public final ISubject protectedClone() {
        if (this.m_multiSubjectTable == null) {
            this.toByteArrayCheckingMSerializedNull();
            this.m_readOnly = true;
            return this;
        }
        this.sync();
        Subject clone = new Subject(this);
        this.protect();
        clone.protect();
        return clone;
    }

    private final void protect() {
        this.m_protected = true;
    }

    private final void unprotect() {
        if (!this.m_protected) {
            return;
        }
        if (this.m_multiSubjectTable != null) {
            HashList<ISubject> newMap = new HashList<ISubject>(this.m_multiSubjectTable.size());
            Iterator<ISubject> i = this.getMultiSubjects();
            while (i.hasNext()) {
                ISubject sub = i.next();
                newMap.add(sub.protectedClone());
            }
            this.m_dirtyMemoryLengthCache = true;
            this.m_multiSubjectTable = newMap;
        }
        this.m_protected = false;
    }

    private final void sync() {
        if (!this.isMultiSubject()) {
            if (this.m_matchVector == null) {
                this.getMatchVector();
            }
            if (this.m_subjectUTF == null) {
                this.getSubjectUTF();
            }
        }
        this.toByteArrayCheckingMSerializedNull();
        if (this.m_hashCode == -1) {
            this.hashCode();
        }
    }

    private void toByteArrayCheckingMSerializedNull() {
        if (this.m_serialized == null) {
            this.toByteArray();
        }
    }

    private final void dirty() {
        if (this.m_readOnly) {
            throw new IllegalStateException("Illegal to modify a read only subject: " + this);
        }
        this.m_dirtyMemoryLengthCache = true;
        this.unprotect();
        this.m_hashCode = -1;
        this.m_serialLength = -1;
        this.m_serialized = null;
    }

    @Override
    public final int memoryLength() {
        if (this.m_memoryLengthCache > -1 && !this.m_dirtyMemoryLengthCache) {
            return this.m_memoryLengthCache;
        }
        if (!this.isMultiSubject()) {
            int subjectByteLength = 0;
            subjectByteLength += 72;
            subjectByteLength = this.configLengthFromSerializedOrMSubject(subjectByteLength);
            subjectByteLength += this.m_subject == null ? 0 : 20 + 2 * this.m_subject.length();
            this.m_memoryLengthCache = subjectByteLength += this.m_groupPrefix == null ? 0 : 20 + 2 * this.m_groupPrefix.length();
            return subjectByteLength;
        }
        int subjectByteLength = 0;
        subjectByteLength += 72;
        subjectByteLength += this.m_subject == null ? 0 : 20 + 2 * this.m_subject.length();
        subjectByteLength = this.configLengthFromSerializedOrMSubject(subjectByteLength);
        subjectByteLength += this.m_groupPrefix == null ? 0 : 20 + 2 * this.m_groupPrefix.length();
        Iterator<ISubject> i = this.getMultiSubjects();
        while (i.hasNext()) {
            ISubject s = i.next();
            subjectByteLength += s.memoryLength();
        }
        this.m_memoryLengthCache = subjectByteLength += 72 + 62 * this.m_multiSubjectTable.size();
        return subjectByteLength;
    }

    private int configLengthFromSerializedOrMSubject(int subjectByteLengthParam) {
        int subjectByteLength = subjectByteLengthParam;
        subjectByteLength = this.m_serialized != null ? (subjectByteLength += 16 + this.m_serialized.length) : (subjectByteLength += this.m_subject == null ? 0 : 25 + this.m_subject.length());
        subjectByteLength = this.m_subjectUTF != null ? (subjectByteLength += 16 + this.m_subjectUTF.length) : (subjectByteLength += this.m_subject == null ? 0 : 16 + this.m_subject.length());
        return subjectByteLength += this.m_matchVector == null ? 0 : 4 + 4 * this.m_matchVector.length;
    }

    @Override
    public final String getSubjectString() {
        if (this.m_groupPrefix != null) {
            if (!this.isSubjectSet()) {
                return null;
            }
            return SubjectUtil.wrapSubjectGroupPrefix(this.m_groupPrefix) + this.getLookupName();
        }
        return this.getLookupName();
    }

    @Override
    public final void appendSubjectString(StringBuilder sb, int maxSubjects) {
        if (!this.isSubjectSet()) {
            sb.append("<no subject>");
            return;
        }
        if (this.m_groupPrefix != null) {
            sb.append(SubjectUtil.wrapSubjectGroupPrefix(this.m_groupPrefix));
        }
        if (!this.isMultiSubject()) {
            sb.append(this.getLookupName());
        } else {
            this.appendMultiTopicSubject(sb, maxSubjects);
            if (this.getMultiSubjectCount() > maxSubjects) {
                sb.append(" (");
                sb.append(this.getMultiSubjectCount());
                sb.append(" topics)");
            }
        }
    }

    @Override
    public final String extractSubjectLevel(int level) {
        this.getLeveledSubject();
        if (this.m_leveledSubject != null && this.m_leveledSubject.length > level) {
            return this.m_leveledSubject[level];
        }
        throw new IndexOutOfBoundsException("Subject level out of bounds: " + level + " for " + this);
    }

    @Override
    public final String[] getLeveledSubject() {
        try {
            if (this.m_leveledSubject == null) {
                if (this.isMultiSubject()) {
                    throw new EInvalidSubjectOperation("Cannot extract subject level from a MultiSubject");
                }
                if (!this.isSubjectSet()) {
                    return null;
                }
                this.getMatchVector();
                this.m_leveledSubject = new String[this.m_matchVector.length];
                int tokStart = 0;
                int delim = -1;
                for (int count = 0; count < this.m_leveledSubject.length; ++count) {
                    tokStart = delim + 1;
                    if ((delim = this.m_subject.indexOf(46, tokStart)) == -1) {
                        delim = this.m_subject.length();
                    }
                    this.m_leveledSubject[count] = this.m_subject.substring(tokStart, delim);
                }
            }
        }
        catch (Throwable thrown) {
            SessionConfig.logMessage("Error getting leveled subject for: " + this.debugString(), thrown, SessionConfig.SEVERE);
            throw (RuntimeException)thrown;
        }
        return this.m_leveledSubject;
    }

    @Override
    public final byte[] getSubjectUTF() {
        this.m_dirtyMemoryLengthCache = true;
        if (this.m_subjectUTF != null) {
            return this.m_subjectUTF;
        }
        if (this.m_subject == null) {
            return null;
        }
        try {
            this.m_subjectUTF = StringUtil.stringToUTF(this.m_subject);
        }
        catch (UTFDataFormatException e) {
            throw new EAssertFailure("UTF Format Exception in given subject");
        }
        return this.m_subjectUTF;
    }

    @Override
    public final int getSubjectUTFLength() {
        if (this.m_subjectUTF == null) {
            byte[] utf = this.getSubjectUTF();
            if (utf != null) {
                return utf.length;
            }
            return 0;
        }
        return this.m_subjectUTF.length;
    }

    @Override
    public final int[] getMatchVector() {
        if (this.isMultiSubject()) {
            throw new EInvalidSubjectOperation("Match vector not available for MultiSubject!");
        }
        if (this.m_matchVector != null) {
            return this.m_matchVector;
        }
        if (this.isSubjectSet()) {
            this.m_dirtyMemoryLengthCache = true;
            this.m_matchVector = SubjectUtil.computeMatchVector(this.getLookupName(), false);
        }
        return this.m_matchVector;
    }

    @Override
    public final boolean isSubjectSet() {
        if ((this.m_flags & 1) > 0) {
            return true;
        }
        if ((this.m_flags & 8) > 0) {
            return this.m_multiSubjectTable.size() > 0;
        }
        return false;
    }

    @Override
    public final boolean isQueue() {
        return (this.m_flags & 0x80) != 0;
    }

    @Override
    public final boolean isTemporary() {
        if ((this.m_flags & 8) > 0) {
            return this.m_tempSubjectCount == this.getMultiSubjectCount();
        }
        return (this.m_flags & 0x40) != 0;
    }

    @Override
    public final boolean hasTemporary() {
        return this.m_tempSubjectCount > 0 || (this.m_flags & 0x40) != 0;
    }

    @Override
    public final boolean isSystem() {
        if ((this.m_flags & 0x20) != 0) {
            return this.m_subject.startsWith("$ISYS");
        }
        return false;
    }

    @Override
    public final boolean isAnySystem() {
        return (this.m_flags & 0x20) != 0;
    }

    @Override
    public final boolean isReply() {
        return (this.m_flags & 0x100) > 0;
    }

    @Override
    public final boolean isHttpReply() {
        if (!this.isTemporary()) {
            return false;
        }
        return this.m_subject.lastIndexOf(HTTP_CONTENT_REPLY_SUBJECT_PREFIX) > 0;
    }

    @Override
    public final boolean isSonicMQSubject() {
        return (this.m_flags & 0x200) > 0;
    }

    @Override
    public final boolean hasGroup() {
        return this.m_groupPrefix != null;
    }

    @Override
    public final String getGroupName() {
        return this.m_groupPrefix;
    }

    @Override
    public final String getLookupName() {
        if (!this.isMultiSubject()) {
            return this.m_subject;
        }
        StringBuilder sb = new StringBuilder();
        this.appendMultiTopicSubject(sb, -1);
        return sb.toString();
    }

    private final void appendMultiTopicSubject(StringBuilder sb, int maxSubjects) {
        maxSubjects = maxSubjects > 0 ? maxSubjects : Integer.MAX_VALUE;
        sb.append("MULTITOPIC:");
        int count = 0;
        Iterator<ISubject> i = this.getMultiSubjects();
        while (i.hasNext()) {
            if (++count > 1) {
                sb.append("||");
            }
            if (count > maxSubjects) {
                sb.append("...");
                break;
            }
            sb.append(i.next().getLookupName());
        }
    }

    @Override
    public final String getJMSName() {
        if (this.isQueue()) {
            return this.m_subject.substring("$Q.".length());
        }
        return this.getSubjectString();
    }

    @Override
    public int hashCode() {
        if (this.m_hashCode != -1) {
            return this.m_hashCode;
        }
        if ((this.m_flags & 8) > 0) {
            int hc = 0;
            Iterator<ISubject> i = this.getMultiSubjects();
            while (i.hasNext()) {
                hc += ((Subject)i.next()).hashCode();
            }
            this.m_hashCode = hc;
            return hc;
        }
        if ((this.m_flags & 1) > 0) {
            this.m_hashCode = this.m_subject.hashCode();
            return this.m_hashCode;
        }
        return 0;
    }

    @Override
    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() == o.getClass()) {
            return this.isEqualSubject((Subject)o, false);
        }
        return false;
    }

    private final boolean isEqualSubject(Subject s, boolean strictMatch) {
        if (strictMatch) {
            if (this.m_flags != s.m_flags) {
                return false;
            }
            if (s.m_trackingType != this.m_trackingType) {
                return false;
            }
            if (this.m_tracking != s.m_tracking) {
                return false;
            }
        } else if ((this.m_flags & 0xFFFFFFF9) != (s.m_flags & 0xFFFFFFF9)) {
            return false;
        }
        if (this.m_groupPrefix != null && !this.m_groupPrefix.equals(s.m_groupPrefix)) {
            return false;
        }
        if ((this.m_flags & 8) > 0) {
            if (this.getMultiSubjectCount() != s.getMultiSubjectCount()) {
                return false;
            }
            Iterator<ISubject> i = s.getMultiSubjects();
            while (i.hasNext()) {
                ISubject thisComponent;
                ISubject testSubject = i.next();
                if (!(!strictMatch ? !this.m_multiSubjectTable.contains(testSubject) : !testSubject.strictlyEquals(thisComponent = this.m_multiSubjectTable.get(testSubject)))) continue;
                return false;
            }
            return true;
        }
        return this.m_subject == null || this.m_subject.equals(s.m_subject);
    }

    @Override
    public final boolean strictlyEquals(ISubject s) {
        if (s == null) {
            return false;
        }
        if (this == s) {
            return true;
        }
        return this.isEqualSubject((Subject)s, true);
    }

    @Override
    public final void saveMemory() {
        this.m_leveledSubject = null;
    }

    @Override
    public final boolean hasSubjectTracking() {
        return this.m_trackingType > 0;
    }

    @Override
    public final long getSubjectTracking() {
        return this.m_tracking;
    }

    @Override
    public final ISubject direct(String directedPrefix) {
        if (this.isMultiSubject()) {
            throw new EInvalidSubjectOperation("Can't direct a MultiSubject.");
        }
        ISubject ret = new Subject(directedPrefix + "." + this.m_subject).assignTrackingNumbers(this.m_tracking, this.m_trackingType);
        return ret;
    }

    @Override
    public final ISubject unDirect() {
        if (this.isMultiSubject()) {
            throw new EInvalidSubjectOperation("Can't undirect a MultiSubject!");
        }
        int unswizzledIndex = 0;
        for (int i = 0; i < 7; ++i) {
            unswizzledIndex = this.m_subject.indexOf(46, unswizzledIndex + 1);
        }
        ISubject ret = new Subject(this.m_subject.substring(unswizzledIndex + 1)).assignTrackingNumbers(this.m_tracking, this.m_trackingType);
        return ret;
    }

    private ISubject filterMultiSubjects(ISubject obj) {
        ISubject ret = this.m_multiSubjectTable.get(obj);
        if (ret == null && obj.isMultiSubject() && this.equals(obj)) {
            ret = this;
        }
        return ret;
    }

    private ISubject createMultiSubjectFromFilteredList(HashList<ISubject> filtered) {
        if (filtered == null || filtered.size() == 0) {
            return null;
        }
        if (filtered.size() == 1) {
            return filtered.iterator().next();
        }
        filtered.remove(this);
        int tempCount = 0;
        Iterator<ISubject> itFiltered = filtered.iterator();
        while (itFiltered.hasNext()) {
            ISubject filteredSubject = itFiltered.next();
            if (!filteredSubject.isTemporary()) continue;
            tempCount = (short)(tempCount + 1);
        }
        Subject ret = new Subject(this);
        ret.dirty();
        ret.m_multiSubjectTable = filtered;
        ret.m_tempSubjectCount = (short)tempCount;
        return ret;
    }

    @Override
    public final ISubject filterBySubject(Collection<ISubject> filter) {
        if (!this.isMultiSubject()) {
            if (filter.contains(this)) {
                return this.protectedClone();
            }
            return null;
        }
        HashList<ISubject> filtered = new HashList<ISubject>(filter.size());
        for (ISubject filterSubject : filter) {
            ISubject s = this.filterMultiSubjects(filterSubject);
            if (s == null) continue;
            filtered.add(s);
        }
        return this.createMultiSubjectFromFilteredList(filtered);
    }

    @Override
    public final ISubject filterBySubjectTracking(Collection<Short> filter) {
        if (!this.isMultiSubject()) {
            return null;
        }
        HashList<ISubject> filtered = new HashList<ISubject>(filter.size());
        Iterator<ISubject> components = this.getMultiSubjects();
        while (components.hasNext()) {
            ISubject s = components.next();
            if (!s.hasSubjectTracking() || !filter.contains(new Short((short)s.getSubjectTracking()))) continue;
            filtered.add(s);
        }
        if (filter.contains(new Short((short)this.getSubjectTracking()))) {
            filtered.add(this);
        }
        return this.createMultiSubjectFromFilteredList(filtered);
    }

    @Override
    public final Collection<Short> filteredTrackingNums(Collection<ISubject> filter) {
        ArrayList<Short> ret = null;
        for (ISubject filterSubject : filter) {
            ISubject s = this.filterMultiSubjects(filterSubject);
            if (s == null || !s.hasSubjectTracking()) continue;
            if (ret == null) {
                ret = new ArrayList<Short>(filter.size());
            }
            ret.add(new Short((short)s.getSubjectTracking()));
        }
        return ret;
    }

    public final ISubject filterTemporarySubjects() {
        if (this.m_tempSubjectCount > 0) {
            ISubject ret = this.protectedClone();
            Iterator<ISubject> i = ret.getMultiSubjects();
            while (i.hasNext()) {
                ISubject s = i.next();
                if (!s.isTemporary()) continue;
                i.remove();
            }
            if (ret.getMultiSubjectCount() == 0) {
                return new Subject();
            }
            return ret;
        }
        if (this.isTemporary()) {
            return new Subject();
        }
        return this;
    }

    @Override
    public final boolean hasIntersect(ISubject s) {
        Subject comp = (Subject)s;
        if (this.isMultiSubject() && comp.isMultiSubject()) {
            if (comp.m_multiSubjectTable.size() > this.m_multiSubjectTable.size()) {
                Iterator<ISubject> i = this.m_multiSubjectTable.iterator();
                while (i.hasNext()) {
                    if (!comp.m_multiSubjectTable.contains(i.next())) continue;
                    return true;
                }
                return false;
            }
            Iterator<ISubject> i = comp.m_multiSubjectTable.iterator();
            while (i.hasNext()) {
                if (!this.m_multiSubjectTable.contains(i.next())) continue;
                return true;
            }
            return false;
        }
        if (this.isMultiSubject()) {
            return this.m_multiSubjectTable.contains(s);
        }
        if (comp.isMultiSubject()) {
            return comp.m_multiSubjectTable.contains(this);
        }
        return this.equals(comp);
    }

    @Override
    public final ISubject complement(ISubject s, boolean wildMatch) {
        ISubject intersect = this.intersect(s, wildMatch);
        if (intersect == null) {
            return this.protectedClone();
        }
        if (!this.isMultiSubject()) {
            return null;
        }
        Subject ret = (Subject)this.protectedClone();
        if (intersect.isMultiSubject()) {
            Iterator<ISubject> removes = intersect.getMultiSubjects();
            while (removes.hasNext()) {
                ret.removeSubject(removes.next());
            }
        } else {
            ret.removeSubject(intersect);
        }
        return this.getSubjectWithMultiSubject(ret);
    }

    @Override
    public final ISubject intersect(ISubject s, boolean wildMatch) {
        Subject comp = (Subject)s;
        if (s == null || !this.isSubjectSet() || !s.isSubjectSet()) {
            return null;
        }
        if (this.isMultiSubject() && comp.isMultiSubject()) {
            Subject ret = this.createSubject();
            Iterator<ISubject> subjects = this.getMultiSubjects();
            while (subjects.hasNext()) {
                ISubject subject = subjects.next();
                ISubject intersect = subject.intersect(s, wildMatch);
                if (intersect == null) continue;
                ret.addSubject(subject);
            }
            return this.getSubjectWithMultiSubject(ret);
        }
        if (this.isMultiSubject()) {
            Subject ret = this.createSubject();
            if (!wildMatch && this.m_multiSubjectTable.contains(comp)) {
                ret.addSubject(this.m_multiSubjectTable.get(comp));
                return ret;
            }
            if (wildMatch) {
                Iterator<ISubject> subjects = this.getMultiSubjects();
                while (subjects.hasNext()) {
                    ISubject subject = subjects.next();
                    if (SubjectUtil.computeIntersectSubject(this, (ISubject)comp) == null) continue;
                    ret.addSubject(subject);
                }
            }
            return this.getSubjectWithMultiSubject(ret);
        }
        if (comp.isMultiSubject()) {
            if (comp.m_multiSubjectTable.contains(this)) {
                return this;
            }
            if (wildMatch) {
                Iterator<ISubject> compSubjects = comp.getMultiSubjects();
                while (compSubjects.hasNext()) {
                    ISubject compSubject = compSubjects.next();
                    if (SubjectUtil.computeIntersectSubject(this, compSubject) == null) continue;
                    return this.protectedClone();
                }
            }
        } else if (wildMatch ? SubjectUtil.computeIntersectSubject(this, (ISubject)comp) != null : this.equals(comp)) {
            return this;
        }
        return null;
    }

    private ISubject getSubjectWithMultiSubject(Subject ret) {
        if (ret.getMultiSubjectCount() == 0) {
            return null;
        }
        return ret;
    }

    private Subject createSubject() {
        Subject ret = new Subject(this);
        ret.m_multiSubjectTable = new HashList();
        ret.dirty();
        return ret;
    }

    public final String toString() {
        String ret = this.getSubjectString();
        if (this.hasSubjectTracking()) {
            ret = ret + "[trk: " + this.getSubjectTracking() + "]";
        }
        return ret;
    }

    public final String debugString() {
        try {
            if (this.isMultiSubject()) {
                String ret = "MULTI-SUBJECT of size: " + this.m_multiSubjectTable.size() + ":\n";
                Iterator<ISubject> i = this.getMultiSubjects();
                while (i.hasNext()) {
                    ret = ret + i.next().toString();
                }
                return ret;
            }
            return "Subject: " + this.m_subject + ", Match Vec: " + ArrayUtil.getHexString(this.m_matchVector) + ", Tracking: " + this.m_tracking + " (" + Long.toHexString(this.m_tracking) + ") -- type: " + this.m_trackingType + ", " + (this.hasGroup() ? "GROUP: " + this.getGroupName() : "") + ", UTF: " + this.m_subjectUTF + (this.m_subjectUTF != null ? "(" + StringUtil.UTFToString(this.m_subjectUTF, 0) + ")\n" : "\n");
        }
        catch (UTFDataFormatException ex) {
            return null;
        }
    }
}

