/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.server;

import com.sonicsw.blackbird.Version;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkFactory;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPNetworkLink;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.impl.HTTPConnection;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.HTTPMessage;
import com.sonicsw.blackbird.http.impl.HTTPMessageQueue;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import com.sonicsw.blackbird.http.impl.HTTPRequest;
import com.sonicsw.blackbird.http.impl.HTTPResponse;
import com.sonicsw.blackbird.http.impl.prAccessor;
import com.sonicsw.blackbird.http.server.IHTTPRequestHandler;
import com.sonicsw.blackbird.http.server.IHTTPServer;
import com.sonicsw.blackbird.http.server.IHTTPServerRequest;
import com.sonicsw.blackbird.http.server.IHTTPServerResponse;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.resources.prMessageFormat;

public class HTTPServer
implements IHTTPServer {
    public static final String SERVER_AGENT = "Sonic/Java-" + Version.getFullVersion();
    public final HashMap m_standardHeaders = new HashMap();
    private static final boolean DEBUG = HTTPConstants.DEBUG;
    private static final boolean DEBUG_WARN = true;
    private static final boolean DEBUG_UNEXPECTED = HTTPConstants.DEBUG_UNEXPECTED;
    private static final boolean DEBUG_LIFECYCLE = HTTPConstants.DEBUG_LIFECYCLE;
    private static final int STATE_INIT = 0;
    private static final int MAX_REQUESTS_PER_DISPATCH = 10;
    private static final int MAX_SERVER_THREADS = EvsHTTPNetworkLink.HTTP_MAX_SERVER_THREADS;
    INetworkLinkConfig m_config = null;
    private final HashMap m_handlers = new HashMap();
    private final AcceptContext m_acceptContext;
    ServerThread[] m_serverThreads = new ServerThread[MAX_SERVER_THREADS];
    private final String m_name;

    public HTTPServer(INetworkLinkConfig config) throws EEvsIOException {
        this.m_config = config;
        this.m_standardHeaders.put("Server", SERVER_AGENT);
        this.m_acceptContext = new AcceptContext();
        this.m_name = "Sonic HTTP Server: " + this.m_acceptContext.m_link.getLocalInetAddress().getHostName() + ":" + this.m_acceptContext.m_link.getLocalPort();
        for (int i = 1; i <= MAX_SERVER_THREADS; ++i) {
            this.m_serverThreads[i - 1] = new ServerThread(i);
        }
        this.m_acceptContext.attachToServerThread(this.m_serverThreads[0]);
    }

    @Override
    public void registerHandler(String path, IHTTPRequestHandler handler) {
        this.m_handlers.put(path.trim(), handler);
    }

    @Override
    public final void start() {
        for (int i = 0; i < this.m_serverThreads.length; ++i) {
            this.m_serverThreads[i].start();
        }
    }

    public final IEvsNetworkLink getServerLink() {
        return this.m_acceptContext.m_link;
    }

    @Override
    public final void close() {
        try {
            for (int i = 0; i < this.m_serverThreads.length; ++i) {
                this.m_serverThreads[i].close();
            }
        }
        finally {
            this.m_acceptContext.close();
        }
    }

    @Override
    public void addStandardHeader(String headerName, String headerVal) {
        this.m_standardHeaders.put(headerName, headerVal);
    }

    @Override
    public void removeStandardHeader(String headerName) {
        this.m_standardHeaders.remove(headerName);
    }

    private final void debug(String str) {
        this.debug(str, null);
    }

    private final void debug(String str, Throwable thrown) {
        String date = HTTPParseUtil.formatDate(System.currentTimeMillis(), new StringBuffer(32));
        if (thrown != null) {
            System.out.println("[" + date + "]" + this + str + ": Related Exception: " + thrown.getMessage());
            thrown.printStackTrace();
        } else {
            System.out.println("[" + date + "]" + this + str + " [Thread: " + Thread.currentThread().getName() + "]");
        }
    }

    public String toString() {
        return this.m_name;
    }

    final class HTTPServerResponse
    extends HTTPResponse
    implements IHTTPServerResponse {
        ConnectionContext m_context;

        HTTPServerResponse(HTTPConnection connection, int transportMode, ConnectionContext context) {
            super(connection, transportMode);
            this.m_context = null;
            this.m_context = context;
            this.setHeader("Server", SERVER_AGENT);
        }

        @Override
        public final void setHandled() {
            if (super.isHandled()) {
                return;
            }
            super.setHandled();
            this.m_context.onResponseHandled(this);
        }
    }

    public final class HTTPServerRequest
    extends HTTPRequest
    implements IHTTPServerRequest {
        IHTTPRequestHandler m_handler;
        ConnectionContext m_context;
        IHTTPServerResponse m_response;
        IHTTPServerResponse m_abortResponse;
        long m_timeReceived;
        private final Object m_readMutex;
        private boolean m_readWait;

        HTTPServerRequest(HTTPConnection connection, int transportMode, ConnectionContext context) {
            super(connection, transportMode);
            this.m_handler = null;
            this.m_context = null;
            this.m_response = null;
            this.m_abortResponse = null;
            this.m_timeReceived = -1L;
            this.m_readMutex = new Object();
            this.m_readWait = false;
            this.m_context = context;
        }

        private final void setHandler(IHTTPRequestHandler handler) {
            this.m_handler = handler;
        }

        private final IHTTPRequestHandler getHandler() {
            return this.m_handler;
        }

        public final String debugConnectionState() {
            return this.m_context.toString();
        }

        @Override
        public final void setHandled() {
            if (super.isHandled()) {
                return;
            }
            super.setHandled();
            this.m_context.onRequestHandled(this);
        }

        public final void setHTTPServerResponse(HTTPServerResponse response) {
            super.setHTTPResponse(response);
        }

        @Override
        public final IHTTPServerResponse getHTTPServerResponse() {
            return (IHTTPServerResponse)super.getResponse();
        }

        @Override
        public void setTimeReceived(long timeReceived) {
            this.m_timeReceived = timeReceived;
        }

        @Override
        public long getTimeReceived() {
            return this.m_timeReceived;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void waitForReadReady(EvsNetworkLinkResult result) throws InterruptedException {
            if (this.isHandled() || this.isFinished()) {
                if (DEBUG_UNEXPECTED) {
                    HTTPServer.this.debug("waitForReadReady called on finished request");
                }
                return;
            }
            if ((result.blockingOps & 1) == 1) {
                Object object = this.m_readMutex;
                synchronized (object) {
                    if (this.m_readWait) {
                        throw new IllegalStateException("Concurrent access to waitForReadReady is illegal");
                    }
                    try {
                        this.m_readWait = true;
                        if (this.m_context.addRequestReadWakeup(this)) {
                            if (DEBUG_UNEXPECTED) {
                                long start = System.currentTimeMillis();
                                long wait = Math.min(10000L, result.maxMsBeforeRetry);
                                this.m_readMutex.wait(wait);
                                long elapsed = System.currentTimeMillis() - start;
                                if (elapsed >= wait) {
                                    HTTPServer.this.debug("Waited for " + elapsed + " for read ready for: " + this);
                                }
                            } else {
                                this.m_readMutex.wait(result.maxMsBeforeRetry);
                            }
                        }
                    }
                    finally {
                        this.m_readWait = false;
                    }
                }
            }
            if (DEBUG_UNEXPECTED) {
                if (result.blockingOps != 0) {
                    HTTPServer.this.debug("waitForReadReady called without blocking read: " + result);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void wakeupReadWait() {
            Object object = this.m_readMutex;
            synchronized (object) {
                if (this.m_readWait) {
                    this.m_readMutex.notifyAll();
                }
            }
        }

        @Override
        public final IHTTPServerResponse buildNewResponse() {
            return new HTTPServerResponse(this.m_connection, 0, this.m_context);
        }

        @Override
        public final void abortRequest(IHTTPServerResponse response) {
            if (response == null) {
                return;
            }
            this.m_abortResponse = response;
            this.m_context.onRequestAbort(this);
        }
    }

    class ConnectionContext
    implements ISelectHandler {
        private static final int STATE_NEW_REQUEST = 0;
        private static final int STATE_REQUEST_READ = 1;
        private static final int STATE_HANDLE_REQUEST = 2;
        private static final int STATE_CLOSED = 3;
        int m_state = 0;
        private int m_requestLimit = 0;
        private HTTPConnection m_conn = null;
        private HTTPServerRequest m_request = null;
        private int m_interestOps = 1;
        private final EvsNetworkLinkResult m_netResult = new EvsNetworkLinkResult();
        private SelectionKey m_key = null;
        private boolean m_processing = false;
        private long m_lastRequestTime = 0L;
        private HTTPMessageQueue m_requestPipeline = new HTTPMessageQueue();
        private boolean m_wakeup = false;
        private int m_wakeupInterests = 0;
        private boolean m_wakeupReadRequest = false;
        private boolean m_readRequestWaiting = false;
        private SelectionKey m_wakeupKey = null;
        private final ISelectHandler m_wakeupHandler;
        private int m_selectId = 0;
        private ServerThread m_serverThread = null;

        ConnectionContext(HTTPConnection conn) throws EEvsIOException {
            this.m_conn = conn;
            this.m_wakeupHandler = new ISelectHandler(){

                @Override
                public final boolean onSelect(SelectionKey key, int selectId) {
                    return ConnectionContext.this.onWakeup(key, selectId);
                }

                @Override
                public final void closeIfIdle() {
                }

                @Override
                public final void close() {
                    ConnectionContext.this.close();
                }

                public final String toString() {
                    return "Wakeup Handler for: " + ConnectionContext.this.toString();
                }
            };
        }

        final void attachToServerThread(ServerThread serverThread) {
            this.m_key = serverThread.addSelectContext(this, this.m_conn.getChannel(), 1, true);
            this.m_serverThread = serverThread;
            this.m_lastRequestTime = this.m_serverThread.getDispatchTime();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public final boolean onSelect(SelectionKey key, int selectId) {
            block6: {
                if (this.m_state == 3) {
                    return true;
                }
                if (selectId != this.m_selectId) {
                    this.m_netResult.blockingOps = key == this.m_wakeupKey ? 0 : (this.m_netResult.blockingOps &= ~key.readyOps());
                    this.m_requestLimit = 10;
                    this.processRequestState();
                    this.processResponseState();
                }
                if (!this.m_readRequestWaiting) break block6;
                if (this.m_conn.hasReadDataBuffered()) ** GOTO lbl-1000
                if (key != this.m_wakeupKey) {
                    ** if ((key.readyOps() & 1) <= 0) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    this.m_request.wakeupReadWait();
                    this.m_interestOps &= ~1;
                    this.m_readRequestWaiting = false;
                    ** GOTO lbl20
                }
lbl-1000:
                // 2 sources

                {
                    this.m_interestOps |= 1;
                }
            }
            this.m_selectId = selectId;
            if (this.m_state == 3) {
                return true;
            }
            this.m_key.interestOps(this.m_interestOps);
            return (this.m_interestOps & 1) <= 0 || this.m_conn.hasReadDataBuffered() == false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onWakeup(SelectionKey key, int selectId) {
            if (this.m_state == 3) {
                return true;
            }
            ConnectionContext connectionContext = this;
            synchronized (connectionContext) {
                this.m_interestOps |= this.m_wakeupInterests;
                this.m_wakeupInterests = 0;
                this.m_wakeup = false;
                if (this.m_wakeupReadRequest) {
                    this.m_readRequestWaiting = true;
                    this.m_wakeupReadRequest = false;
                }
            }
            if (!this.onSelect(this.m_wakeupKey, selectId)) {
                connectionContext = this;
                synchronized (connectionContext) {
                    this.configWakeup();
                }
            }
            return true;
        }

        public final void onRequestHandled(HTTPServerRequest request) {
            this.addWakeupInterest(1, false);
        }

        public final void onResponseHandled(HTTPServerResponse response) {
            this.debugMessage(response);
            this.addWakeupInterest(response.isFinished() ? 0 : 4, false);
        }

        public final void onRequestAbort(HTTPServerRequest request) {
            this.debugMessage(request);
            this.addWakeupInterest(request.m_abortResponse.isFinished() ? 0 : 4, false);
        }

        private void debugMessage(HTTPMessage httpMessage) {
        }

        public final boolean addRequestReadWakeup(IHTTPServerRequest request) {
            return this.addWakeupInterest(1, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean addWakeupInterest(int interests, boolean readRequestSelect) {
            if (Thread.currentThread() == this.m_serverThread.getThread()) {
                this.m_interestOps |= interests;
                return false;
            }
            ConnectionContext connectionContext = this;
            synchronized (connectionContext) {
                if (this.m_state == 3) {
                    return false;
                }
                this.m_wakeupInterests |= interests;
                if (readRequestSelect) {
                    this.m_wakeupReadRequest = true;
                }
                this.configWakeup();
            }
            return true;
        }

        private void configWakeup() {
            if (!this.m_wakeup) {
                this.m_serverThread.wakeup(this.m_wakeupHandler);
                this.m_wakeup = true;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void processRequestState() {
            switch (this.m_state) {
                case 0: {
                    if (this.m_requestLimit == 0) {
                        return;
                    }
                    this.m_request = new HTTPServerRequest(this.m_conn, 1, this);
                    --this.m_requestLimit;
                    this.m_request.setHTTPServerResponse(new HTTPServerResponse(this.m_conn, 0, this));
                    this.m_state = 1;
                }
                case 1: {
                    if (!this.m_request.isHeaderFinished()) {
                        try {
                            if (!this.m_request.readMessageHeader(this.m_netResult)) {
                                this.m_interestOps |= this.m_netResult.blockingOps;
                                return;
                            }
                            this.m_interestOps &= 0xFFFFFFFE;
                        }
                        catch (EEvsIOException ex) {
                            this.close();
                            return;
                        }
                    }
                    this.m_requestPipeline.addMessage(this.m_request);
                    this.m_lastRequestTime = this.m_serverThread.getDispatchTime();
                    IHTTPRequestHandler handler = (IHTTPRequestHandler)HTTPServer.this.m_handlers.get(this.m_request.getRequestURI().getPath());
                    if (this.verifyRequest(this.m_request, handler)) {
                        this.m_request.setTimeReceived(this.m_serverThread.getDispatchTime());
                        try {
                            this.m_request.setHandler(handler.handleRequest(this.m_request));
                        }
                        catch (Throwable thrown) {
                            if (!DEBUG_UNEXPECTED) {
                                // empty if block
                            }
                            this.debug("ERROR in Request handler: " + handler + ", request: " + this.m_request, thrown);
                            this.m_request.setHandled();
                            IHTTPResponse response = this.m_request.getResponse();
                            response.setStatusCode((short)500);
                            response.setReasonPhrase("Internal Server Error - handler error");
                            response.setHeader("Connection", "close");
                            response.setHandled();
                        }
                    }
                    this.m_state = 2;
                }
                case 2: {
                    if (!this.m_request.isFinished()) {
                        if (!this.m_request.isHandled()) return;
                        try {
                            if (!this.m_request.skipBody(this.m_netResult)) {
                                if (DEBUG) {
                                    this.debug("Unable to finish skipping handled request body " + this.m_request);
                                }
                                this.m_interestOps |= this.m_netResult.blockingOps;
                                return;
                            }
                        }
                        catch (EEvsIOException ioe) {
                            if (DEBUG_UNEXPECTED || DEBUG_LIFECYCLE) {
                                this.debug("Closing connection because request body couldn't be skipped", ioe);
                            }
                            this.close();
                            return;
                        }
                    }
                    this.m_state = 0;
                    return;
                }
                case 3: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Invalid request state!");
                }
            }
        }

        private final boolean verifyRequest(HTTPServerRequest request, IHTTPRequestHandler handler) {
            IHTTPResponse response = null;
            if (handler == null) {
                response = request.getResponse();
                this.debug("No handler found, returning 404 Not Found for: " + this.m_request);
                this.m_request.setHandled();
                response.setStatusCode((short)404);
                response.setReasonPhrase("Not Found");
                response.setHandled();
                return false;
            }
            if (request.getHTTPMinorVersion() == 0) {
                if (DEBUG) {
                    this.debug(prMessageFormat.format(prAccessor.getString("Unsupported HTTP version in response: {0}. Expected HTTP/1.1"), new Object[]{request.getHTTPVersion()}));
                }
                if (request.getHeaderToken("Connection", "Keep-Alive")) {
                    request.getResponse().addHeader("Connection", "Keep-Alive");
                } else {
                    request.getResponse().addHeader("Connection", "close");
                }
            } else if (this.m_request.hasCloseHeader()) {
                this.m_request.getResponse().setHeader("Connection", "close");
            }
            return true;
        }

        private final void processResponseState() {
            if (this.m_state == 3) {
                return;
            }
            while (!this.m_requestPipeline.isEmtpy()) {
                HTTPServerRequest request = (HTTPServerRequest)this.m_requestPipeline.getFirst();
                HTTPResponse response = (HTTPServerResponse)request.getResponse();
                boolean responseReady = request.isHandled() && response.isHandled();
                boolean aborted = false;
                if (request.m_abortResponse != null && (!responseReady || ((HTTPServerResponse)request.m_abortResponse).isTransportStarted())) {
                    aborted = true;
                    response = (HTTPResponse)((Object)request.m_abortResponse);
                }
                if (!responseReady && !aborted) break;
                if (!response.isTransportStarted()) {
                    response.addHeader("Date", this.m_serverThread.getFormattedDate());
                }
                try {
                    if (response.finish(this.m_netResult)) {
                        if (DEBUG) {
                            this.debug("Removing handled request handled by response: " + response);
                        }
                        this.m_requestPipeline.removeFirst();
                        if (aborted && !request.isHandled()) {
                            if (DEBUG || DEBUG_UNEXPECTED) {
                                this.debug("Closing connection because of aborted unhandled request");
                            }
                            this.close();
                        }
                        if (!response.hasCloseHeader()) continue;
                        if (!DEBUG) break;
                        this.debug("wrote response with close header");
                        break;
                    }
                    if (DEBUG) {
                        this.debug("Unable to finish writing response: " + response);
                    }
                    this.m_interestOps |= this.m_netResult.blockingOps;
                    return;
                }
                catch (EEvsIOException ioe) {
                    if (DEBUG && !response.hasCloseHeader()) {
                        this.debug("Error finishing response, closing connection: " + response, ioe);
                    }
                    this.close();
                }
                break;
            }
            if (DEBUG_UNEXPECTED && this.m_requestPipeline.size() > 100) {
                this.debug("Large request pipeline on processResponseState");
            }
            this.m_interestOps &= 0xFFFFFFFB;
        }

        @Override
        public final void closeIfIdle() {
            long idleDebugThreshold;
            long idle;
            if (this.m_requestPipeline.isEmtpy()) {
                long idle2 = this.m_serverThread.getDispatchTime() - this.m_lastRequestTime;
                if (idle2 > HTTPServer.this.m_config.getHTTPServerConnectionIdleTimeout()) {
                    if (DEBUG_LIFECYCLE || DEBUG_UNEXPECTED) {
                        this.debug("Closing idle HTTP connection after no request received for " + idle2 + " ms");
                    }
                    this.close();
                }
            } else if (DEBUG_UNEXPECTED && (idle = this.m_serverThread.getDispatchTime() - this.m_lastRequestTime) > (idleDebugThreshold = HTTPServer.this.m_config.getHTTPServerConnectionIdleTimeout() * 3L)) {
                this.debug("UNEXPECTED connection idle for more than " + idleDebugThreshold + "ms!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() {
            block9: {
                ConnectionContext connectionContext = this;
                synchronized (connectionContext) {
                    if (this.m_state == 3) {
                        return;
                    }
                    this.m_state = 3;
                }
                if (DEBUG) {
                    this.debug("Closing HTTP Connection");
                }
                if (this.m_serverThread != null) {
                    this.m_serverThread.removeSelectContext(this, this.m_key, true);
                }
                try {
                    this.m_conn.close(new EvsNetworkLinkResult());
                }
                catch (EEvsIOException ex) {
                    if (!DEBUG_UNEXPECTED && !DEBUG) break block9;
                    this.debug("Error closing connection", ex);
                }
            }
            if (this.m_request != null) {
                this.m_request.wakeupReadWait();
            }
        }

        private final void debug(String str, Throwable thrown) {
            HTTPServer.this.debug(this.debugString() + ": " + str, thrown);
        }

        private final void debug(String str) {
            this.debug(str, null);
        }

        public final String debugString() {
            return this.toString() + " -- Interests: " + this.m_interestOps + " state: " + this.m_state + " pipeline: " + (this.m_requestPipeline.isEmtpy() ? "empty" : this.m_requestPipeline.toString()) + " Wakeup " + this.m_wakeup + "  wakeup interests: " + this.m_wakeupInterests;
        }

        public final String toString() {
            return "HTTP Server Connection from: " + this.m_conn.getRemoteInetAddress().getCanonicalHostName() + ":" + this.m_conn.getRemotePort() + " on " + HTTPServer.this.toString();
        }
    }

    class AcceptContext
    implements ISelectHandler {
        private IEvsNetworkLink m_link;
        private final EvsNetworkLinkResult m_linkResult = new EvsNetworkLinkResult();
        private SelectionKey m_key = null;
        private ServerThread m_serverThread;
        int m_nextServerThread = 1;
        private long m_nextLinkRetry = -1L;
        private static final long REESTABLISH_INTERVAL = 15000L;

        AcceptContext() throws EEvsIOException {
            this.m_link = EvsNetworkLinkFactory.create("tcp", 0, null, HTTPServer.this.m_config);
        }

        final void attachToServerThread(ServerThread serverThread) {
            this.m_serverThread = serverThread;
            this.m_key = serverThread.addSelectContext(this, this.m_link.getServerChannel(), 16, true);
        }

        @Override
        public final boolean onSelect(SelectionKey key, int selectId) {
            IEvsNetworkLink link = null;
            try {
                link = this.m_link.accept(this.m_linkResult);
            }
            catch (EEvsIOException ex) {
                HTTPServer.this.debug(prMessageFormat.format(prAccessor.getString("Exception in {0} - closing"), new Object[]{this.toString()}), ex);
                this.m_nextLinkRetry = this.m_serverThread.m_dispatchTimeStamp;
                this.close();
            }
            if (link != null) {
                HTTPConnection connection = new HTTPConnection();
                connection.setNetworkLink(link);
                try {
                    this.handleNewConnection(connection);
                }
                catch (EEvsIOException e) {
                    if (DEBUG || DEBUG_UNEXPECTED) {
                        HTTPServer.this.debug("Error handling new connection ... server thread closed");
                    }
                    try {
                        link.close(new EvsNetworkLinkResult(), true);
                    }
                    catch (EEvsIOException eEvsIOException) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        private final void handleNewConnection(HTTPConnection connection) throws EEvsIOException {
            if (DEBUG) {
                HTTPServer.this.debug("New connection received: " + connection);
            }
            EvsNetworkLink.LINK_INTERCEPTOR.onLinkEstablished(connection.getNetworkLink(), "HTTPServer - new connection");
            ConnectionContext cc = null;
            try {
                cc = new ConnectionContext(connection);
            }
            catch (EEvsIOException e) {
                if (DEBUG_UNEXPECTED) {
                    HTTPServer.this.debug("Unable initialize new connection!", e);
                }
                return;
            }
            if (this.m_nextServerThread == MAX_SERVER_THREADS) {
                this.m_nextServerThread = 0;
            }
            HTTPServer.this.m_serverThreads[this.m_nextServerThread].addNewConnection(cc);
            ++this.m_nextServerThread;
        }

        final long getNextLinkReestablishTime() {
            return this.m_nextLinkRetry;
        }

        final void reestablishLink() {
            block5: {
                if (this.m_nextLinkRetry > this.m_serverThread.m_dispatchTimeStamp) {
                    return;
                }
                try {
                    this.m_link = EvsNetworkLinkFactory.create("tcp", 0, null, HTTPServer.this.m_config);
                    HTTPServer.this.debug(prMessageFormat.format(prAccessor.getString("Reestablished: {0}"), new Object[]{this.toString()}));
                    this.m_nextLinkRetry = -1L;
                    this.attachToServerThread(HTTPServer.this.m_serverThreads[0]);
                }
                catch (EEvsIOException eeioe) {
                    this.m_nextLinkRetry = this.m_serverThread.m_dispatchTimeStamp + 15000L;
                    HTTPServer.this.debug(prMessageFormat.format(prAccessor.getString("Failed to reestablish: {0} will try again in {1}ms"), new Object[]{this.toString(), "15000"}), eeioe);
                    try {
                        this.m_link.close(this.m_linkResult, true);
                    }
                    catch (EEvsIOException ioe) {
                        if (!DEBUG_UNEXPECTED) break block5;
                        HTTPServer.this.debug("Error closing unestablished http server link for " + this, ioe);
                    }
                }
            }
        }

        @Override
        public final void closeIfIdle() {
        }

        @Override
        public final void close() {
            block2: {
                this.m_serverThread.removeSelectContext(this, this.m_key, true);
                try {
                    this.m_link.close(new EvsNetworkLinkResult(), true);
                }
                catch (EEvsIOException e) {
                    if (!DEBUG_UNEXPECTED && !DEBUG_LIFECYCLE) break block2;
                    HTTPServer.this.debug("Error closing " + this, e);
                }
            }
        }

        public final String toString() {
            return "Acceptor for " + HTTPServer.this.toString();
        }
    }

    static interface ISelectHandler {
        public boolean onSelect(SelectionKey var1, int var2);

        public void closeIfIdle();

        public void close();
    }

    class ServerThread
    implements Runnable {
        private final Selector m_selector;
        private final HashSet m_handlers = new HashSet();
        private final Thread m_thread;
        private final String m_name;
        private final LinkedList[] m_connections = new LinkedList[]{new LinkedList(), new LinkedList()};
        private final LinkedList[] m_wakeupOps = new LinkedList[]{new LinkedList(), new LinkedList()};
        int m_listIndex = 0;
        int[] toggle = new int[]{1, 0};
        private boolean m_started = false;
        private boolean m_closed = false;
        private long m_dispatchTimeStamp = 0L;
        private final StringBuffer m_dateBuffer = new StringBuffer(32);
        private long m_formattedTimeStamp = 0L;
        private String m_formattedDate = null;
        private long m_lastIdleCheck = 0L;
        private long m_idleCheckRemaining;
        private final boolean m_ownsAcceptor;

        private ServerThread(int id) throws EEvsIOException {
            this.m_idleCheckRemaining = HTTPServer.this.m_config.getHTTPServerConnectionIdleTimeout();
            try {
                this.m_name = HTTPServer.this.toString() + " Dispatcher " + id;
                this.m_thread = new Thread((Runnable)this, this.m_name);
                this.m_selector = Selector.open();
                this.m_ownsAcceptor = id == 1;
            }
            catch (IOException e) {
                throw new EEvsIOException(e.getMessage(), (Exception)e);
            }
        }

        public final String toString() {
            return this.m_name;
        }

        final synchronized void start() {
            if (this.m_started) {
                return;
            }
            this.m_started = true;
            this.m_thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int m_selectId = 0;
                while (!this.m_closed && this.m_selector.isOpen()) {
                    Object key;
                    try {
                        if (this.m_selector.selectedKeys().isEmpty()) {
                            if (this.m_ownsAcceptor && HTTPServer.this.m_acceptContext.getNextLinkReestablishTime() > 0L) {
                                long nlrt = HTTPServer.this.m_acceptContext.getNextLinkReestablishTime() - this.m_dispatchTimeStamp;
                                if (nlrt <= 0L) {
                                    this.m_selector.selectNow();
                                } else {
                                    this.m_selector.select(Math.min(this.m_idleCheckRemaining, nlrt));
                                }
                            } else {
                                this.m_selector.select(this.m_idleCheckRemaining);
                            }
                        } else {
                            this.m_selector.selectNow();
                        }
                    }
                    catch (IOException ex) {
                        HTTPServer.this.debug("Server thread select error", ex);
                    }
                    this.m_dispatchTimeStamp = System.currentTimeMillis();
                    if (this.m_dispatchTimeStamp - this.m_formattedTimeStamp > 1000L) {
                        this.m_formattedTimeStamp = this.m_dispatchTimeStamp;
                        this.m_formattedDate = null;
                    }
                    try {
                        Iterator<SelectionKey> readySet = this.m_selector.selectedKeys().iterator();
                        while (readySet.hasNext()) {
                            key = readySet.next();
                            ISelectHandler context = (ISelectHandler)((SelectionKey)key).attachment();
                            boolean done = true;
                            try {
                                done = context.onSelect((SelectionKey)key, m_selectId);
                            }
                            catch (RuntimeException re) {
                                this.debugMessageAndCloseContext(context, re);
                            }
                            if (!done) continue;
                            readySet.remove();
                        }
                    }
                    catch (ClosedSelectorException cse) {
                        break;
                    }
                    int listIndex = this.m_listIndex;
                    key = this;
                    synchronized (key) {
                        this.m_listIndex = this.toggle[this.m_listIndex];
                    }
                    LinkedList conns = this.m_connections[listIndex];
                    while (!conns.isEmpty()) {
                        ((ConnectionContext)conns.removeFirst()).attachToServerThread(this);
                    }
                    LinkedList wakeups = this.m_wakeupOps[listIndex];
                    while (!wakeups.isEmpty()) {
                        ISelectHandler handler = (ISelectHandler)wakeups.removeFirst();
                        try {
                            handler.onSelect(null, m_selectId);
                        }
                        catch (RuntimeException re) {
                            this.debugMessageAndCloseContext(handler, re);
                        }
                    }
                    this.m_idleCheckRemaining = HTTPServer.this.m_config.getHTTPServerConnectionIdleTimeout() - (this.m_dispatchTimeStamp - this.m_lastIdleCheck);
                    if (this.m_idleCheckRemaining <= 0L) {
                        if (DEBUG) {
                            HTTPServer.this.debug("Performing IDLE connection check after: " + (this.m_dispatchTimeStamp - this.m_lastIdleCheck) + "ms");
                        }
                        this.m_lastIdleCheck = this.m_dispatchTimeStamp;
                        this.m_idleCheckRemaining = HTTPServer.this.m_config.getHTTPServerConnectionIdleTimeout();
                        Iterator handlers = ((HashSet)this.m_handlers.clone()).iterator();
                        while (handlers.hasNext()) {
                            ((ISelectHandler)handlers.next()).closeIfIdle();
                        }
                    }
                    if (this.m_ownsAcceptor && HTTPServer.this.m_acceptContext.getNextLinkReestablishTime() > 0L) {
                        HTTPServer.this.m_acceptContext.reestablishLink();
                    }
                    ++m_selectId;
                }
            }
            catch (RuntimeException re) {
                HTTPServer.this.debug(prMessageFormat.format(prAccessor.getString("Exception in {0} closing"), new Object[]{this.m_thread.getName()}), re);
            }
            this.closeInternal(false);
            for (ISelectHandler context : (HashSet)this.m_handlers.clone()) {
                context.close();
            }
            LinkedList conns = this.m_connections[this.m_listIndex];
            while (!conns.isEmpty()) {
                ((ConnectionContext)conns.removeFirst()).close();
            }
            LinkedList conns2 = this.m_connections[this.toggle[this.m_listIndex]];
            while (!conns2.isEmpty()) {
                ((ConnectionContext)conns2.removeFirst()).close();
            }
            this.m_handlers.clear();
            this.m_wakeupOps[0].clear();
            this.m_wakeupOps[1].clear();
            this.m_connections[0].clear();
            this.m_connections[1].clear();
            if (DEBUG_LIFECYCLE) {
                HTTPServer.this.debug(this + " exiting");
            }
        }

        private void debugMessageAndCloseContext(ISelectHandler context, RuntimeException re) {
            HTTPServer.this.debug(prMessageFormat.format(prAccessor.getString("Exception in {0} closing"), new Object[]{context.toString()}), re);
            context.close();
        }

        final long getDispatchTime() {
            return this.m_dispatchTimeStamp;
        }

        final String getFormattedDate() {
            if (this.m_formattedDate == null) {
                this.m_formattedDate = HTTPParseUtil.formatDate(this.m_dispatchTimeStamp, this.m_dateBuffer);
                if (DEBUG) {
                    HTTPServer.this.debug("Formatted date updated: " + this.m_formattedDate);
                }
            }
            return this.m_formattedDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void wakeup(ISelectHandler wakeupHandler) {
            ServerThread serverThread = this;
            synchronized (serverThread) {
                this.addConnectionsWakeupSelector(this.m_wakeupOps, wakeupHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addNewConnection(ConnectionContext c) throws EEvsIOException {
            ServerThread serverThread = this;
            synchronized (serverThread) {
                if (this.m_closed) {
                    throw new EEvsIOException("closed");
                }
                this.addConnectionsWakeupSelector(this.m_connections, c);
            }
        }

        private void addConnectionsWakeupSelector(LinkedList[] m_connections, ISelectHandler c) {
            m_connections[this.m_listIndex].add(c);
            if (m_connections[this.m_listIndex].size() == 1) {
                this.m_selector.wakeup();
            }
        }

        final SelectionKey addSelectContext(ISelectHandler handler, SelectableChannel channel, int ops, boolean register) {
            try {
                SelectionKey ret = channel.register(this.m_selector, ops, handler);
                if (register) {
                    this.m_handlers.add(handler);
                }
                return ret;
            }
            catch (ClosedChannelException ex) {
                if (DEBUG_UNEXPECTED) {
                    HTTPServer.this.debug("Channel closed before it could be added to the server thread", ex);
                }
                return null;
            }
        }

        final void removeSelectContext(ISelectHandler handler, SelectionKey key, boolean unregister) {
            if (!this.m_closed) {
                if (unregister) {
                    this.m_handlers.remove(handler);
                }
                key.cancel();
            }
        }

        final void close() {
            this.closeInternal(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void closeInternal(boolean join) {
            block11: {
                if (DEBUG_LIFECYCLE) {
                    HTTPServer.this.debug("Closing server thread: " + this.toString());
                }
                ServerThread serverThread = this;
                synchronized (serverThread) {
                    this.m_closed = true;
                    this.start();
                }
                this.m_selector.wakeup();
                if (join) {
                    try {
                        if (DEBUG_LIFECYCLE) {
                            HTTPServer.this.debug("Joining server thread: " + this.toString());
                        }
                        this.m_thread.join();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    this.m_selector.close();
                }
                catch (IOException ioe) {
                    if (!DEBUG_LIFECYCLE) break block11;
                    HTTPServer.this.debug("Error closing selector.", ioe);
                }
            }
            if (DEBUG_LIFECYCLE) {
                HTTPServer.this.debug("Closed server thread: " + this.toString());
            }
        }

        final Thread getThread() {
            return this.m_thread;
        }
    }
}

