/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor;

import com.sonicsw.interceptor.SimpleContext;
import com.sonicsw.interceptor.pointcuts.JMSPointCut;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class JMSMessageContext
extends SimpleContext
implements JMSPointCut.IJMSMessageContext {
    private Message m_msg = null;

    public JMSMessageContext(Message msg) {
        this.m_msg = msg;
    }

    @Override
    public Object getMessage() {
        return this.m_msg;
    }

    @Override
    public String getMessageID() {
        String id = null;
        try {
            id = this.m_msg.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return id;
    }

    @Override
    public String getDestination() {
        Destination dest = null;
        try {
            dest = this.m_msg.getJMSDestination();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return dest == null ? null : dest.toString();
    }

    @Override
    public void setBrokerName(String broker) {
        this.setProperty("BROKER_NAME_ATTR", broker);
    }

    @Override
    public String getBrokerName() {
        return (String)this.getProperty("BROKER_NAME_ATTR");
    }

    @Override
    public void setEndpointURL(String endpoint) {
        this.setProperty("ENDPOINT_URL_ATTR", endpoint);
    }

    @Override
    public String getEndpointURL() {
        return (String)this.getProperty("ENDPOINT_URL_ATTR");
    }

    @Override
    public String getMessageProducer() {
        return (String)this.getProperty("MESSAGE_PRODUCER_ATTR");
    }

    @Override
    public void setMessageProducer(String producer) {
        this.setProperty("MESSAGE_PRODUCER_ATTR", producer);
    }

    @Override
    public String getMessageConsumer() {
        return (String)this.getProperty("MESSAGE_CONSUMER_ATTR");
    }

    @Override
    public void setMessageConsumer(String consumer) {
        this.setProperty("MESSAGE_CONSUMER_ATTR", consumer);
    }

    @Override
    public Object getProperty(String name) {
        Object ret = super.getProperty(name);
        if (ret == null) {
            try {
                ret = this.m_msg.getObjectProperty(name);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public boolean containsProperty(String name) {
        boolean ret = super.containsProperty(name);
        if (!ret) {
            try {
                if (this.m_msg.getObjectProperty(name) != null) {
                    ret = true;
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return ret;
    }
}

