/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.advisors;

import com.sonicsw.interceptor.IAdvisor;
import com.sonicsw.interceptor.IContext;
import com.sonicsw.interceptor.IInterceptor;
import com.sonicsw.interceptor.pointcuts.AgentPointCut;
import java.util.ArrayList;

public class AgentAdvisor
extends AgentPointCut
implements IAdvisor {
    private static AgentAdvisor s_instance = null;
    private ArrayList m_interceptors = new ArrayList();

    public static synchronized AgentAdvisor getInstance() {
        if (s_instance == null) {
            s_instance = new AgentAdvisor();
        }
        return s_instance;
    }

    private AgentAdvisor() {
    }

    @Override
    public boolean addInterceptor(IInterceptor interceptor) {
        if (interceptor instanceof AgentPointCut) {
            this.m_interceptors.add(interceptor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(int type) throws UnsupportedOperationException {
        ArrayList arrayList = this.m_interceptors;
        synchronized (arrayList) {
            if (!this.m_interceptors.isEmpty()) {
                for (IInterceptor interceptor : this.m_interceptors) {
                    if (type != 1 || !(interceptor instanceof AgentPointCut)) continue;
                    this.m_interceptors.remove(interceptor);
                }
            }
        }
    }

    @Override
    public int getAdvisorType() {
        return 1;
    }

    @Override
    public void onNewConnection(IContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            AgentPointCut interceptor = (AgentPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onNewConnection(param);
        }
    }

    @Override
    public void onNewSession(IContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            AgentPointCut interceptor = (AgentPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onNewSession(param);
        }
    }

    @Override
    public void onNewTempQueue(IContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            AgentPointCut interceptor = (AgentPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onNewTempQueue(param);
        }
    }
}

