/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.advisors;

import com.sonicsw.interceptor.IAdvisor;
import com.sonicsw.interceptor.IInterceptor;
import com.sonicsw.interceptor.pointcuts.JMSPointCut;
import java.util.ArrayList;

public class JMSAdvisor
extends JMSPointCut
implements IAdvisor {
    private static JMSAdvisor s_instance = null;
    private ArrayList m_interceptors = new ArrayList();

    public static synchronized JMSAdvisor getInstance() {
        if (s_instance == null) {
            s_instance = new JMSAdvisor();
        }
        return s_instance;
    }

    private JMSAdvisor() {
    }

    @Override
    public boolean addInterceptor(IInterceptor interceptor) {
        if (interceptor instanceof JMSPointCut) {
            this.m_interceptors.add(interceptor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(int type) throws UnsupportedOperationException {
        ArrayList arrayList = this.m_interceptors;
        synchronized (arrayList) {
            if (!this.m_interceptors.isEmpty()) {
                for (IInterceptor interceptor : this.m_interceptors) {
                    if (type != 101 || !(interceptor instanceof JMSPointCut)) continue;
                    this.m_interceptors.remove(interceptor);
                }
            }
        }
    }

    @Override
    public int getAdvisorType() {
        return 101;
    }

    @Override
    public void onTopicMessageReceived(JMSPointCut.IJMSMessageContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            JMSPointCut interceptor = (JMSPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onTopicMessageReceived(param);
        }
    }

    @Override
    public void onQueueMessageReceived(JMSPointCut.IJMSMessageContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            JMSPointCut interceptor = (JMSPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onQueueMessageReceived(param);
        }
    }

    @Override
    public void onTopicMessageSent(JMSPointCut.IJMSMessageContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            JMSPointCut interceptor = (JMSPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onTopicMessageSent(param);
        }
    }

    @Override
    public void onQueueMessageSent(JMSPointCut.IJMSMessageContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            JMSPointCut interceptor = (JMSPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onQueueMessageSent(param);
        }
    }
}

