/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.impls.actional;

import com.actional.lg.interceptor.sdk.Interaction;
import com.actional.lg.interceptor.sdk.UplinkConfig;
import com.sonicsw.interceptor.IInterceptor;
import com.sonicsw.interceptor.impls.actional.Config;
import com.sonicsw.interceptor.impls.actional.P2PInterceptor;
import com.sonicsw.interceptor.impls.actional.PubSubInterceptor;
import com.sonicsw.interceptor.pointcuts.JMSPointCut;
import com.sonicsw.mq.components.BrokerComponent;
import java.util.Properties;

public class LGJMSServerInterceptor
extends JMSPointCut
implements IInterceptor {
    private JMSPointCut m_p2pDelegate = new P2PInterceptor();
    private JMSPointCut m_pubSubDelegate = new PubSubInterceptor();
    private transient boolean m_agentAvailable = true;

    public static boolean isAgentAlive() {
        return UplinkConfig.getCurrent().getAlive();
    }

    @Override
    public boolean init(Properties params) {
        Config.loadConfig(params);
        if (Config.LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_NONE")) {
            BrokerComponent.getComponentContext().logMessage("Actional instrumentation is enabled with payload capture disabled", 3);
        } else if (Config.LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_HEADER")) {
            BrokerComponent.getComponentContext().logMessage("Actional instrumentation is enabled with payload capture enabled for message header", 3);
        } else if (Config.LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_BODY")) {
            BrokerComponent.getComponentContext().logMessage("Actional instrumentation is enabled with payload capture enabled for message body", 3);
        } else if (Config.LG_INCLUDE_PAYLOAD.equalsIgnoreCase("PAYLOAD_CAPTURE_ATTR_ALL")) {
            BrokerComponent.getComponentContext().logMessage("Actional instrumentation is enabled with payload capture enabled for message header & body", 3);
        }
        BrokerComponent.getComponentContext().logMessage("Loaded Actional SDK " + Interaction.class.getPackage().getImplementationVersion(), 3);
        this.m_agentAvailable = LGJMSServerInterceptor.isAgentAlive();
        if (this.m_agentAvailable) {
            BrokerComponent.getComponentContext().logMessage("Successfully connected to Actional agent", 3);
        } else {
            BrokerComponent.getComponentContext().logMessage("Unable to reach Actional agent", 2);
        }
        return true;
    }

    private void checkOnAgent() {
        try {
            boolean agentAvailabilityChanged = false;
            if (!LGJMSServerInterceptor.isAgentAlive()) {
                if (this.m_agentAvailable) {
                    agentAvailabilityChanged = true;
                }
                this.m_agentAvailable = false;
                if (agentAvailabilityChanged) {
                    BrokerComponent.getComponentContext().logMessage("Unable to reach Actional agent", 2);
                }
            } else {
                if (!this.m_agentAvailable) {
                    agentAvailabilityChanged = true;
                }
                this.m_agentAvailable = true;
                if (agentAvailabilityChanged) {
                    BrokerComponent.getComponentContext().logMessage("Successfully connected to Actional agent", 3);
                }
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    @Override
    public void onTopicMessageReceived(JMSPointCut.IJMSMessageContext context) {
        this.checkOnAgent();
        if (this.m_pubSubDelegate != null) {
            this.m_pubSubDelegate.onTopicMessageReceived(context);
            return;
        }
    }

    @Override
    public void onTopicMessageSent(JMSPointCut.IJMSMessageContext context) {
        this.checkOnAgent();
        if (this.m_pubSubDelegate != null) {
            this.m_pubSubDelegate.onTopicMessageSent(context);
            return;
        }
    }

    @Override
    public void onQueueMessageSent(JMSPointCut.IJMSMessageContext context) {
        this.checkOnAgent();
        if (this.m_p2pDelegate != null) {
            this.m_p2pDelegate.onQueueMessageSent(context);
            return;
        }
    }

    @Override
    public void onQueueMessageReceived(JMSPointCut.IJMSMessageContext context) {
        this.checkOnAgent();
        if (this.m_p2pDelegate != null) {
            this.m_p2pDelegate.onQueueMessageReceived(context);
            return;
        }
    }
}

