/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.impls.actional;

import com.actional.lg.interceptor.sdk.ClientInteraction;
import com.actional.lg.interceptor.sdk.Interaction;
import com.actional.lg.interceptor.sdk.ServerInteraction;
import com.sonicsw.interceptor.impls.actional.InteractionHelper;
import com.sonicsw.interceptor.pointcuts.JMSPointCut;
import progress.message.msg.IMgram;

public class P2PInterceptor
extends JMSPointCut {
    @Override
    public void onTopicMessageSent(JMSPointCut.IJMSMessageContext param) {
        throw new AssertionError((Object)"Error invoking onTopicMessageSent() on the p2p interceptor.");
    }

    @Override
    public void onTopicMessageReceived(JMSPointCut.IJMSMessageContext param) {
        throw new AssertionError((Object)"Error invoking onTopicMessageReceived() on the p2p interceptor.");
    }

    @Override
    public void onQueueMessageReceived(JMSPointCut.IJMSMessageContext context) {
        IMgram msg = (IMgram)context.getMessage();
        ServerInteraction si = InteractionHelper.beginServerInteractionOnReceived(msg);
        if (si == null) {
            return;
        }
        InteractionHelper.populateInteraction((Interaction)si, (String)context.getProperty("PEER_ADDRESS_ATTR"), (String)context.getProperty("PEER_TYPE_ATTR"), (String)context.getProperty("SERVICE_URL_ATTR"), (String)context.getProperty("NGSO_GROUP_ATTR"), (String)context.getProperty("NGSO_SERVICE_ATTR"), null);
        String payloadType = (String)context.getProperty("PAYLOAD_CAPTURE_ATTR");
        InteractionHelper.setPayload((Interaction)si, msg, payloadType);
        InteractionHelper.traceInteraction("onQueueMessageReceived", (Interaction)si);
        InteractionHelper.addParentInteractionToMessage(si, msg);
        si.end();
    }

    @Override
    public void onQueueMessageSent(JMSPointCut.IJMSMessageContext context) {
        IMgram msg = (IMgram)context.getMessage();
        ServerInteraction si = InteractionHelper.resumeServerInteractionOnDelivery(msg);
        if (si == null) {
            return;
        }
        InteractionHelper.traceInteraction("onQueueMessageSent", (Interaction)si);
        ClientInteraction ci = ClientInteraction.begin();
        InteractionHelper.populateInteraction((Interaction)ci, (String)context.getProperty("PEER_ADDRESS_ATTR"), (String)context.getProperty("PEER_TYPE_ATTR"), (String)context.getProperty("SERVICE_URL_ATTR"), (String)context.getProperty("NGSO_GROUP_ATTR"), (String)context.getProperty("NGSO_SERVICE_ATTR"), (String)context.getProperty("NGSO_OPERATION_ATTR"));
        InteractionHelper.traceInteraction("onQueueMessageSent", (Interaction)ci);
        InteractionHelper.writeLGHeaderToMessage(ci, msg);
        String payloadType = (String)context.getProperty("PAYLOAD_CAPTURE_ATTR");
        InteractionHelper.setPayload((Interaction)ci, msg, payloadType);
        ci.requestAnalyzed();
        ci.end();
        si.end();
    }
}

