/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.license;

import progress.message.util.license.LicenseDecoder;

public final class ProductDecoder {
    private static final int PDTCODE_35 = 35;
    private static final int PDTCODE_43 = 43;
    private static final int PDTCODE_3117 = 3117;
    private static final int PDTCODE_3204 = 3204;
    private static final int PDTCODE_2022 = 2022;
    private static final int PDTCODE_2023 = 2023;
    private static final int PDTCODE_2029 = 2029;
    private static final int PDTCODE_2486 = 2486;
    private static final int PDTCODE_2487 = 2487;
    private static final int PDTCODE_6521 = 6521;
    private static final int PDTCODE_7703 = 7703;
    private static final int PDTCODE_7704 = 7704;
    private static final int PDTCODE_7708 = 7708;
    private static final int PDTCODE_7710 = 7710;
    private static final int PDTCODE_9117 = 9117;
    private static final int PDTCODE_9704 = 9704;
    public static final int MAX_CONN_HARD_LIMIT = 1500;
    public static final int PDTCODE_LIMITED = 35;
    public static final int PDTCODE_ENTERPRISE = 43;
    public static final int PDTCODE_PROFDEVELOPER = 3117;
    public static final int PDTCODE_STANDARD = 3204;
    public static final int PDTCODE_EVALUATION_EDITION = 7703;
    public static final int PDTCODE_FT_EVALUATION_EDITION = 7704;
    public static final int PDTCODE_FT = 2486;
    public static final int PDTCODE_REMOTE_SITE = 2487;
    public static final int PDTCODE_OEM_STANDARD = 2022;
    public static final int PDTCODE_OEM_PROFDEVELOPER = 2023;
    public static final int PDTCODE_OEM_ENTERPRISE = 2029;
    public static final int PDTCODE_OEM_FT = 6521;
    public static final int PDTCODE_PROFDEVELOPER_PARTNER_EDITION = 7708;
    public static final int PDTCODE_FT_PARTNER_EDITION = 7710;
    public static final int PDTCODE_ENTERPRISE_DEVELOPER_EDITION = 9117;
    public static final int PDTCODE_ENTERPRISE_EVALUATION_EDITION = 9704;
    private static final int[] PRODUCT_CODES = new int[]{35, 43, 9117, 9704, 3117, 3204, 7703, 7704, 2486, 2487, 2022, 2023, 2029, 6521, 7708, 7710};
    private static final String[] PRODUCT_NAMES = new String[]{"SonicMQ Limited Edition", "SonicMQ Enterprise Edition", "SonicMQ Enterprise Developer Edition", "SonicMQ Enterprise Evaluation Edition", "SonicMQ Professional Developer Edition", "SonicMQ Standard Edition", "SonicMQ Evaluation Edition", "SonicMQ Continuous Availability Evaluation Edition", "SonicMQ Continuous Availability Edition", "SonicMQ Remote Site Edition", "SonicMQ OEM Standard Edition", "SonicMQ OEM Professional Developer Edition", "SonicMQ OEM Enterprise Edition", "SonicMQ OEM Continuous Availability Edition", "SonicMQ Professional Developer Edition for Partners", "SonicMQ Continuous Availability Edition for Partners"};
    public static final String FEATURE_ENTERPRISE = "Enterprise";
    public static final String FEATURE_EVAL_MODE = "Evaluation Mode";
    public static final String FEATURE_EVAL_PERIOD = "Evaluation Period";
    public static final String FEATURE_EXPIRES = "Expires";
    public static final String FEATURE_EXPIRATION_MONTH = "Expiration Month";
    public static final String FEATURE_EXPIRATION_YEAR = "Expiration Year";
    public static final String FEATURE_INTERBROKER = "Enable Interbroker";
    public static final String FEATURE_DRA = "Enable Dynamic Routing";
    public static final String FEATURE_HTTP_DIRECT = "Enable HTTP Direct";
    public static final String FEATURE_FT = "Enable Fault Tolerance";
    public static final String FEATURE_MAX_CONNECTIONS = "Max Connections";
    public static final String FEATURE_MAX_IP_ADDRESSES = "Max IP Addresses";
    private static final String[] FEATURE_LIST = new String[]{"Enterprise", "Evaluation Mode", "Evaluation Period", "Expires", "Expiration Month", "Expiration Year", "Enable Interbroker", "Enable Dynamic Routing", "Enable HTTP Direct", "Enable Fault Tolerance", "Max Connections", "Max IP Addresses"};
    private String m_controlNumber;
    private String m_version;
    private int m_productCode = -1;
    private int m_count = -1;
    private int m_serial = -1;
    private int m_productIndex = -1;
    private boolean m_enterprise = false;
    private boolean m_eval = false;
    private int m_evalPeriod = -1;
    private int m_maxConnections = -1;
    private int m_maxIPAddresses = -1;
    private boolean m_interbrokerAllowed = false;
    private boolean m_routingAllowed = false;
    private boolean m_httpDirectAllowed = false;
    private boolean m_faultToleranceAllowed = false;
    private boolean m_hasExpiration = false;
    private int m_expirationMonth = -1;
    private int m_expirationYear = -1;

    public ProductDecoder(String version, String controlNumber) throws Exception {
        this.m_controlNumber = controlNumber;
        this.m_version = version;
        LicenseDecoder ld = new LicenseDecoder(this.m_version, this.m_controlNumber);
        this.validate(ld);
    }

    protected void validate(LicenseDecoder ld) {
        int pdtCode = ld.getProduct();
        for (int i = 0; i < PRODUCT_CODES.length; ++i) {
            if (pdtCode != PRODUCT_CODES[i]) continue;
            this.m_productIndex = i;
            break;
        }
        this.m_productCode = pdtCode;
        this.m_count = ld.getCount();
        this.m_serial = ld.getSerial();
        switch (this.m_productCode) {
            case 35: {
                this.m_maxIPAddresses = this.m_count;
                break;
            }
            case 2487: {
                this.m_maxIPAddresses = this.m_count >> 8;
                this.m_routingAllowed = true;
                break;
            }
            case 43: 
            case 9117: {
                this.m_enterprise = true;
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 9704: {
                this.m_eval = true;
                this.m_evalPeriod = this.m_count;
                this.m_enterprise = true;
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 3117: {
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 7703: {
                this.m_eval = true;
                this.m_evalPeriod = this.m_count;
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = false;
                break;
            }
            case 7704: {
                this.m_eval = true;
                this.m_evalPeriod = this.m_count;
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 3204: {
                break;
            }
            case 2022: {
                break;
            }
            case 2023: {
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 2029: {
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                break;
            }
            case 6521: {
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 2486: {
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 7708: {
                this.m_hasExpiration = true;
                this.m_expirationMonth = this.m_count >> 12;
                this.m_expirationYear = this.m_count & 0xFFF;
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
            case 7710: {
                this.m_hasExpiration = true;
                this.m_expirationMonth = this.m_count >> 12;
                this.m_expirationYear = this.m_count & 0xFFF;
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
                break;
            }
        }
        switch (this.m_productCode) {
            case 35: {
                this.m_maxConnections = 100;
                break;
            }
            case 2487: {
                this.m_maxConnections = this.m_count & 0xFF;
                break;
            }
            case 43: 
            case 9117: 
            case 9704: {
                this.m_maxConnections = -1;
                this.m_enterprise = true;
                break;
            }
            default: {
                this.m_maxConnections = Boolean.getBoolean("SonicMQ.legacy.connection.limiting") ? -1 : 1500;
                this.m_enterprise = false;
            }
        }
    }

    public final String getControlNumber() {
        return this.m_controlNumber;
    }

    public final String getVersion() {
        return this.m_version;
    }

    public final int getProductCode() {
        return this.m_productCode;
    }

    public final boolean checkProductCode() {
        return this.m_productIndex >= 0;
    }

    public final int getSerialNumber() {
        return this.m_serial;
    }

    public final int getCount() {
        return this.m_count;
    }

    public final String getProductName() {
        if (this.m_productIndex < 0) {
            return null;
        }
        return PRODUCT_NAMES[this.m_productIndex];
    }

    public final boolean isEvaluationMode() {
        return this.m_eval;
    }

    public boolean isEnterprise() {
        return this.m_enterprise;
    }

    public final int getEvaluationPeriod() {
        return this.m_evalPeriod;
    }

    public final boolean isInterbrokerAllowed() {
        return this.m_interbrokerAllowed;
    }

    public final boolean isRoutingAllowed() {
        return this.m_routingAllowed;
    }

    public final boolean isHttpDirectAllowed() {
        return this.m_httpDirectAllowed;
    }

    public final boolean isFaultToleranceAllowed() {
        return this.m_faultToleranceAllowed;
    }

    public final int getMaxConnections() {
        return this.m_maxConnections;
    }

    public final int getMaxIPAddresses() {
        return this.m_maxIPAddresses;
    }

    public final boolean hasExpiration() {
        return this.m_hasExpiration;
    }

    public final int getExpirationMonth() {
        return this.m_expirationMonth;
    }

    public final int getExpirationYear() {
        return this.m_expirationYear;
    }

    public final String[] getFeatureList() {
        return FEATURE_LIST;
    }

    public final String getFeatureValue(String feature) {
        if (FEATURE_EVAL_MODE.equals(feature)) {
            return String.valueOf(this.isEvaluationMode());
        }
        if (FEATURE_EVAL_PERIOD.equals(feature)) {
            return String.valueOf(this.getEvaluationPeriod());
        }
        if (FEATURE_EXPIRES.equals(feature)) {
            return String.valueOf(this.hasExpiration());
        }
        if (FEATURE_EXPIRATION_MONTH.equals(feature)) {
            return String.valueOf(this.getExpirationMonth());
        }
        if (FEATURE_EXPIRATION_YEAR.equals(feature)) {
            return String.valueOf(this.getExpirationYear());
        }
        if (FEATURE_ENTERPRISE.equals(feature)) {
            return String.valueOf(this.isEnterprise());
        }
        if (FEATURE_INTERBROKER.equals(feature)) {
            return String.valueOf(this.isInterbrokerAllowed());
        }
        if (FEATURE_DRA.equals(feature)) {
            return String.valueOf(this.isRoutingAllowed());
        }
        if (FEATURE_HTTP_DIRECT.equals(feature)) {
            return String.valueOf(this.isHttpDirectAllowed());
        }
        if (FEATURE_MAX_CONNECTIONS.equals(feature)) {
            return String.valueOf(this.getMaxConnections());
        }
        if (FEATURE_MAX_IP_ADDRESSES.equals(feature)) {
            return String.valueOf(this.getMaxIPAddresses());
        }
        if (FEATURE_FT.equals(feature)) {
            return String.valueOf(this.isFaultToleranceAllowed());
        }
        return null;
    }
}

