/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mf.common.IXMLFragment;
import com.sonicsw.mq.common.runtime.IConnectionData;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;

public class ConnectionData
implements IConnectionData,
IXMLFragment,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final short CURRENT_VERSION = 0;
    private String m_user;
    private String[] m_id;
    private String m_host;
    private int m_connectionTypeMask;
    private Long m_connectionMemberRef = null;
    public static final int APPLICATION_TYPE = 1;
    public static final int CLUSTER_TYPE = 2;
    public static final int ROUTING_TYPE = 4;

    public ConnectionData() {
    }

    public ConnectionData(String user, String[] id, String host, int connectionTypeMask, long connectionMemberRef) {
        this.m_user = user;
        this.m_id = id;
        this.m_host = host;
        this.m_connectionTypeMask = connectionTypeMask;
        this.m_connectionMemberRef = new Long(connectionMemberRef);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[user=").append(this.m_user).append(']');
        sb.append("connectionType=");
        if (this.isApplicationConnection()) {
            sb.append("application,connectID=").append(this.m_id[0]);
        }
        if (this.isClusterConnection()) {
            sb.append("cluster,broker=").append(this.m_id[0]);
        }
        if (this.isRoutingConnection()) {
            sb.append("routing,node=").append(this.m_id[0]).append(",broker=").append(this.m_id[1]);
        }
        sb.append(",host=" + this.m_host);
        if (this.m_connectionMemberRef != null) {
            sb.append(",connectionMemberRef=" + this.m_connectionMemberRef);
        }
        return sb.toString();
    }

    public String toXMLFragment() {
        StringBuffer sb = new StringBuffer();
        sb.append("<connectionData>");
        sb.append("<user>").append(this.m_user).append("</user>");
        if (this.isApplicationConnection()) {
            sb.append("<connectionType>application</connectionType><connectID>").append(this.m_id[0]).append("</connectID>");
        }
        if (this.isClusterConnection()) {
            sb.append("<connectionType>cluster</connectionType><broker>").append(this.m_id[0]).append("</broker>");
        }
        if (this.isRoutingConnection()) {
            sb.append("<connectionType>routing</connectionType><node>").append(this.m_id[0]).append("</node><broker>").append(this.m_id[1]).append("</broker>");
        }
        sb.append("<host>").append(this.m_host).append("</host>");
        sb.append("</connectionData>");
        return sb.toString();
    }

    @Override
    public String getUser() {
        return this.m_user;
    }

    @Override
    public String getConnectID() {
        return this.isApplicationConnection() ? this.m_id[0] : null;
    }

    @Override
    public String getNode() {
        return this.isRoutingConnection() ? this.m_id[0] : null;
    }

    @Override
    public String getBroker() {
        return this.isClusterConnection() ? this.m_id[0] : (this.isRoutingConnection() ? this.m_id[1] : null);
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Long getConnectionMemberRef() {
        return this.m_connectionMemberRef;
    }

    @Override
    public boolean isApplicationConnection() {
        return (this.m_connectionTypeMask & 1) > 0;
    }

    @Override
    public boolean isClusterConnection() {
        return (this.m_connectionTypeMask & 2) > 0;
    }

    @Override
    public boolean isRoutingConnection() {
        return (this.m_connectionTypeMask & 4) > 0;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeUTF(this.m_user);
        stream.writeObject(this.m_id);
        stream.writeUTF(this.m_host);
        stream.writeShort((short)this.m_connectionTypeMask);
        stream.writeObject(this.m_connectionMemberRef);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        short version = stream.readShort();
        switch (version) {
            case 0: {
                this.m_user = stream.readUTF();
                this.m_id = (String[])stream.readObject();
                this.m_host = stream.readUTF();
                this.m_connectionTypeMask = stream.readShort();
                try {
                    this.m_connectionMemberRef = (Long)stream.readObject();
                    break;
                }
                catch (OptionalDataException e) {
                    if (e.eof) break;
                    throw e;
                }
            }
            default: {
                throw new InvalidObjectException("Unsupported Sonic management version - class: " + this.getClass().getName() + ", version: " + version);
            }
        }
    }
}

