/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.ConnectionTreeUpdateException;
import com.sonicsw.mq.common.runtime.IConnectionMemberInfo;
import com.sonicsw.mq.common.runtime.IConnectionTreeNode;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class ConnectionTreeNode
implements IConnectionTreeNode,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final short CURRENT_VERSION = 0;
    IConnectionMemberInfo m_info;
    IConnectionTreeNode m_parent;
    ArrayList<IConnectionTreeNode> m_children;

    ConnectionTreeNode() {
    }

    ConnectionTreeNode(IConnectionMemberInfo info, IConnectionTreeNode parent) {
        this.m_info = info;
        this.m_parent = parent;
    }

    public void setParent(IConnectionTreeNode parent) {
        this.m_parent = parent;
    }

    public void addChild(IConnectionTreeNode child) {
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(child);
    }

    @Override
    public IConnectionMemberInfo getInfo() {
        return this.m_info;
    }

    @Override
    public IConnectionTreeNode getParent() {
        return this.m_parent;
    }

    @Override
    public ArrayList<IConnectionTreeNode> getChildren() {
        return this.m_children;
    }

    @Override
    public void graftToParent(IConnectionTreeNode parent) throws ConnectionTreeUpdateException {
        if (this.m_parent != null) {
            throw new ConnectionTreeUpdateException("Connection tree node already associated with a parent node.");
        }
        if (parent == null) {
            return;
        }
        long ref = this.m_info.getRef();
        ArrayList<IConnectionTreeNode> parentsChildren = ((ConnectionTreeNode)parent).m_children;
        if (parentsChildren != null) {
            for (IConnectionTreeNode child : parentsChildren) {
                if (child.getInfo().getRef() != ref) continue;
                int idx = parentsChildren.indexOf(child);
                parentsChildren.set(idx, this);
                this.setParent(parent);
                return;
            }
        }
        throw new ConnectionTreeUpdateException("Attempt to link a connection tree node to a parent, but the connection member associated with the node is not recognized by the parent");
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeObject(this.m_info);
        int numChildren = this.m_children == null ? 0 : this.m_children.size();
        stream.writeInt(numChildren);
        if (this.m_children != null) {
            for (IConnectionTreeNode iConnectionTreeNode : this.m_children) {
                stream.writeObject((ConnectionTreeNode)iConnectionTreeNode);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        short version = stream.readShort();
        switch (version) {
            case 0: {
                this.m_info = (IConnectionMemberInfo)stream.readObject();
                int numChildren = stream.readInt();
                for (int i = 0; i < numChildren; ++i) {
                    ConnectionTreeNode child = (ConnectionTreeNode)stream.readObject();
                    child.setParent(this);
                    this.addChild(child);
                }
                break;
            }
            default: {
                throw new InvalidObjectException("Unsupported Sonic management version - class: " + this.getClass().getName() + ", version: " + version);
            }
        }
    }
}

