/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import com.sonicsw.mq.components.HttpProxyConfig;
import java.text.MessageFormat;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.Config;
import progress.message.broker.HTTPDirectOutboundEntry;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.prAccessor;

public class AddNewRouteChangeHandler
implements IAttributeChangeHandler {
    private boolean m_securityEnabled = true;
    private boolean TRACE = false;
    private static volatile IComponentContext s_context = null;
    private static volatile ConfigurationChangeBindHelper s_bindHelper = null;

    public static void init(IComponentContext context) {
        s_context = context;
    }

    public AddNewRouteChangeHandler(ConfigurationChangeBindHelper bindHelper, boolean securityEnabled) {
        s_bindHelper = bindHelper;
        this.m_securityEnabled = securityEnabled;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newRoutes = delta.getNewAttributesNames();
        if (!Config.ENABLE_ROUTING && newRoutes.length > 0) {
            String warning = MessageFormat.format(prAccessor.getString("DRA_NOT_SUPPORTED1"), BrokerLicenseMgr.getLicenseMgr().getProductName());
            s_context.logMessage(warning, 2);
            return;
        }
        for (int i = 0; i < newRoutes.length; ++i) {
            String attributeName = newRoutes[i];
            try {
                Object obj = delta.getNewValue(attributeName);
                Reference routeRef = (Reference)obj;
                String routeCID = routeRef.getElementName();
                IElement routeConfigElem = s_context.getConfiguration(routeCID, true);
                this.createRoute(routeConfigElem);
                continue;
            }
            catch (NotModifiedAttException nmae) {
                if (!this.TRACE) continue;
                System.out.println("AddNewRouteChangeHandler.itemModified:");
            }
        }
    }

    private void createRoute(IElement routeCE) {
        String userPwd;
        String elementType = routeCE.getIdentity().getType();
        IAttributeSet rdas = routeCE.getAttributes();
        String nodeName = (String)rdas.getAttribute("NODE_NAME");
        RoutingConnectionInfo r = AgentRegistrar.getAgentRegistrar().getRoutingConfig().getRoutingConnection(nodeName);
        HTTPDirectOutboundEntry httpOutBoundEntry = null;
        if (r != null) {
            return;
        }
        r = new RoutingConnectionInfo(nodeName);
        String brokerName = (String)rdas.getAttribute("BROKER");
        r.setOutboundBrokerName(brokerName);
        String userName = (String)rdas.getAttribute("USER_NAME");
        if (userName == null) {
            userName = "";
        }
        if (elementType.equals("MQ_ROUTE_SONIC") && userName.indexOf(".") != -1) {
            userName = userName.replace('.', '$');
        }
        if ((userPwd = (String)rdas.getAttribute("USER_PASSWORD")) == null) {
            userPwd = "";
        }
        r.setUserName(userName);
        r.setPassword(userPwd);
        HttpProxyConfig pConfig = new HttpProxyConfig(rdas);
        if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
            r.setProxyConfig(pConfig);
        }
        String url = null;
        Boolean groupByUrl = null;
        if (elementType.equals("MQ_ROUTE_SONIC")) {
            String urls = (String)rdas.getAttribute("URLS");
            Integer timeout = (Integer)rdas.getAttribute("IDLE_TIMEOUT");
            Long subExpiration = (Long)rdas.getAttribute("GLOBAL_SUBSCRIPTION_EXPIRATION");
            Boolean loadBalancing = (Boolean)rdas.getAttribute("LOAD_BALANCING");
            Boolean sequentialAccess = (Boolean)rdas.getAttribute("SEQUENTIAL");
            Boolean advertiseRoutes = (Boolean)rdas.getAttribute("ADVERTISE");
            Boolean staticRouting = (Boolean)rdas.getAttribute("STATIC_ROUTING");
            String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
            Boolean propagateJMSXUserID = (Boolean)rdas.getAttribute("PROPAGATE_JMSXUSERID");
            if (propagateJMSXUserID == null) {
                propagateJMSXUserID = Boolean.TRUE;
            }
            r.setConnectionURLs(urls);
            if (subExpiration != null) {
                r.setGlobalSubscriptionExpiration(subExpiration);
            }
            if (timeout != null) {
                r.setTimeout(timeout);
            }
            if (loadBalancing != null) {
                r.setLoadBalance(loadBalancing);
            }
            if (sequentialAccess != null) {
                r.setSequentialLoadBalancing(sequentialAccess);
            }
            if (advertiseRoutes != null) {
                r.setForwardRoutings(advertiseRoutes);
            }
            if (staticRouting != null) {
                r.setStaticRouting(staticRouting);
            }
            if (routingAcceptor != null) {
                r.setRoutingAcceptor(routingAcceptor);
            }
            r.setPropagateJMSXUserID(propagateJMSXUserID);
        } else if (elementType.equals("MQ_ROUTE_DIRECT")) {
            url = (String)rdas.getAttribute("URL");
            groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
            String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
            r.setConnectionURLs(url);
            r.setRouteType(RoutingConnectionInfo.ROUTE_TYPE_DIRECT);
            if (groupByUrl != null) {
                r.setGroupByUrl(groupByUrl);
            } else {
                r.setGroupByUrl(true);
            }
            if (routingAcceptor != null) {
                r.setRoutingAcceptor(routingAcceptor);
            }
            httpOutBoundEntry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "DIRECT");
        } else if (elementType.equals("MQ_ROUTE_DIRECT_SOAP")) {
            url = (String)rdas.getAttribute("URL");
            groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
            String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
            r.setConnectionURLs(url);
            r.setRouteType(RoutingConnectionInfo.ROUTE_TYPE_SOAP);
            if (groupByUrl != null) {
                r.setGroupByUrl(groupByUrl);
            } else {
                r.setGroupByUrl(true);
            }
            if (routingAcceptor != null) {
                r.setRoutingAcceptor(routingAcceptor);
            }
            httpOutBoundEntry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "SOAP");
        } else if (elementType.equals("MQ_ROUTE_DIRECT_WS")) {
            IAttributeSet rmas;
            url = (String)rdas.getAttribute("URL");
            groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
            String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
            r.setConnectionURLs(url);
            r.setRouteType(RoutingConnectionInfo.ROUTE_TYPE_WS);
            if (groupByUrl != null) {
                r.setGroupByUrl(groupByUrl);
            } else {
                r.setGroupByUrl(true);
            }
            if (routingAcceptor != null) {
                r.setRoutingAcceptor(routingAcceptor);
            }
            IAttributeSet wss = (IAttributeSet)rdas.getAttribute("WSS_PARAMETERS");
            IAttributeSet credentials = null;
            if (wss != null) {
                String serialNumber;
                credentials = (IAttributeSet)wss.getAttribute("CREDENTIALS");
                String issuerName = (String)wss.getAttribute("DESTINATION_CERTIFICATE_ISSUER_NAME");
                if (issuerName != null) {
                    r.setDestinationX509IssuerName(issuerName);
                }
                if ((serialNumber = (String)wss.getAttribute("DESTINATION_CERTIFICATE_ISSUER_NUMBER")) != null) {
                    r.setDestinationX509SerialNumber(serialNumber);
                }
            }
            if (credentials != null) {
                String x509Alias;
                String utName = (String)credentials.getAttribute("USERNAMETOKEN_USERNAME");
                if (utName != null && utName.length() > 0) {
                    String utPwd = (String)credentials.getAttribute("USERNAMETOKEN_PASSWORD");
                    if (utPwd == null || utPwd.length() == 0) {
                        BrokerComponent.getComponentContext().logMessage("Password of Username token for the routing node " + r.getRoutingNodeName() + " cannot be null or empty string.", 2);
                    } else {
                        r.setUsernameTokenName(utName);
                        r.setUsernameTokenPassword(utPwd.toCharArray());
                    }
                }
                if ((x509Alias = (String)credentials.getAttribute("X509TOKEN_ALIAS")) != null && x509Alias.length() > 0) {
                    String x509Pwd = (String)credentials.getAttribute("X509TOKEN_PASSWORD");
                    if (x509Pwd == null || x509Pwd.length() == 0) {
                        BrokerComponent.getComponentContext().logMessage("Private key password of X.509 token for the routing node " + r.getRoutingNodeName() + " cannot be null or empty string.", 2);
                    } else {
                        r.setX509Alias(x509Alias);
                        r.setX509Password(x509Pwd.toCharArray());
                    }
                }
            }
            if ((rmas = (IAttributeSet)rdas.getAttribute("WSRM_PARAMETERS")) != null) {
                Integer idleTimeout = (Integer)rmas.getAttribute("IDLE_TIMEOUT");
                Integer sequenceExpiration = (Integer)rmas.getAttribute("SEQUENCE_EXPIRATION");
                if (idleTimeout != null) {
                    r.setRmIdleTimeout(idleTimeout.intValue());
                }
                if (sequenceExpiration != null) {
                    r.setRmSequenceExpiration(sequenceExpiration.intValue());
                }
            }
            httpOutBoundEntry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "WS");
        } else if (elementType.equals("MQ_ROUTE_DIRECT_JMS")) {
            url = (String)rdas.getAttribute("URL");
            groupByUrl = (Boolean)rdas.getAttribute("GROUP_BY_URL");
            String routingAcceptor = (String)rdas.getAttribute("ROUTING_ACCEPTOR");
            r.setConnectionURLs(url);
            r.setRouteType(RoutingConnectionInfo.ROUTE_TYPE_JMS);
            if (groupByUrl != null) {
                r.setGroupByUrl(groupByUrl);
            } else {
                r.setGroupByUrl(true);
            }
            if (routingAcceptor != null) {
                r.setRoutingAcceptor(routingAcceptor);
            }
            httpOutBoundEntry = ConfigPropertiesPopulator.createHttpDirectOutbouondEntry(rdas, nodeName, "JMS");
        }
        s_bindHelper.bindRouteConfigChangeHandler(r, rdas);
        AgentRegistrar.getAgentRegistrar().getRoutingConfig().setRoutingConnection(r, httpOutBoundEntry);
        if (httpOutBoundEntry != null) {
            s_context.logMessage("HttpDirect outbound route \"" + nodeName + "\" is created for url \"" + url + "\"", 3);
        }
    }
}

