/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import java.util.Properties;
import progress.message.broker.Broker;

public class BackupBrokerChangeHandler
implements IAttributeChangeHandler {
    private String m_bname;
    private IElement m_primarybce;
    private IComponentContext m_context = null;

    public BackupBrokerChangeHandler(IComponentContext context, IElement primarybce, String bname) {
        this.m_context = context;
        this.m_primarybce = primarybce;
        this.m_bname = bname;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            if (!newAttributes[i].equals("BACKUP_CONFIG_ELEMENT_REF")) continue;
            this.updateBackupInfo();
            return;
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            if (!modifiedAttributes[i].equals("BACKUP_CONFIG_ELEMENT_REF")) continue;
            this.updateBackupInfo();
            return;
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            if (!deletedAttributes[i].equals("BACKUP_CONFIG_ELEMENT_REF")) continue;
            this.updateBackupInfo();
            return;
        }
    }

    private void updateBackupInfo() {
        Properties props = BrokerComponent.getBrokerComponent().getProperties();
        if (props == null) {
            return;
        }
        IAttributeSet das = this.m_primarybce.getAttributes();
        IAttributeSet cers = (IAttributeSet)das.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference peerBCERef = (Reference)cers.getAttribute("BACKUP_CONFIG_ELEMENT_REF");
        if (peerBCERef == null) {
            props.remove("BACKUP_CONFIG_ELEMENT_REF");
            props.remove("FTPEER_ACCEPTOR_HOLDER");
        } else {
            props.put("BACKUP_CONFIG_ELEMENT_REF", peerBCERef);
            String peerBCEId = peerBCERef.getElementName();
            IElement peerBCE = this.m_context.getConfiguration(peerBCEId, true);
            BackupBrokerChangeHandler.updateFTPeerInfo(this.m_context, peerBCE);
        }
        if (BrokerComponent.getBrokerComponent().getState() == 3) {
            Broker.getBroker().notifyClientsOfAcceptorsChange(null);
        }
    }

    static boolean isBackup() {
        Properties props = BrokerComponent.getBrokerComponent().getProperties();
        Object primary = props.get("PRIMARY_CONFIG_ELEMENT_REF");
        return primary != null;
    }

    static boolean isClustered() {
        Properties props = BrokerComponent.getBrokerComponent().getProperties();
        boolean isClustered = false;
        String inCluster = (String)props.get("ENABLE_INTERBROKER");
        if (inCluster != null && inCluster.equalsIgnoreCase("true")) {
            isClustered = true;
        }
        return isClustered;
    }

    static void updateFTPeerInfo(IComponentContext context, IElement peerBCE) {
        Properties props = BrokerComponent.getBrokerComponent().getProperties();
        try {
            if (BackupBrokerChangeHandler.isBackup()) {
                ConfigPropertiesPopulator.getBackupPeerAcceptorConfig(context, peerBCE.getAttributes(), props, BackupBrokerChangeHandler.isClustered());
            } else {
                ConfigPropertiesPopulator.getPrimaryPeerAcceptorConfig(context, peerBCE.getAttributes(), props, BackupBrokerChangeHandler.isClustered());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

