/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.runtime.INotification;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.management.MBeanNotificationInfo;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.IClientContext;
import progress.message.broker.fc.FCEvent;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;

public final class BrokerManagementNotificationsHelper {
    private static IComponentContext m_mfContext;
    private static final boolean NOTIFY_SYSTEM_CONNECTIONS;
    public static final String CONNECTION_SUBCATEGORY = "connection";
    public static final String SESSION_SUBCATEGORY = "session";
    public static final String QUEUE_SUBCATEGORY = "queue";
    public static final String FLOWCONTROL_SUBCATEGORY = "flowcontrol";
    public static final String STATE_SUBCATEGORY = "state";
    public static final String REMOTE_SUBSCRIPTION_SUBCATEGORY = "globalSubscriptions";
    public static final String MESSAGE_SUBCATEGORY = "message";
    public static final String REPLICATION_SUBCATEGORY = "replication";
    public static final String SUBSCRIBE_NOTIFICATION_TYPE = "Subscribe";
    public static final String UNSUBSCRIBE_NOTIFICATION_TYPE = "Unsubscribe";
    public static final String SUBSCRIBER_PAUSE_NOTIFICATION_TYPE = "SubscriberPause";
    public static final String SUBSCRIBER_RESUME_NOTIFICATION_TYPE = "SubscriberResume";
    public static final String START_RECEIVE_NOTIFICATION_TYPE = "StartReceive";
    public static final String END_RECEIVE_NOTIFICATION_TYPE = "EndReceive";
    public static final String ACKNOWLEDGEMENT_PAUSE_TYPE = "AcknowledgementPause";
    public static final String ACCEPTOR_STATUS_TYPE = "AcceptorStatus";
    public static final String PRIMARY_ACCEPTOR_STATUS_TYPE = "PrimaryAcceptorStatus";
    public static final String SUBSCRIPTION_TRIM_OP_INITIATED_TYPE = "SubscriptionTrimInvocationInitiated";
    public static final String SUBSCRIPTION_TRIM_OP_CANCELLED_TYPE = "SubscriptionTrimInvocationCancelled";
    public static final String SUBSCRIPTION_TRIM_OP_COMPLETED_TYPE = "SubscriptionTrimInvocationCompleted";
    public static final String SUBSCRIPTION_TRIM_DB_MESSAGES_DELETED_TYPE = "SubscriptionMessagesTrimmedFromDB";
    public static final String CONNECT_TYPE = "Connect";
    public static final String RECONNECT_TYPE = "Reconnect";
    public static final String DISCONNECT_TYPE = "Disconnect";
    public static final String REJECT_TYPE = "Reject";
    public static final String DROP_TYPE = "Drop";
    public static final String REDIRECT_TYPE = "Redirect";
    public static final String PUBPAUSE_TYPE = "PubPause";
    public static final String PUBRESUME_TYPE = "PubResume";
    public static final String SENDPAUSE_TYPE = "SendPause";
    public static final String SENDRESUME_TYPE = "SendResume";
    public static final String RMBUFFERFULL_TYPE = "RMReorderBufferFull";
    public static final String RMBUFFERAVAILABLE_TYPE = "RMReorderBufferAvailable";
    public static final String CLUSTER_CONNECTION_PAUSE_TYPE = "ClusterConnectionPause";
    public static final String CLUSTER_CONNECTION_RESUME_TYPE = "ClusterConnectionResume";
    public static final String ROUTING_CONNECTION_PAUSE_TYPE = "RoutingConnectionPause";
    public static final String ROUTING_CONNECTION_RESUME_TYPE = "RoutingConnectionResume";
    public static final String ROUTING_CONNECTION_SENDER_PAUSE_TYPE = "RoutingConnectionSenderPause";
    public static final String ROUTING_CONNECTION_SENDER_RESUME_TYPE = "RoutingConnectionSenderResume";
    public static final String FTDSTART_TYPE = "StartFlowToDisk";
    public static final String FTDEND_TYPE = "EndFlowToDisk";
    public static final String SLOWSUBSCRIBER_TYPE = "SlowSubscriber";
    public static final String BACKLOGGED_SESSION_SKIP_TYPE = "BackloggedSessionSkip";
    public static final String DMQCAPACITY_TYPE = "DmqCapacity";
    public static final String LOGCAPACITY_TYPE = "LogCapacity";
    public static final String SUBSCRIBEFAILURE_TYPE = "SubscribeFailure";
    public static final String SUBSCRIPTIONDELETED_TYPE = "SubscriptionDeleted";
    public static final String SUBSCRIPTIONEXPIRED_TYPE = "SubscriptionExpired";
    public static final String UNDELIVERED_TYPE = "Undelivered";
    public static final String PUBSUB_CLEANUP_FINISHED_TYPE = "PubSubCleanupFinished";
    public static final String QUEUE_CLEANUP_FINISHED_TYPE = "QueueCleanupFinished";
    public static final String REPLICATION_CONNECT_TYPE = "ReplicationConnect";
    public static final String REPLICATION_DISCONNECT_TYPE = "ReplicationDisconnect";
    public static final String REPLICATION_RETRY_TYPE = "ReplicationRetry";
    public static final String REPLICATION_STATE_CHANGE_TYPE = "ReplicationStateChange";
    public static final String REPLICATION_CHANNEL_SWITCH_TYPE = "ReplicationChannelSwitch";
    public static final String REPLICATION_ACTIVATE_TYPE = "ReplicationActivate";
    public static final String DBCOMPACT_TYPE = "DbCompact";
    private static final ArrayList NOTIFICATION_INFOS;

    static ArrayList getNotificationInfos() {
        return NOTIFICATION_INFOS;
    }

    static synchronized void init(IComponentContext mfContext) {
        if (m_mfContext != null) {
            throw new IllegalStateException("Context already set");
        }
        m_mfContext = mfContext;
    }

    public static void sendConnectionConnectNotification(String broker, String user, String connectIDParam, String ipAddr, String brokerConnection) {
        String connectID = connectIDParam;
        if ((connectID = BrokerManagementNotificationsHelper.filterConnectionConnectID(connectID)) == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, CONNECT_TYPE, 3);
        notification.setLogType((short)3);
        notification.setAttribute("Broker", (Object)broker);
        notification.setAttribute("Routing", (Object)Config.ROUTING_NODE_NAME);
        BrokerManagementNotificationsHelper.configNotificationAttributesConnect(connectID, ipAddr, notification, user);
        notification.setAttribute("BrokerConnectionUrl", (Object)brokerConnection);
        m_mfContext.sendNotification(notification);
    }

    public static void sendConnectionReconnectNotification(String broker, String user, String connectIDParam, String ipAddr) {
        String connectID = connectIDParam;
        if ((connectID = BrokerManagementNotificationsHelper.filterConnectionConnectID(connectID)) == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, RECONNECT_TYPE, 3);
        notification.setLogType((short)3);
        BrokerManagementNotificationsHelper.populateAttributeAndSendNotification(notification, broker, connectID, ipAddr, user);
    }

    public static void sendReplicateConnectionConnectNotification(String connectionName, String primaryAddr, int primaryPort, String backupAddr, int backupPort, int weight) {
        if (connectionName == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REPLICATION_CONNECT_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesPort(backupAddr, backupPort, connectionName, notification, primaryAddr, primaryPort, weight);
    }

    public static void sendConnectionDisconnectNotification(String broker, String user, String connectIDParam, String ipAddr, String brokerConnection) {
        String connectID = connectIDParam;
        if ((connectID = BrokerManagementNotificationsHelper.filterConnectionConnectID(connectID)) == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, DISCONNECT_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        BrokerManagementNotificationsHelper.configNotificationAttributesConnect(connectID, ipAddr, notification, user);
        notification.setAttribute("BrokerConnectionUrl", (Object)brokerConnection);
        m_mfContext.sendNotification(notification);
    }

    public static void sendReplicationConnectionRetryNotification(String broker, int count, int interval) {
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REPLICATION_RETRY_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("ChannelCount", (Object)new Integer(count));
        notification.setAttribute("NextRetryInterval", (Object)new Integer(interval));
        m_mfContext.sendNotification(notification);
    }

    public static void sendReplicationConnectionChannelSwitchNotification(String newActive, String oldActive) {
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REPLICATION_CHANNEL_SWITCH_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("NewActive", (Object)newActive);
        notification.setAttribute("OldActive", (Object)oldActive);
        m_mfContext.sendNotification(notification);
    }

    public static void sendReplicationConnectionActivationNotification(String newActive) {
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REPLICATION_ACTIVATE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("ConnectionName", (Object)newActive);
        m_mfContext.sendNotification(notification);
    }

    public static void sendReplicateConnectionDisconnectNotification(String connectionName, String primaryAddr, int primaryPort, String backupAddr, int backupPort, int weight) {
        if (connectionName == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REPLICATION_DISCONNECT_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesPort(backupAddr, backupPort, connectionName, notification, primaryAddr, primaryPort, weight);
    }

    private static void configNotificationAttributesPort(String backupAddr, int backupPort, String connectionName, INotification notification, String primaryAddr, int primaryPort, int weight) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("ConnectionName", (Object)connectionName);
        notification.setAttribute("PrimaryAddr", (Object)primaryAddr);
        notification.setAttribute("PrimaryPort", (Object)new Integer(primaryPort));
        notification.setAttribute("BackupAddr", (Object)backupAddr);
        notification.setAttribute("BackupPort", (Object)new Integer(backupPort));
        notification.setAttribute("Weight", (Object)new Integer(weight));
        m_mfContext.sendNotification(notification);
    }

    public static void sendReplicationStateChangeNotification(String broker, String oldState, String newState) {
        INotification notification = m_mfContext.createNotification((short)2, STATE_SUBCATEGORY, REPLICATION_STATE_CHANGE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("OldState", (Object)oldState);
        notification.setAttribute("NewState", (Object)newState);
        m_mfContext.sendNotification(notification);
    }

    public static void sendConnectionRejectNotification(String broker, String user, String connectIDParam, String ipAddr) {
        String connectID = connectIDParam;
        if ((connectID = BrokerManagementNotificationsHelper.filterConnectionConnectID(connectID)) == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REJECT_TYPE, 2);
        notification.setLogType((short)4);
        BrokerManagementNotificationsHelper.populateAttributeAndSendNotification(notification, broker, connectID, ipAddr, user);
    }

    private static void populateAttributeAndSendNotification(INotification notification, String broker, String connectID, String ipAddr, String user) {
        notification.setAttribute("Broker", (Object)broker);
        notification.setAttribute("Routing", (Object)Config.ROUTING_NODE_NAME);
        BrokerManagementNotificationsHelper.configNotificationAttributesConnect(connectID, ipAddr, notification, user);
        m_mfContext.sendNotification(notification);
    }

    public static void sendConnectionDropNotification(String broker, String user, String connectIDParam, String ipAddr, boolean xonce, long reconnectTimeout) {
        String connectID = connectIDParam;
        if ((connectID = BrokerManagementNotificationsHelper.filterConnectionConnectID(connectID)) == null) {
            return;
        }
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, DROP_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        BrokerManagementNotificationsHelper.configNotificationAttributesConnect(connectID, ipAddr, notification, user);
        if (xonce) {
            notification.setAttribute("FaultTolerant", (Object)"true");
            notification.setAttribute("ReconnectTimeout", (Object)Long.toString(reconnectTimeout));
        } else {
            notification.setAttribute("FaultTolerant", (Object)"false");
        }
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationAttributesConnect(String connectID, String ipAddr, INotification notification, String user) {
        notification.setAttribute("User", (Object)user);
        notification.setAttribute("ConnectID", (Object)connectID);
        notification.setAttribute("ClientIPAddress", (Object)ipAddr);
    }

    public static void sendConnectionRedirectNotification(String fromBroker, String toURL, String ipAddr) {
        INotification notification = m_mfContext.createNotification((short)2, CONNECTION_SUBCATEGORY, REDIRECT_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("FromBroker", (Object)fromBroker);
        notification.setAttribute("ToURL", (Object)toURL);
        notification.setAttribute("ClientIPAddress", (Object)ipAddr);
        m_mfContext.sendNotification(notification);
    }

    public static void sendAcknowledgmentPauseNotification(String broker, String nodeName, String user, String connectID, String clientID, String subscriptionName) {
        INotification notification = BrokerManagementNotificationsHelper.createNotification(SESSION_SUBCATEGORY, ACKNOWLEDGEMENT_PAUSE_TYPE, broker, nodeName, user);
        notification.setAttribute("ConnectID", (Object)connectID);
        notification.setAttribute("ClientID", (Object)clientID);
        notification.setAttribute("SubcriptionName", (Object)subscriptionName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendFlowControlPubPauseNotification(String broker, IClientContext publisher, String connectID, IClientContext[] blockingDurableSubscriptions, IClientContext[] blockingNonDurableSubscriptions) {
        int i;
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, PUBPAUSE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndSessionPublisher(broker, connectID, notification, publisher);
        String[] users = new String[]{};
        String[] ids = new String[]{};
        String[] subs = new String[]{};
        if (blockingDurableSubscriptions != null) {
            users = new String[blockingDurableSubscriptions.length];
            ids = new String[blockingDurableSubscriptions.length];
            subs = new String[blockingDurableSubscriptions.length];
            for (i = 0; i < blockingDurableSubscriptions.length; ++i) {
                users[i] = blockingDurableSubscriptions[i].getUid();
                ids[i] = SessionConfig.getDurableJMSClientIDFromAppid(blockingDurableSubscriptions[i].getAppid());
                subs[i] = SessionConfig.getDurableSubNameFromAppid(blockingDurableSubscriptions[i].getAppid());
            }
        }
        notification.setAttribute("BlockingDurableUsers", (Object)users);
        notification.setAttribute("BlockingDurableClientIDs", (Object)ids);
        notification.setAttribute("BlockingDurableSubscriptionNames", (Object)subs);
        users = new String[]{};
        ids = new String[]{};
        subs = new String[]{};
        if (blockingNonDurableSubscriptions != null) {
            users = new String[blockingNonDurableSubscriptions.length];
            ids = new String[blockingNonDurableSubscriptions.length];
            subs = new String[blockingNonDurableSubscriptions.length];
            for (i = 0; i < blockingNonDurableSubscriptions.length; ++i) {
                users[i] = blockingNonDurableSubscriptions[i].getUid();
                String connid = blockingNonDurableSubscriptions[i].getAppid();
                try {
                    if (!blockingNonDurableSubscriptions[i].isInterbroker()) {
                        connid = SessionConfig.getConnectIDFromSubscriberAppid(connid);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ids[i] = connid;
                Enumeration subscribedSubjects = blockingNonDurableSubscriptions[i].getSubscriptions().keys();
                StringBuffer buf = new StringBuffer();
                boolean firstSubject = true;
                while (subscribedSubjects.hasMoreElements()) {
                    ISubject subject = (ISubject)subscribedSubjects.nextElement();
                    if (SessionConfig.isSystemSubject(subject) && !subject.isTemporary()) continue;
                    if (firstSubject) {
                        firstSubject = false;
                    } else {
                        buf.append(',');
                    }
                    buf.append(subject.getSubjectString());
                }
                subs[i] = buf.toString();
            }
        }
        notification.setAttribute("BlockingNonDurableUsers", (Object)users);
        notification.setAttribute("BlockingNonDurableConnectIDs", (Object)ids);
        notification.setAttribute("BlockingNonDurableTopics", (Object)subs);
        m_mfContext.sendNotification(notification);
    }

    public static void sendFlowControlPubResumeNotification(String broker, IClientContext publisher, String connectID) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, PUBRESUME_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndSessionPublisher(broker, connectID, notification, publisher);
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationBrokerAndSessionPublisher(String broker, String connectID, INotification notification, IClientContext publisher) {
        BrokerManagementNotificationsHelper.configNotificationBrokerAndSessionSender(broker, connectID, notification, publisher);
    }

    public static void sendFlowControlSendPauseNotification(String broker, IClientContext sender, String connectID, String[] blockingQueues) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, SENDPAUSE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndSessionSender(broker, connectID, notification, sender);
        notification.setAttribute("BlockingQueues", (Object)blockingQueues);
        m_mfContext.sendNotification(notification);
    }

    public static void sendRMBufferFullNotification(String broker, String user, String RMID) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, RMBUFFERFULL_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndUser(RMID, broker, notification, user);
    }

    public static void sendRMBufferAvailableNotification(String broker, String user, String RMID) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, RMBUFFERAVAILABLE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndUser(RMID, broker, notification, user);
    }

    private static void configNotificationBrokerAndUser(String RMID, String broker, INotification notification, String user) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("User", (Object)user);
        notification.setAttribute("ReliableSequenceID", (Object)RMID);
        m_mfContext.sendNotification(notification);
    }

    public static void sendFlowControlSendResumeNotification(String broker, IClientContext sender, String connectID) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, SENDRESUME_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndSessionSender(broker, connectID, notification, sender);
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationBrokerAndSessionSender(String broker, String connectID, INotification notification, IClientContext sender) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("User", (Object)sender.getUid());
        notification.setAttribute("ConnectID", (Object)connectID);
        notification.setAttribute("Session", (Object)BrokerManagementNotificationsHelper.getConnectionMemberLabel(sender));
    }

    public static void sendFlowControlIBConnectionPauseNotification(String broker, FCEvent fcdata) {
        INotification notification = BrokerManagementNotificationsHelper.createNotification(CLUSTER_CONNECTION_PAUSE_TYPE, broker, fcdata);
        notification.setAttribute("BlockedPendingQueue", (Object)fcdata.blockedPendingQueue);
        BrokerManagementNotificationsHelper.configNotificationAttributesBlocking(fcdata, notification);
    }

    public static void sendFlowControlIBConnectionResumeNotification(String broker, FCEvent fcdata, int resumePrio, String resumeDest) {
        INotification notification = BrokerManagementNotificationsHelper.createNotification(CLUSTER_CONNECTION_RESUME_TYPE, broker, fcdata);
        notification.setAttribute("BlockingBroker", (Object)fcdata.receivingBroker);
        notification.setAttribute("BlockingType", (Object)fcdata.getContentTypes());
        BrokerManagementNotificationsHelper.configNotificationAttributesResume(notification, resumeDest, resumePrio);
    }

    private static INotification createNotification(String eventName, String broker, FCEvent fcdata) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, eventName, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("BlockedBroker", (Object)fcdata.blockedBroker);
        return notification;
    }

    public static void sendFlowControlDRAConnectionPauseNotification(String broker, FCEvent fcdata) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, ROUTING_CONNECTION_PAUSE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBlocked(broker, fcdata, notification);
        BrokerManagementNotificationsHelper.configNotificationAttributesBlocking(fcdata, notification);
    }

    private static void configNotificationAttributesBlocking(FCEvent fcdata, INotification notification) {
        notification.setAttribute("BlockingBroker", (Object)fcdata.receivingBroker);
        notification.setAttribute("BlockingType", (Object)fcdata.getContentTypes());
        notification.setAttribute("BlockingPriority", (Object)new Integer(fcdata.priority));
        notification.setAttribute("BlockingDurableSubscriptionNames", (Object)fcdata.blockingDurableSubscriptionNames);
        notification.setAttribute("BlockingDurableUsers", (Object)fcdata.blockingDurableUsers);
        notification.setAttribute("BlockingDurableClientIDs", (Object)fcdata.blockingDurableClientIds);
        notification.setAttribute("BlockingDurableConnectIDs", (Object)fcdata.blockingDurableConnectIds);
        notification.setAttribute("BlockingNonDurableUsers", (Object)fcdata.blockingNondurableUsers);
        notification.setAttribute("BlockingNonDurableConnectIDs", (Object)fcdata.blockingNondurableConnectIds);
        notification.setAttribute("BlockingNonDurableTopics", (Object)fcdata.blockingNondurableTopics);
        notification.setAttribute("BlockingDestinations", (Object)fcdata.destinations);
        m_mfContext.sendNotification(notification);
    }

    public static void sendFlowControlDRAConnectionResumeNotification(String broker, FCEvent fcdata, int resumePrio, String resumeDest) {
        BrokerManagementNotificationsHelper.createAndConfigNotification(ROUTING_CONNECTION_RESUME_TYPE, broker, fcdata, resumeDest, resumePrio);
    }

    public static void sendFlowControlDRAConnectionSenderPauseNotification(String broker, FCEvent fcdata) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, ROUTING_CONNECTION_SENDER_PAUSE_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndBlocker(broker, fcdata, notification);
        notification.setAttribute("BlockingPriority", (Object)new Integer(fcdata.priority));
        notification.setAttribute("BlockingDestinations", (Object)fcdata.destinations);
        m_mfContext.sendNotification(notification);
    }

    public static void sendFlowControlDRAConnectionSenderResumeNotification(String broker, FCEvent fcdata, int resumePrio, String resumeDest) {
        BrokerManagementNotificationsHelper.createAndConfigNotification(ROUTING_CONNECTION_SENDER_RESUME_TYPE, broker, fcdata, resumeDest, resumePrio);
    }

    private static void createAndConfigNotification(String eventName, String broker, FCEvent fcdata, String resumeDest, int resumePrio) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, eventName, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndBlocker(broker, fcdata, notification);
        BrokerManagementNotificationsHelper.configNotificationAttributesResume(notification, resumeDest, resumePrio);
    }

    private static void configNotificationAttributesResume(INotification notification, String resumeDest, int resumePrio) {
        notification.setAttribute("ResumePriority", (Object)new Integer(resumePrio));
        notification.setAttribute("ResumeDest", (Object)resumeDest);
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationBrokerAndBlocker(String broker, FCEvent fcdata, INotification notification) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBlocked(broker, fcdata, notification);
        notification.setAttribute("BlockingBroker", (Object)fcdata.receivingBroker);
        notification.setAttribute("BlockingType", (Object)fcdata.getContentTypes());
    }

    private static void configNotificationAttributesBlocked(String broker, FCEvent fcdata, INotification notification) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("BlockedRoutingNode", (Object)fcdata.blockedRoutingNode);
        notification.setAttribute("BlockedBroker", (Object)fcdata.blockedBroker);
        notification.setAttribute("BlockingRoutingNode", (Object)fcdata.blockingRoutingNode);
    }

    public static void sendStateDMQCapacityNotification(String broker, short percentFull) {
        INotification notification = BrokerManagementNotificationsHelper.createNotification(DMQCAPACITY_TYPE, percentFull, broker);
        notification.setAttribute("PercentFull", (Object)new Short(percentFull));
        m_mfContext.sendNotification(notification);
    }

    public static void sendStateLogCapacityNotification(String broker, short syncPercent) {
        INotification notification = BrokerManagementNotificationsHelper.createNotification(LOGCAPACITY_TYPE, syncPercent, broker);
        notification.setAttribute("SyncPercent", (Object)new Short(syncPercent));
        m_mfContext.sendNotification(notification);
    }

    private static INotification createNotification(String eventName, short syncPercent, String broker) {
        INotification notification = m_mfContext.createNotification((short)2, STATE_SUBCATEGORY, eventName, syncPercent < 100 ? 2 : 1);
        notification.setLogType(syncPercent < 100 ? (short)1 : 2);
        notification.setAttribute("Broker", (Object)broker);
        notification.setAttribute("Routing", (Object)Config.ROUTING_NODE_NAME);
        return notification;
    }

    public static void sendRemoteSubscriptionsDeletedNotification(String proxyingNode, String remoteNode) {
        INotification notification = m_mfContext.createNotification((short)2, REMOTE_SUBSCRIPTION_SUBCATEGORY, SUBSCRIPTIONDELETED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndNodes(notification, proxyingNode, remoteNode);
    }

    public static void sendRemoteSubscriptionsExpiredNotification(String proxyingNode, String remoteNode) {
        INotification notification = m_mfContext.createNotification((short)2, REMOTE_SUBSCRIPTION_SUBCATEGORY, SUBSCRIPTIONEXPIRED_TYPE, 2);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndNodes(notification, proxyingNode, remoteNode);
    }

    private static void configNotificationBrokerAndNodes(INotification notification, String proxyingNode, String remoteNode) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("ProxyingNode", (Object)proxyingNode);
        notification.setAttribute("RemoteNode", (Object)remoteNode);
        m_mfContext.sendNotification(notification);
    }

    public static void sendRemoteSubscribeFailureNotification(String sourceBroker, String sourceNode, String reportingBroker, String remoteNode, String topic, int reasonCode) {
        INotification notification = m_mfContext.createNotification((short)2, REMOTE_SUBSCRIPTION_SUBCATEGORY, SUBSCRIBEFAILURE_TYPE, 2);
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerRouting(notification);
        notification.setAttribute("SourceBroker", (Object)sourceBroker);
        notification.setAttribute("SourceNode", (Object)sourceNode);
        notification.setAttribute("ReportingBroker", (Object)reportingBroker);
        notification.setAttribute("RemoteNode", (Object)remoteNode);
        notification.setAttribute("Topic", (Object)topic);
        notification.setAttribute("Reason", (Object)new Integer(reasonCode));
        m_mfContext.sendNotification(notification);
    }

    public static void sendMessageUndeliveredNotification(String broker, String messageID, String destination, int reason, boolean preserved, boolean preservedInQueue, String preservedDestName) {
        INotification notification = m_mfContext.createNotification((short)2, MESSAGE_SUBCATEGORY, UNDELIVERED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBroker(broker, notification);
        notification.setAttribute("MessageID", (Object)messageID);
        notification.setAttribute("Destination", (Object)destination);
        notification.setAttribute("Reason", (Object)new Integer(reason));
        notification.setAttribute("Preserved", (Object)new Boolean(preserved));
        if (preserved) {
            notification.setAttribute("UndeliveredDestination", (Object)preservedDestName);
        } else {
            notification.setAttribute("UndeliveredDestination", (Object)" ");
        }
        notification.setAttribute("IsUndeliveredDestinationQueue", (Object)new Boolean(preservedInQueue));
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationAttributesBroker(String broker, INotification notification) {
        notification.setLogType((short)0);
        notification.setAttribute("Broker", (Object)broker);
        notification.setAttribute("Routing", (Object)Config.ROUTING_NODE_NAME);
    }

    public static void sendMessagePubSubCleanupFinishedNotification(long deletedCount, long elapsedTime) {
        INotification notification = m_mfContext.createNotification((short)2, MESSAGE_SUBCATEGORY, PUBSUB_CLEANUP_FINISHED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndDeletedCount(deletedCount, elapsedTime, notification);
    }

    public static void sendMessageQueueCleanupFinishedNotification(long deletedCount, long elapsedTime) {
        INotification notification = m_mfContext.createNotification((short)2, MESSAGE_SUBCATEGORY, QUEUE_CLEANUP_FINISHED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationBrokerAndDeletedCount(deletedCount, elapsedTime, notification);
    }

    private static void configNotificationBrokerAndDeletedCount(long deletedCount, long elapsedTime, INotification notification) {
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("DeletedCount", (Object)deletedCount);
        notification.setAttribute("ElapsedTime", (Object)elapsedTime);
        m_mfContext.sendNotification(notification);
    }

    public static void sendBrokerSubscribeNotification(String brokerName, String nodeName, String userName, String clientID, String connectID, String topicName, String subscriptionName, String remoteNodeName, String remoteBrokerName, String remoteUserName) {
        BrokerManagementNotificationsHelper.createAndConfigNotification(subscriptionName, remoteNodeName, remoteBrokerName, remoteUserName, SUBSCRIBE_NOTIFICATION_TYPE, brokerName, nodeName, userName, clientID, connectID, topicName);
    }

    public static void sendBrokerUnsubscribeNotification(String brokerName, String nodeName, String userName, String clientID, String connectID, String topicName, String subscriptionName, String remoteNodeName, String remoteBrokerName, String remoteUserName) {
        BrokerManagementNotificationsHelper.createAndConfigNotification(subscriptionName, remoteNodeName, remoteBrokerName, remoteUserName, UNSUBSCRIBE_NOTIFICATION_TYPE, brokerName, nodeName, userName, clientID, connectID, topicName);
    }

    private static void createAndConfigNotification(String subscriptionName, String remoteNodeNameParam, String remoteBrokerNameParam, String remoteUserNameParam, String eventName, String brokerName, String nodeName, String userName, String clientID, String connectID, String topicName) {
        String remoteUserName = remoteUserNameParam;
        String remoteNodeName = remoteNodeNameParam;
        String remoteBrokerName = remoteBrokerNameParam;
        if (subscriptionName == null) {
            subscriptionName = "";
        }
        if (remoteNodeName == null) {
            remoteNodeName = "";
        }
        if (remoteBrokerName == null) {
            remoteBrokerName = "";
        }
        if (remoteUserName == null) {
            remoteUserName = "";
        }
        INotification notification = BrokerManagementNotificationsHelper.createBrokerNotification(SESSION_SUBCATEGORY, eventName, brokerName, nodeName, userName, clientID, connectID);
        BrokerManagementNotificationsHelper.configNotificationAttributesRemote(notification, remoteBrokerName, remoteNodeName, remoteUserName, subscriptionName, topicName);
    }

    private static void configNotificationAttributesRemote(INotification notification, String remoteBrokerName, String remoteNodeName, String remoteUserName, String subscriptionName, String topicName) {
        notification.setAttribute("Topic", (Object)topicName);
        notification.setAttribute("SubscriptionName", (Object)subscriptionName);
        notification.setAttribute("RemoteNode", (Object)remoteNodeName);
        notification.setAttribute("RemoteBroker", (Object)remoteBrokerName);
        notification.setAttribute("RemoteUser", (Object)remoteUserName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendBrokerSubscriberPauseNotification(String brokerName, String nodeName, String userName, String clientID, String connectID, String topicName, String subscriptionName) {
        BrokerManagementNotificationsHelper.createAndSendNotification(subscriptionName, SUBSCRIBER_PAUSE_NOTIFICATION_TYPE, brokerName, nodeName, userName, clientID, connectID, topicName);
    }

    public static void sendBrokerSubscriberResumeNotification(String brokerName, String nodeName, String userName, String clientID, String connectID, String topicName, String subscriptionName) {
        BrokerManagementNotificationsHelper.createAndSendNotification(subscriptionName, SUBSCRIBER_RESUME_NOTIFICATION_TYPE, brokerName, nodeName, userName, clientID, connectID, topicName);
    }

    private static void createAndSendNotification(String subscriptionNameParam, String notificationType, String brokerName, String nodeName, String userName, String clientID, String connectID, String topicName) {
        String subscriptionName = subscriptionNameParam;
        if (subscriptionName == null) {
            subscriptionName = "";
        }
        INotification notification = BrokerManagementNotificationsHelper.createBrokerNotification(SESSION_SUBCATEGORY, notificationType, brokerName, nodeName, userName, clientID, connectID);
        notification.setAttribute("Topic", (Object)topicName);
        notification.setAttribute("SubscriptionName", (Object)subscriptionName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendBrokerStartReceiveNotification(String brokerName, String nodeName, String userName, String clientID, String connectID, String queueName) {
        INotification notification = BrokerManagementNotificationsHelper.createBrokerNotification(SESSION_SUBCATEGORY, START_RECEIVE_NOTIFICATION_TYPE, brokerName, nodeName, userName, clientID, connectID);
        notification.setAttribute("Queue", (Object)queueName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendBrokerEndReceiveNotification(String brokerName, String nodeName, String userName, String clientID, String connectID, String queueName) {
        INotification notification = BrokerManagementNotificationsHelper.createBrokerNotification(SESSION_SUBCATEGORY, END_RECEIVE_NOTIFICATION_TYPE, brokerName, nodeName, userName, clientID, connectID);
        notification.setAttribute("Queue", (Object)queueName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendFlowToDiskNotification(String connectID, String user, String durableClientID, String durableSubscriptionName, String topic, boolean ftdStarted) {
        INotification notification = m_mfContext.createNotification((short)2, FLOWCONTROL_SUBCATEGORY, ftdStarted ? FTDSTART_TYPE : FTDEND_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerName(notification);
        notification.setAttribute("SubscriptionConnectID", (Object)connectID);
        notification.setAttribute("SubscriptionUser", (Object)user);
        notification.setAttribute("DurableClientID", (Object)durableClientID);
        notification.setAttribute("DurableSubscriptionName", (Object)durableSubscriptionName);
        notification.setAttribute("SubscriptionTopic", (Object)topic);
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationAttributesBrokerName(INotification notification) {
        notification.setLogType((short)0);
        notification.setAttribute("Broker", (Object)Config.BROKER_NAME);
        notification.setAttribute("Routing", (Object)Config.ROUTING_NODE_NAME);
    }

    public static void sendSlowSubscriberNotification(IClientContext clientContext, long timeThreshold, long maxTimeOnBufferValueMs) {
        ClientSecurityContext ccSecurityContext = clientContext.getCSC();
        BrokerSubscription userSubscription = clientContext.getSubscriptions().getUserSubscription();
        String appId = ccSecurityContext.getAppid();
        INotification notification = m_mfContext.createNotification((short)2, SESSION_SUBCATEGORY, SLOWSUBSCRIBER_TYPE, 3);
        notification.setLogType((short)0);
        notification.setAttribute("Message", (Object)"Buffer time exceeded.");
        BrokerManagementNotificationsHelper.configNotificationAttributesAppUser(appId, ccSecurityContext, notification);
        notification.setAttribute("Topic", (Object)userSubscription.getTopic());
        notification.setAttribute("Subject", (Object)userSubscription.getSubject().getSubjectString());
        notification.setAttribute("Time threshold", (Object)(timeThreshold + " ms"));
        notification.setAttribute("Time on buffer", (Object)(maxTimeOnBufferValueMs + " ms"));
        BrokerManagementNotificationsHelper.configNotificationAttributesConnectionJmsClient(appId, clientContext, notification);
    }

    public static void sendBackloggedSessionSkipNotification(IClientContext clientContext, BrokerSubscription bs) {
        ClientSecurityContext ccSecurityContext = clientContext.getCSC();
        BrokerSubscription userSubscription = clientContext.getSubscriptions().getUserSubscription();
        if (userSubscription == null) {
            userSubscription = bs;
        }
        String appId = ccSecurityContext.getAppid();
        INotification notification = m_mfContext.createNotification((short)2, SESSION_SUBCATEGORY, BACKLOGGED_SESSION_SKIP_TYPE, 3);
        notification.setLogType((short)0);
        notification.setAttribute("Message", (Object)"Backlogged Session Skip.");
        BrokerManagementNotificationsHelper.configNotificationAttributesAppUser(appId, ccSecurityContext, notification);
        if (clientContext.getConnection() != null) {
            notification.setAttribute("Connection URL", (Object)clientContext.getConnection().getAcceptorUrl());
        }
        notification.setAttribute("Topic", (Object)userSubscription.getTopic());
        notification.setAttribute("Subject", (Object)userSubscription.getSubject().getSubjectString());
        BrokerManagementNotificationsHelper.configNotificationAttributesConnectionJmsClient(appId, clientContext, notification);
    }

    private static void configNotificationAttributesConnectionJmsClient(String appId, IClientContext clientContext, INotification notification) {
        try {
            notification.setAttribute("Connect Id", (Object)DurableSubscriptionUtil.getConnectID(appId, clientContext));
            notification.setAttribute("JMSClient Id", (Object)DurableSubscriptionUtil.getJMSClientID(appId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationAttributesAppUser(String appId, ClientSecurityContext ccSecurityContext, INotification notification) {
        notification.setAttribute("App Id", (Object)appId);
        notification.setAttribute("User Id", (Object)ccSecurityContext.getUid());
        notification.setAttribute("Client IP", (Object)ccSecurityContext.getClientIPAddress());
    }

    public static void sendAcceptorFailureNotification(String acceptorName, String acceptorUrl, boolean primary) {
        INotification notification = m_mfContext.createNotification((short)2, STATE_SUBCATEGORY, primary ? PRIMARY_ACCEPTOR_STATUS_TYPE : ACCEPTOR_STATUS_TYPE, 2);
        BrokerManagementNotificationsHelper.configNotificationAttributesBrokerRouting(notification);
        notification.setAttribute("AcceptorName", (Object)acceptorName);
        if (acceptorUrl != null) {
            notification.setAttribute("AcceptorUrl", (Object)acceptorUrl);
        }
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationAttributesBrokerRouting(INotification notification) {
        notification.setLogType((short)1);
        notification.setAttribute("Broker", (Object)Config.BROKER_NAME);
        notification.setAttribute("Routing", (Object)Config.ROUTING_NODE_NAME);
    }

    private static INotification createBrokerNotification(String subcategory, String notificationType, String brokerName, String nodeName, String userNameParam, String clientIDParam, String connectIDParam) {
        String userName = userNameParam;
        String connectID = connectIDParam;
        String clientID = clientIDParam;
        if (userName == null) {
            userName = "";
        }
        if (clientID == null) {
            clientID = "";
        }
        if (connectID == null) {
            connectID = "";
        }
        INotification notification = BrokerManagementNotificationsHelper.createNotification(subcategory, notificationType, brokerName, nodeName, userName);
        notification.setAttribute("ClientID", (Object)clientID);
        notification.setAttribute("ConnectID", (Object)connectID);
        return notification;
    }

    private static INotification createNotification(String subcategory, String notificationType, String brokerName, String nodeName, String userName) {
        INotification notification = m_mfContext.createNotification((short)2, subcategory, notificationType, 3);
        notification.setLogType((short)0);
        notification.setAttribute("Broker", (Object)brokerName);
        notification.setAttribute("Routing", (Object)nodeName);
        notification.setAttribute("User", (Object)userName);
        return notification;
    }

    private static String filterConnectionConnectID(String connectIDParam) {
        String connectID = connectIDParam;
        if (NOTIFY_SYSTEM_CONNECTIONS) {
            return connectID;
        }
        if (connectID == null) {
            return connectID;
        }
        if (connectID.indexOf("$SESSION$") >= 0) {
            return null;
        }
        if (connectID.indexOf("$DURABLE$") >= 0) {
            return null;
        }
        if (connectID.indexOf("$NONDURABLE$") >= 0) {
            return null;
        }
        if (connectID.indexOf("$QR$") >= 0) {
            return null;
        }
        if (connectID.indexOf("$QB$") >= 0) {
            return null;
        }
        if (connectID.endsWith("$CONNECTION$")) {
            connectID = connectID.substring(0, connectID.lastIndexOf("$CONNECTION$"));
        }
        return connectID;
    }

    public static void sendDbCompactNotification(Integer id, String name, Throwable th, int level) {
        INotification notification = m_mfContext.createNotification((short)2, STATE_SUBCATEGORY, DBCOMPACT_TYPE, level);
        notification.setAttribute("State", (Object)id);
        notification.setAttribute("StateStr", (Object)name);
        if (th != null) {
            notification.setAttribute("Exception", (Object)(th.getClass() + ":" + th.getMessage()));
        }
        m_mfContext.sendNotification(notification);
    }

    public static void sendDurSubTrimInitiatedNotification(String sentBy, String connectId, String userName, String durSubName, String topic, long trimDate) {
        INotification notification = m_mfContext.createNotification((short)2, SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_OP_INITIATED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesSubscription(connectId, durSubName, notification, sentBy, topic, trimDate, userName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendDurSubTrimCompletedNotification(String sentBy, String connectId, String userName, String durSubName, String topic, long trimDate) {
        INotification notification = m_mfContext.createNotification((short)2, SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_OP_COMPLETED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesSubscription(connectId, durSubName, notification, sentBy, topic, trimDate, userName);
        m_mfContext.sendNotification(notification);
    }

    public static void sendDurSubTrimCanceledNotification(String sentBy, String connectId, String userName, String durSubName, String topic, long trimDate, String reason) {
        INotification notification = m_mfContext.createNotification((short)2, SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_OP_CANCELLED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesSubscription(connectId, durSubName, notification, sentBy, topic, trimDate, userName);
        notification.setAttribute("Reason", (Object)reason);
        m_mfContext.sendNotification(notification);
    }

    public static void sendDurSubTrimDbMsgDeleteDoneNotification(String sentBy, String connectId, String userName, String durSubName, String topic, long trimDate, long trimmedCount) {
        INotification notification = m_mfContext.createNotification((short)2, SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_DB_MESSAGES_DELETED_TYPE, 3);
        BrokerManagementNotificationsHelper.configNotificationAttributesSubscription(connectId, durSubName, notification, sentBy, topic, trimDate, userName);
        notification.setAttribute("Trimmed Count", (Object)new Long(trimmedCount));
        m_mfContext.sendNotification(notification);
    }

    private static void configNotificationAttributesSubscription(String connectId, String durSubName, INotification notification, String sentBy, String topic, long trimDate, String userName) {
        notification.setLogType((short)0);
        notification.setAttribute("Broker", (Object)Config.BROKER_NAME);
        notification.setAttribute("Sent By", (Object)sentBy);
        notification.setAttribute("SubscriptionConnectID", (Object)connectId);
        notification.setAttribute("SubscriptionUser", (Object)userName);
        notification.setAttribute("DurableSubscriptionName", (Object)durSubName);
        notification.setAttribute("SubscriptionTopic", (Object)topic);
        notification.setAttribute("Trim Date", (Object)new Date(trimDate).toString());
    }

    private static String getConnectionMemberLabel(IClientContext cc) {
        String result = "n/a";
        ClientSecurityContext csc = cc.getCSC();
        if (csc != null) {
            result = csc.getDisplayInfo().getName();
        }
        return result;
    }

    static {
        NOTIFY_SYSTEM_CONNECTIONS = Boolean.getBoolean("com.sonicsw.mq.showSystemConns");
        NOTIFICATION_INFOS = new ArrayList();
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, CONNECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Connection connect."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, DISCONNECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Connection disconnect."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, REJECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Connection attempt rejected."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, DROP_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Connection dropped/aborted."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, REDIRECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Connection redirected to another broker."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, RECONNECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Connection reconnect."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, PUBPAUSE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Publisher paused due to flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, PUBRESUME_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Publisher resumed after flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, SENDPAUSE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Sender paused due to flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, SENDRESUME_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Sender resumed after flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, RMBUFFERFULL_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Reliable Message Re-order Buffer Full."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, RMBUFFERAVAILABLE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Reliable Message Re-order Buffer Available."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, FTDSTART_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Subscriber has started flowing messages to disk."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SLOWSUBSCRIBER_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Slow subscriber detected."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, BACKLOGGED_SESSION_SKIP_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Backlogged session skip in group subscription."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, FTDEND_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Subscriber has stopped flowing messages to disk."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, DMQCAPACITY_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Dead Message Queue capacity warning."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, LOGCAPACITY_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Recovery log capacity warning."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], REMOTE_SUBSCRIPTION_SUBCATEGORY, SUBSCRIBEFAILURE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Subscription undelivered to requested remote node."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], REMOTE_SUBSCRIPTION_SUBCATEGORY, SUBSCRIPTIONDELETED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Remote subscription manually deleted."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], REMOTE_SUBSCRIPTION_SUBCATEGORY, SUBSCRIPTIONEXPIRED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Remote subscription has expired."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], MESSAGE_SUBCATEGORY, UNDELIVERED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Message undelivered to requested destination."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], MESSAGE_SUBCATEGORY, PUBSUB_CLEANUP_FINISHED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "PubSub messages cleanup finished."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], MESSAGE_SUBCATEGORY, QUEUE_CLEANUP_FINISHED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Queue messages cleanup finished."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, REPLICATION_CONNECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Replication connection connect."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, REPLICATION_DISCONNECT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Replication connection disconnect."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], CONNECTION_SUBCATEGORY, REPLICATION_RETRY_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Replication connection retry."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, REPLICATION_STATE_CHANGE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Replication state change."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, REPLICATION_CHANNEL_SWITCH_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Replication channel switch."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, REPLICATION_ACTIVATE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Replication connection activation."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIBE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Client subscription."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, UNSUBSCRIBE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Client unsubscribe."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIBER_PAUSE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable subscription pause."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIBER_RESUME_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable subscription resumption."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, START_RECEIVE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Open queue receiver."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, END_RECEIVE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Close queue receiver."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, ACKNOWLEDGEMENT_PAUSE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable subscriber paused acknowledging messages (while acknowledgement monitoring is enabled)."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, ACCEPTOR_STATUS_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "An acceptor failed to successufly be started"));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, PRIMARY_ACCEPTOR_STATUS_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "The primary acceptor failed to successufly be started"));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], STATE_SUBCATEGORY, DBCOMPACT_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "A change has occured in the database compaction state."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_OP_INITIATED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable Subscription Trim Operation invoked."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_OP_CANCELLED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable Subscription Trim Operation cancelled."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_OP_COMPLETED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable Subscription Trim Operation returned."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], SESSION_SUBCATEGORY, SUBSCRIPTION_TRIM_DB_MESSAGES_DELETED_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Durable Subscription Trim Operation completed message deletions from DB."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, CLUSTER_CONNECTION_PAUSE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Cluster connection paused due to flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, CLUSTER_CONNECTION_RESUME_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Cluster connection resumed after flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, ROUTING_CONNECTION_PAUSE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Routing connection paused due to flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, ROUTING_CONNECTION_RESUME_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Routing connection resumed after flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, ROUTING_CONNECTION_SENDER_PAUSE_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "(Sender side notification) Routing connection paused due to flow control."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[2], FLOWCONTROL_SUBCATEGORY, ROUTING_CONNECTION_SENDER_RESUME_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "(Sender side notification) Routing connection resumed after flow control."));
    }
}

