/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.cert.BrokerTrustStore;

public class BrokerTrustStoreChangeHandler
implements IAttributeChangeHandler {
    private BrokerTrustStore m_store = null;

    public BrokerTrustStoreChangeHandler(BrokerTrustStore store) {
        this.m_store = store;
    }

    public void itemDeleted() {
        this.m_store.reset();
    }

    public void itemModified(Object newValue) {
        String pwd2;
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        boolean reload = false;
        for (i = 0; i < newAttributes.length; ++i) {
            if (newAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                try {
                    this.m_store.setURL((String)delta.getNewValue(newAttributes[i]));
                    reload = true;
                }
                catch (NotModifiedAttException notModifiedAttException) {}
                continue;
            }
            if (!newAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
            try {
                pwd2 = (String)delta.getNewValue(newAttributes[i]);
                this.m_store.setPassword(pwd2 == null ? null : pwd2.toCharArray());
                reload = true;
                continue;
            }
            catch (NotModifiedAttException pwd2) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            if (modifiedAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                try {
                    this.m_store.setURL((String)delta.getNewValue(modifiedAttributes[i]));
                    reload = true;
                }
                catch (NotModifiedAttException pwd2) {}
                continue;
            }
            if (!modifiedAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
            try {
                pwd2 = (String)delta.getNewValue(modifiedAttributes[i]);
                this.m_store.setPassword(pwd2 == null ? null : pwd2.toCharArray());
                reload = true;
                continue;
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            if (deletedAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                this.m_store.setURL(null);
                reload = true;
                continue;
            }
            if (!deletedAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
            this.m_store.setPassword(null);
            reload = true;
        }
        if (reload) {
            BrokerComponent.getComponentContext().logMessage("Reloading broker trust store", 3);
            try {
                this.m_store.reload();
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(ex.getMessage(), 2);
            }
        }
    }
}

