/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mq.common.runtime.IConnectionMemberDetails;
import com.sonicsw.mq.common.runtime.IConnectionMemberInfo;
import com.sonicsw.mq.common.runtime.IConnectionTreeNode;
import com.sonicsw.mq.common.runtime.impl.ConnectionTreeNode;
import com.sonicsw.mq.common.runtime.impl.Destination;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import java.util.ArrayList;
import java.util.Set;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ISubject;

public class ConnectionOperationsHelper {
    private static final int MAX_CONNECTION_TREE_DEPTH = 5;
    private static IComponentContext s_mfContext;
    private static BrokerComponent s_component;

    static synchronized void init(IComponentContext mfContext) {
        s_component = BrokerComponent.getBrokerComponent();
        s_mfContext = mfContext;
    }

    public static ArrayList getConnectionTree(ArrayList nodes, Integer depth) throws MFException {
        int depthAsInt;
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        int n = depthAsInt = depth == null ? Integer.MAX_VALUE : depth;
        if (depthAsInt < 0) {
            throw new IllegalArgumentException("'depth' parameter must be positive");
        }
        ArrayList<IConnectionTreeNode> result = new ArrayList<IConnectionTreeNode>();
        if (nodes == null) {
            IConnectionTreeNode resultNode = RuntimeDataFactory.createConnectionTreeNode(null, null);
            Set connections = AgentRegistrar.getAgentRegistrar().getAllConnectionClients(true);
            for (IClientContext cc : connections) {
                IConnectionTreeNode connNode = ConnectionOperationsHelper.buildConnectionTree(resultNode, cc.getId(), depthAsInt - 1);
                ConnectionOperationsHelper.addChild(connNode, resultNode);
            }
            result.add(resultNode);
        } else {
            for (Long ref : nodes) {
                IConnectionTreeNode memberNode = null;
                if (ref != null) {
                    memberNode = ConnectionOperationsHelper.buildConnectionTree(null, ref, depthAsInt);
                }
                result.add(memberNode);
            }
        }
        return result;
    }

    private static IConnectionTreeNode buildConnectionTree(IConnectionTreeNode parent, long memberRef, int depthParam) {
        IClientContext cc;
        int depth = depthParam;
        if (depth < 0) {
            return null;
        }
        depth = depth > 5 ? 5 : depth;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(memberRef);
        }
        catch (EClientNotRegistered e) {
            return null;
        }
        IConnectionMemberInfo info = ConnectionOperationsHelper.buildConnectionMemberInfo(cc);
        if (info == null) {
            return null;
        }
        IConnectionTreeNode thisNode = RuntimeDataFactory.createConnectionTreeNode(info, parent);
        ArrayList childRefs = info.getChildRefs();
        if (depth > 0 && childRefs != null) {
            for (Long childRef : childRefs) {
                if (childRef == null) continue;
                IConnectionTreeNode childNode = ConnectionOperationsHelper.buildConnectionTree(thisNode, childRef, depth - 1);
                ConnectionOperationsHelper.addChild(childNode, thisNode);
            }
        }
        return thisNode;
    }

    private static void addChild(IConnectionTreeNode childNode, IConnectionTreeNode thisNode) {
        if (childNode != null) {
            ((ConnectionTreeNode)thisNode).addChild(childNode);
        }
    }

    public static IConnectionMemberDetails getConnectionMemberDetails(Long ref) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (ref == null) {
            throw new IllegalArgumentException("'ref' parameter is null");
        }
        IConnectionMemberDetails result = ConnectionOperationsHelper.buildConnectionMemberDetails(ref);
        return result;
    }

    public static ArrayList getConnectionMemberDetails(ArrayList refs) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (refs == null) {
            throw new IllegalArgumentException("'refs' parameter is null");
        }
        ArrayList<IConnectionMemberDetails> result = new ArrayList<IConnectionMemberDetails>();
        for (Long ref : refs) {
            IConnectionMemberDetails memberDetails = null;
            if (ref != null) {
                memberDetails = ConnectionOperationsHelper.buildConnectionMemberDetails(ref);
            }
            result.add(memberDetails);
        }
        return result;
    }

    private static IConnectionMemberDetails buildConnectionMemberDetails(long memberRef) {
        IClientContext cc;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(memberRef);
        }
        catch (EClientNotRegistered e) {
            return null;
        }
        IConnectionMemberInfo info = ConnectionOperationsHelper.buildConnectionMemberInfo(cc);
        if (info == null) {
            return null;
        }
        Destination destination = null;
        short type = info.getType();
        if (type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 10 || type == 11) {
            ISubject subject;
            BrokerSubscription subscription = cc.getSubscriptions().getUserSubscription();
            ISubject iSubject = subject = subscription == null ? null : subscription.getSubject();
            if (subject != null) {
                destination = new Destination(null, subject.toByteArray());
            }
        }
        IConnectionMemberDetails details = RuntimeDataFactory.createConnectionMemberDetails(info, cc.getState(), cc.getCreationTime(), cc.getLastStateChangeTime(), destination);
        cc.appendConnectionMemberProperties(details.getProperties());
        return details;
    }

    private static IConnectionMemberInfo buildConnectionMemberInfo(IClientContext cc) {
        String name;
        short type;
        if (cc == null) {
            return null;
        }
        ClientSecurityContext csc = cc.getCSC();
        if (csc == null) {
            return null;
        }
        ClientSecurityContext.ISecurityContextDisplayInfo displayInfo = csc.getDisplayInfo();
        if (displayInfo == null) {
            type = 0;
            name = csc.getAppid();
        } else {
            type = displayInfo.getType();
            name = displayInfo.getName();
        }
        Long ref = new Long(cc.getId());
        Long parentRef = new Long(csc.getParentId());
        ArrayList childRefs = null;
        Set childIds = csc.getChildIds();
        if (childIds != null && !childIds.isEmpty()) {
            childRefs = new ArrayList(childIds);
        }
        return RuntimeDataFactory.createConnectionMemberInfo(name, type, ref, parentRef, childRefs);
    }
}

