/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpConfigManager;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundEntry;

public class DirectURLConfigChangeHandler
implements IAttributeChangeHandler {
    private HTTPDirectInboundEntry m_urlEntry = null;
    private String m_protocolEntryName = null;
    private HTTPAcceptor m_acceptor = null;
    private IComponentContext m_context = BrokerComponent.getComponentContext();
    private boolean TRACE = false;

    public DirectURLConfigChangeHandler(HTTPDirectInboundEntry urlEntry, String protocolEntryName, HTTPAcceptor acceptor) {
        this.m_urlEntry = urlEntry;
        this.m_protocolEntryName = protocolEntryName;
        this.m_acceptor = acceptor;
    }

    public void itemDeleted() {
        HttpConfigManager configMgr = this.m_acceptor.getConfigManager(this.m_protocolEntryName);
        if (configMgr != null) {
            configMgr.removeInboundEntry(this.m_urlEntry);
        }
        this.m_context.logMessage("HttpDirect url entry \"" + this.m_urlEntry.getURL() + "\" is removed ", 2);
    }

    public void itemModified(Object newValue) {
        if (this.TRACE) {
            System.out.println("Entering DirectURLConfigChangeHandler.itemModified: parent = " + this.m_protocolEntryName + " entry.url = " + this.m_urlEntry.getURL());
        }
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        int len = modifiedAttributes.length;
        String attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = modifiedAttributes[i];
            this.setAttribute(attributeName, delta);
        }
    }

    private void setAttribute(String attributeName, IDeltaAttributeSet delta) {
        if (this.TRACE) {
            System.out.println("DirectURLConfigChangeHandler.itemModified: attributeName = " + attributeName);
        }
        if (attributeName.equals("URL")) {
            try {
                String url = (String)delta.getNewValue("URL");
                if (url != null) {
                    this.m_context.logMessage("HttpDirect url entry \"" + this.m_urlEntry.getURL() + "\" is renamed to \"" + url + "\"", 2);
                    this.m_acceptor.updateURLEntry(this.m_urlEntry, this.m_protocolEntryName, url);
                }
            }
            catch (NotModifiedAttException notModifiedAttException) {}
        } else if (this.TRACE) {
            System.out.println("DirectURLConfigChangeHandler.itemModified not dynamic updated: attributeName = " + attributeName);
        }
    }
}

