/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.gs.GSManager;
import progress.message.zclient.Envelope;
import progress.message.zclient.Message;

public final class RemoteSubscriptionHelper {
    private static IComponentContext m_mfContext;
    private static final byte CURRENT_VERSION = 0;

    static synchronized void init(IComponentContext mfContext) {
        if (m_mfContext != null) {
            throw new IllegalStateException("Context already set");
        }
        m_mfContext = mfContext;
    }

    public static ArrayList getRemoteSubscriptionSummary(String nodePrefix) {
        GSManager gsman = AgentRegistrar.getAgentRegistrar().getGSManager();
        return gsman.getRemoteSubscriptionSummary(nodePrefix);
    }

    public static ArrayList getRemoteSubscriptionSummary(String nodePrefix, Boolean getAllNodes) {
        GSManager gsman = AgentRegistrar.getAgentRegistrar().getGSManager();
        return gsman.getRemoteSubscriptionSummary(nodePrefix, getAllNodes);
    }

    public static ArrayList getRemoteSubscriptionTopics(String node, String pattern) {
        GSManager gsman = AgentRegistrar.getAgentRegistrar().getGSManager();
        return gsman.getRemoteSubscriptionTopics(node, pattern);
    }

    public static void deleteRemoteSubscriptions(ArrayList remoteNodes) throws MFException {
        for (String rn : remoteNodes) {
            RemoteSubscriptionHelper.deleteRemoteSubscriptions(rn);
        }
    }

    private static void deleteRemoteSubscriptions(String subscriptionHomeNode) throws MFException {
        try {
            Message request = new Message("$ISYS.GSA.globalAdminDelete");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(0);
            out.writeUTF(Config.BROKER_NAME);
            out.writeInt(0);
            out.writeUTF(subscriptionHomeNode);
            baos.close();
            request.setBody(baos.toByteArray());
            Envelope env = new Envelope(request);
            AgentRegistrar.getAgentRegistrar().getAdminSession().publishInternal(env, 0, false, true);
        }
        catch (Exception e) {
            throw new MFException(e.getMessage());
        }
    }

    public static void reconcileRemoteSubscriptions(ArrayList remoteNodes) throws MFException {
        for (String rn : remoteNodes) {
            RemoteSubscriptionHelper.reconcileRemoteSubscriptions(rn);
        }
    }

    private static void reconcileRemoteSubscriptions(String remoteNode) throws MFException {
        try {
            Message request = new Message("$ISYS.GSA.globalAdminReconcile");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(0);
            out.writeUTF(Config.BROKER_NAME);
            out.writeUTF(remoteNode);
            baos.close();
            request.setBody(baos.toByteArray());
            Envelope env = new Envelope(request);
            AgentRegistrar.getAgentRegistrar().getAdminSession().publishInternal(env, 0, false, true);
        }
        catch (Exception e) {
            throw new MFException(e.getMessage());
        }
    }
}

