/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.DestinationLookupException;
import com.sonicsw.net.http.HttpInException;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.WSDLLookupException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Request;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.net.https.server.SonicHttpsConnection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMsgTooBigException;

public class HttpHelper {
    private static final String DEBUG_NAME = "HttpHelper";
    private static final String SCHEMESEP = "://";
    private static final int SCHEMESEP_LEN = "://".length();
    public static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };
    public static final boolean ENABLE_TRANSPORTBINDING_SUITE_CHECKING = HttpHelper.getEnableTransportBingingSuiteCheckingValue();
    public static final boolean ENABLE_SECURE_CONVERSATION = HttpHelper.getEnableSecureConversion();
    private static final String[] s_ignoreHTTP = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Allow", "Authorization", "Cache-Control", "Connection", "Cookie", "Cookie2", "Date", "Expect", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Pragma", "Proxy-Authorization", "Range", "Referer", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Warning"};
    private static final String[] s_ignoreHTTPInResponseTrace = new String[]{"Date", "Server", "Servlet-Engine"};
    private static final String[] s_ignoreJMS = new String[]{"JMS_SonicMQ_ExtendedType", "JMS_SonicMQ_preserveUndelivered", "JMS_SonicMQ_destinationUndelivered", "JMS_SonicMQ_notifyUndelivered", "JMS_SonicMQ_undeliveredReasonCode", "JMS_SonicMQ_undeliveredTimestamp", "JMS_SonicMQ_perMessageEncryption", "JMS_SonicMQ_channel", "JMSXGroupID", "JMSXGroupSeq", "JMSXUserID", "X-HTTP-DestinationURL", "X-HTTP-ReceiveURL", "X-HTTP-RequestMethod", "X-HTTP-AuthUser", "X-HTTP-AuthPassword", "X-HTTP-RequestTimeout", "X-HTTP-Retries", "X-HTTP-RetryInterval", "Content-Length", "X-HTTP-ContentLength", "X-HTTP-ReplyAsSOAP", "X-WS-SuppressWSAHeaders", "X-WS-MessagePolicy", "X-WS-MessagePolicy-Out", "X-WS-MessagePolicy-Fault", "X-WS-MessageExchangeCorrelator", "X-WS-SequenceFaultDestination", "JMS_SonicMQ_lastMessageInGroup", "X-HTTP-GroupID", "LG_PARENT_SITE_STUB"};
    private static Hashtable<String, String> s_ignoreHTTPTable = null;
    private static Hashtable<String, String> s_ignoreHTTPInResponseTraceTable = null;
    private static Hashtable<String, String> s_ignoreJMSTable = null;
    private static Object s_initIgnoreHTTPTableLock = new Object();
    private static Object s_initIgnoreHTTPInResponseTraceTableLock = new Object();
    private static Object s_initIgnoreJMSTableLock = new Object();

    private static boolean getEnableTransportBingingSuiteCheckingValue() {
        try {
            return System.getProperty("ENABLE_TRANSPORTBINDING_SUITE_CHECKING") != null;
        }
        catch (SecurityException sex) {
            return false;
        }
    }

    private static boolean getEnableSecureConversion() {
        try {
            return System.getProperty("ENABLE_SECURE_CONVERSATION") != null;
        }
        catch (SecurityException sex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIgnoredHTTPProperty(String value) {
        Object object = s_initIgnoreHTTPTableLock;
        synchronized (object) {
            if (s_ignoreHTTPTable == null) {
                s_ignoreHTTPTable = new Hashtable();
                for (int i = 0; i < s_ignoreHTTP.length; ++i) {
                    String upper = s_ignoreHTTP[i].toUpperCase();
                    s_ignoreHTTPTable.put(upper, upper);
                }
            }
            return s_ignoreHTTPTable.contains(value.toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIgnoredJMSProperty(String value) {
        Object object = s_initIgnoreJMSTableLock;
        synchronized (object) {
            if (s_ignoreJMSTable == null) {
                s_ignoreJMSTable = new Hashtable();
                for (int i = 0; i < s_ignoreJMS.length; ++i) {
                    String upper = s_ignoreJMS[i].toUpperCase();
                    s_ignoreJMSTable.put(upper, upper);
                }
            }
            return s_ignoreJMSTable.contains(value.toUpperCase());
        }
    }

    public static boolean isIgnoredHTTPRequestTraceProperty(String value) {
        return HttpHelper.isIgnoredHTTPProperty(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIgnoredHTTPResponseTraceProperty(String value) {
        Object object = s_initIgnoreHTTPInResponseTraceTableLock;
        synchronized (object) {
            if (s_ignoreHTTPInResponseTraceTable == null) {
                s_ignoreHTTPInResponseTraceTable = new Hashtable();
                for (int i = 0; i < s_ignoreHTTPInResponseTrace.length; ++i) {
                    String lower = s_ignoreHTTPInResponseTrace[i].toLowerCase();
                    s_ignoreHTTPInResponseTraceTable.put(lower, lower);
                }
            }
            return s_ignoreHTTPInResponseTraceTable.contains(value.toLowerCase()) || HttpHelper.isIgnoredJMSProperty(value);
        }
    }

    public static boolean startsWithIgnoreCase(String str, String start) {
        return str.regionMatches(true, 0, start, 0, start.length());
    }

    public static String stripTrailingSlash(String path) {
        if (!path.endsWith("/")) {
            return path;
        }
        return path.substring(0, path.length() - 1);
    }

    public static Element getFirstChildElement(Element elem) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element elem) {
        for (Node n = elem.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static String extractCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        int startIndex = contentType.indexOf("charset");
        if (startIndex == -1) {
            return null;
        }
        int index = startIndex + "charset".length();
        String tmp = contentType.substring(index);
        StringTokenizer st = new StringTokenizer(tmp, "\"' =", false);
        String ce = (String)st.nextElement();
        return ce;
    }

    public static String resetCharset(String contentType, String charset) {
        StringBuffer newContentType = new StringBuffer();
        int startIndex = contentType.indexOf("charset");
        if (startIndex == -1) {
            int i = contentType.indexOf(";");
            if (i == -1) {
                newContentType.append(contentType);
            } else {
                newContentType.append(contentType.substring(0, i));
            }
            if (charset != null) {
                newContentType.append("; ").append("charset");
                newContentType.append("=\"").append(charset).append("\"");
            }
        } else if (charset != null) {
            newContentType.append(contentType.substring(0, startIndex));
            newContentType.append("charset");
            newContentType.append("=\"").append(charset).append("\"");
        } else {
            int i = contentType.indexOf(";");
            newContentType.append(contentType.substring(0, i));
        }
        return newContentType.toString();
    }

    public static String resetBoundary(String contentType, String boundary) {
        StringBuffer newContentType = new StringBuffer();
        int startIndex = contentType.indexOf("boundary=");
        if (startIndex > 0) {
            if ((startIndex = contentType.lastIndexOf(59, startIndex)) < 0) {
                newContentType.append(contentType);
            } else {
                newContentType.append(contentType.substring(0, startIndex));
                int endIndex = contentType.indexOf(59, startIndex + 1);
                if (endIndex > 0) {
                    newContentType.append(contentType.substring(endIndex, contentType.length()));
                }
            }
        } else {
            newContentType.append(contentType);
        }
        if (boundary != null) {
            if (!contentType.endsWith(";")) {
                newContentType.append(';');
            }
            newContentType.append(' ');
            newContentType.append("boundary").append("=");
            newContentType.append(boundary);
        }
        return newContentType.toString();
    }

    public static String makeBasicAuthKey(String userParam, String passwordParam) throws UnsupportedEncodingException {
        String user = userParam;
        String password = passwordParam;
        if (user == null) {
            user = "";
        }
        if (password == null) {
            password = "";
        }
        StringBuffer sbAuth = new StringBuffer(user).append(":").append(password);
        String auth = Base64.getEncoder().encodeToString(sbAuth.toString().getBytes());
        StringBuffer sbBasic = new StringBuffer("Basic").append(" ").append(auth);
        return sbBasic.toString();
    }

    public static boolean isHttps(URLConnection uc) {
        return HttpHelper.isHttps(uc.getURL());
    }

    public static boolean isHttps(URL u) {
        return HttpHelper.isHttps(u.toExternalForm());
    }

    public static boolean isHttps(String path) {
        return HttpHelper.startsWithIgnoreCase(path, "https:");
    }

    public static boolean isSonicfs(String url) {
        return HttpHelper.startsWithIgnoreCase(url, "sonicfs:");
    }

    public static boolean isSonic(String url) {
        return HttpHelper.startsWithIgnoreCase(url, "sonic:");
    }

    public static boolean isJndi(String url) {
        return HttpHelper.startsWithIgnoreCase(url, "jndi:");
    }

    public static String applySuffix(String prefixPathParam, String targetURL, String requestPath) throws MalformedURLException {
        String targetURL2;
        String prefixPath = prefixPathParam;
        DebugObject.class_debug(DEBUG_NAME, "resolve() - E: " + prefixPath + ", T:" + targetURL + ", R:" + requestPath);
        prefixPath = HttpHelper.stripTrailingSlash(prefixPath);
        if (!requestPath.startsWith(prefixPath)) {
            throw new IllegalArgumentException(prefixPath + " is not a prefix of " + requestPath);
        }
        if (prefixPath.endsWith("/")) {
            prefixPath = prefixPath.substring(0, prefixPath.length() - 1);
        }
        String suffix = requestPath.substring(prefixPath.length());
        DebugObject.class_debug(DEBUG_NAME, "resolve(): suffix is " + suffix);
        if (suffix.startsWith("/") && targetURL.endsWith("/") && !(targetURL2 = targetURL.substring(0, targetURL.length() - 1)).endsWith("/")) {
            suffix = suffix.substring(1, suffix.length());
        }
        String result = targetURL + suffix;
        DebugObject.class_debug(DEBUG_NAME, "resolve(): result is " + result);
        return result;
    }

    protected static String sonicToJndi(String url) throws MalformedURLException {
        DebugObject.class_debug(DEBUG_NAME, "sonicToJndi() - url is " + url);
        if (!HttpHelper.isSonic(url)) {
            throw new IllegalArgumentException(url + " is not a sonic: URL");
        }
        int index = url.indexOf(SCHEMESEP);
        if (index == -1) {
            throw new MalformedURLException(url);
        }
        int domainStart = index + SCHEMESEP_LEN;
        int domainEnd = url.indexOf(47, domainStart);
        if (index == -1) {
            throw new MalformedURLException(url);
        }
        String domain = url.substring(domainStart, domainEnd);
        DebugObject.class_debug(DEBUG_NAME, "sonicToJndi() - domain is " + domain);
        int nodeStart = domainEnd + 1;
        int nodeEnd = url.indexOf(47, nodeStart);
        if (nodeEnd == -1) {
            throw new MalformedURLException(url + " missing service name");
        }
        String node = url.substring(nodeStart, nodeEnd);
        DebugObject.class_debug(DEBUG_NAME, "sonicToJndi() - node is " + node);
        int serviceStart = nodeEnd + 1;
        int serviceEnd = url.indexOf(47, serviceStart);
        int serviceEnd2 = url.indexOf(58, serviceStart);
        if (serviceEnd == -1) {
            serviceEnd = serviceEnd2;
        } else if (serviceEnd2 != -1 && serviceEnd2 < serviceEnd) {
            serviceEnd = serviceEnd2;
        }
        String service = serviceEnd == -1 ? url.substring(serviceStart) : url.substring(serviceStart, serviceEnd);
        DebugObject.class_debug(DEBUG_NAME, "sonicToJndi() - service is " + service);
        StringBuffer buf = new StringBuffer();
        buf.append("JNDI://");
        buf.append("/SonicESB");
        buf.append('/').append(node);
        buf.append('/').append(service);
        String result = buf.toString();
        DebugObject.class_debug(DEBUG_NAME, "sonicToJndi() - result is " + result);
        return result;
    }

    public static String sonicToJndiEntry(String url) throws MalformedURLException {
        String base = HttpHelper.sonicToJndi(url);
        StringBuffer buf = new StringBuffer();
        buf.append(base).append("/Entry");
        return buf.toString();
    }

    public static String sonicToJndiWSDL(String url) throws MalformedURLException {
        String base = HttpHelper.sonicToJndi(url);
        StringBuffer buf = new StringBuffer();
        buf.append(base).append("/WSDL_URL");
        return buf.toString();
    }

    public static String sonicFromJndiWSDL(String jndi) {
        int endser = jndi.lastIndexOf("/");
        int beginser = jndi.lastIndexOf("/", endser - 1);
        return jndi.substring(beginser + 1, endser);
    }

    public static InputStream getSonicfsFile(String urlString) throws IOException {
        InputStream is = null;
        URL url = new URL(urlString);
        URLConnection connection = url.openConnection();
        is = connection.getInputStream();
        return is;
    }

    private static Object jndiLookup(HttpInRequest req, String jndiURL) throws NamingException, HttpInException {
        IComponentContext context;
        Context jndiContext;
        DebugObject.class_debug(DEBUG_NAME, "jndiLookup() - input URL is " + jndiURL);
        if (!HttpHelper.isJndi(jndiURL)) {
            throw new HttpInException(req, "Invalid JNDI URL: " + jndiURL);
        }
        String url = jndiURL.substring("JNDI://".length());
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if ((jndiContext = (context = BrokerComponent.getComponentContext()).getInitialContext()) == null) {
            throw new HttpInException(req, "Failed to create JNDI context: " + url);
        }
        DebugObject.class_debug(DEBUG_NAME, "jndiLookup() getConfiguration for /_MFContext/" + url);
        Object obj = jndiContext.lookup(url);
        DebugObject.class_debug(DEBUG_NAME, "jndiLookup() convert element to RefObj, " + obj);
        return obj;
    }

    public static Destination jndiDestinationLookup(HttpInRequest req, String jndiURL) throws DestinationLookupException {
        Object jmsDestination = null;
        try {
            Object obj = HttpHelper.jndiLookup(req, jndiURL);
            DebugObject.class_debug(DEBUG_NAME, "jndiDestinationLookup() get object, " + obj);
            if (obj != null) {
                AdministeredObjectFactory fact = new AdministeredObjectFactory();
                jmsDestination = (Destination)fact.getObjectInstance(obj, (Name)null, (Context)null, (Hashtable)null);
            }
        }
        catch (NamingException ex) {
            throw new DestinationLookupException(req, "Failed to look up JNDI destination: " + jndiURL, ex);
        }
        catch (Exception ex) {
            throw new DestinationLookupException(req, (Throwable)ex);
        }
        if (jmsDestination == null) {
            throw new DestinationLookupException(req, "The destination associated with: " + jndiURL + " is null");
        }
        DebugObject.class_debug(DEBUG_NAME, "jndiDestinationLookup() getJndiDestination " + jmsDestination.toString());
        return jmsDestination;
    }

    public static String jndiWsdlLookup(HttpInRequest req, String jndiURL) throws Exception {
        try {
            URL wsdlURL = (URL)HttpHelper.jndiLookup(req, jndiURL);
            DebugObject.class_debug(DEBUG_NAME, "jndiWsdlLookup() get wsdl, " + wsdlURL.getPath());
            return "SONICFS://" + wsdlURL.getPath();
        }
        catch (HttpInException ex) {
            String serName = HttpHelper.sonicFromJndiWSDL(jndiURL);
            throw new WSDLLookupException(req, "Failed to locate WSDL for Sonic service or process: " + serName, ex);
        }
        catch (NamingException ex) {
            String serName = HttpHelper.sonicFromJndiWSDL(jndiURL);
            throw new WSDLLookupException(req, "Failed to locate WSDL for Sonic service or process: " + serName, ex);
        }
    }

    public static boolean isMsgTooBigException(Exception e) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (!(t instanceof EMsgTooBigException)) continue;
            return true;
        }
        return false;
    }

    public static Request castToJettyRequest(HttpServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        throw new IllegalArgumentException("No org.eclipse.jetty.server.Request");
    }

    public static String requestLine(Request req) {
        return req.getMethod() + " " + req.getRequestURI() + " " + req.getHttpVersion();
    }

    public static SonicHttpsConnection castToSonicHttpsConnection(HttpServletRequest request) {
        if (request instanceof Request) {
            Connection connection = ((Request)request).getHttpChannel().getConnection();
            if (connection instanceof SonicHttpsConnection) {
                return (SonicHttpsConnection)connection;
            }
            throw new IllegalArgumentException("No SonicHttpsConnection");
        }
        throw new IllegalArgumentException("No org.eclipse.jetty.server.Request");
    }
}

