/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.Mgram2Http;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import progress.message.msg.IMgram;

public class HttpInResponse
extends Mgram2Http {
    protected HttpServletResponse m_res = null;
    protected String userResponsePairMessage = null;
    protected Integer userResponsePairCode = null;

    public HttpInResponse(HttpServletResponse res) {
        this.m_res = res;
    }

    public HttpServletResponse getResponse() {
        return this.m_res;
    }

    @Override
    public void setProperty(String key, String value) {
        if (key.equalsIgnoreCase("X-HTTP-ResponseCode")) {
            this.setUserResponseCode(Integer.parseInt(value));
            return;
        }
        if (key.equalsIgnoreCase("X-HTTP-ResponseMessage")) {
            this.setUserResponseMessage(value);
            return;
        }
        try {
            if (this.m_res.containsHeader(key)) {
                this.m_res.setHeader(key, null);
            }
        }
        catch (IllegalStateException e) {
            this.logMesssage(e);
        }
        catch (Exception e) {
            this.logMesssage(e);
        }
        try {
            this.m_res.addHeader(key, value);
        }
        catch (IllegalStateException e) {
            this.debugData(key, value, e);
        }
        catch (Exception e) {
            this.debugData(key, value, e);
        }
    }

    private <T0 extends Exception> void logMesssage(T0 e) {
    }

    private void debugData(String key, String value, Exception e) {
    }

    @Override
    public void setProperty(String key, boolean value) {
        this.setProperty(key, String.valueOf(value));
    }

    @Override
    public void setProperty(String key, long value) {
        this.setProperty(key, Long.toString(value));
    }

    @Override
    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setCode(int code) {
        this.m_res.setStatus(code);
    }

    public void setStatusWithReason(int code, String message) {
        this.m_res.setStatus(code, message);
    }

    public void createResponse(int code) throws IOException {
        this.createResponse(code, null);
    }

    protected void createResponseInternal(int code, String message) {
        if (message != null) {
            this.setStatusWithReason(code, message);
        }
        this.setCode(code);
    }

    public void createResponse(int code, String message) {
        this.createResponseInternal(code, message);
    }

    public void create501NotSupportedResponse(String message) {
        this.createResponse(501, message);
    }

    public void create500InternalErrorResponse(String message) {
        this.createResponse(500, message);
    }

    public void create404FileNotFoundResponse(String message) {
        this.createResponseInternal(404, message);
    }

    public void create413MessageTooLargeResponse() {
        this.createResponse(413, "Message size larger than configured limit (max message size).");
    }

    public void createContentResponse(IMgram mgram) throws MessageHandlingException, Exception {
        this.createEncodedContentResponse(mgram, "ISO-8859-1");
    }

    public void createEncodedContentResponse(IMgram mgram, String reqEncoding) throws MessageHandlingException, Exception {
        this.handleCopyAllProperties(mgram);
        this.handleEncodedContentType(mgram, reqEncoding);
        this.handleContent(mgram);
        this.contentToStream(this.getOutputStream());
    }

    public void createByteArrayContentResponse(byte[] data) throws Exception {
        this.createByteArrayContentResponse(data, "ISO-8859-1");
    }

    public void createByteArrayContentResponse(byte[] data, String contentType) throws Exception {
        if (data == null) {
            this.setContentLength(0);
            return;
        }
        this.setContentType(contentType);
        this.setContent(data, 0, data.length);
        this.setContentLength(data.length);
        this.contentToStream(this.getOutputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_res.getOutputStream();
    }

    private void setUserResponseCode(int responseCode) {
        this.userResponsePairCode = responseCode;
        if (this.userResponsePairMessage != null) {
            this.m_res.setStatus(responseCode, this.userResponsePairMessage);
        }
    }

    private void setUserResponseMessage(String responseMessage) {
        this.userResponsePairMessage = responseMessage;
        if (this.userResponsePairCode != null) {
            this.m_res.setStatus(this.userResponsePairCode.intValue(), responseMessage);
        }
    }
}

