/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConfigManager;
import com.sonicsw.net.http.HttpProtocolHandler;
import java.net.Socket;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundProtocolHolder;
import progress.message.net.http.server.HttpXProtocolHandlerFactory;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.net.http.server.SonicHttpServer;

public abstract class HttpProtocolHandlerFactory
extends HttpXProtocolHandlerFactory {
    private String m_protocol = null;
    private HttpConfigManager m_configMgr = null;
    private String m_mgrName = null;
    private String m_acceptorName = null;

    public HttpProtocolHandlerFactory(HttpXProtocolHandlerFactory next, String protocol, Properties properties) {
        super(properties, next);
        this.m_protocol = protocol;
        HTTPDirectInboundProtocolHolder ph = (HTTPDirectInboundProtocolHolder)properties.get("HTTP_INBOUND_HOLDER");
        HTTPAcceptor acceptor = (HTTPAcceptor)AcceptorHolder.getAcceptorHolder().getAcceptor(ph.getAcceptorID());
        this.m_acceptorName = acceptor.getAcceptorName();
        this.m_mgrName = ph.getEntryName();
        this.m_configMgr = acceptor.getConfigManager(this.m_mgrName);
    }

    String getProtocolName() {
        return this.m_mgrName;
    }

    String getAcceptorName() {
        return this.m_acceptorName;
    }

    @Override
    public IHttpRequestHandler createHandler(HttpServletRequest req, HttpServletResponse resp, SonicHttpServer server, Socket socket) {
        HttpConfigInfo info = this.findMatchConfig(req);
        if (info != null) {
            if (info.getInstance() == null) {
                info.setInstance(this.createHandler(info));
            }
            return (HttpProtocolHandler)info.getInstance();
        }
        return null;
    }

    public HttpConfigInfo findMatchConfig(HttpServletRequest req) {
        HttpConfigInfo info;
        if (this.m_configMgr == null || !this.m_configMgr.isActive()) {
            if (this.DEBUG) {
                this.debug(" handler factory unusable, mgr name  " + this.m_mgrName);
            }
            return null;
        }
        String path = req.getRequestURI();
        if (this.DEBUG) {
            this.debug(this.m_protocol + " handler try to match for " + path);
            this.m_configMgr.printAllUrl();
        }
        if ((info = this.m_configMgr.getBestByName(path)) != null) {
            if (this.DEBUG) {
                this.debug(this.m_protocol + " handler found match for " + path + " with " + info.getName());
            }
            if (info.getFactoryInstance() == null) {
                info.setFactoryInstance(this);
                if (this.DEBUG) {
                    this.debug(" factory register itself for config " + info.getName() + " this fac is " + this.m_mgrName);
                }
            }
            return info;
        }
        return null;
    }

    @Override
    public IHttpRequestHandler getHandler(HttpServletRequest req, HttpServletResponse resp, SonicHttpServer server, Socket socket) {
        if (this.DEBUG) {
            this.debug("trying to find best handler for " + req.getRequestURI());
        }
        HttpConfigInfo bestConfig = null;
        HttpXProtocolHandlerFactory next = this;
        while ((next = this.getNextHttpFactory(next)) != null) {
            HttpConfigInfo config = next.findMatchConfig(req);
            if (config != null) {
                if (bestConfig == null || config.getUrlLength() > bestConfig.getUrlLength()) {
                    bestConfig = config;
                }
                if (config.isBestMatch(req.getRequestURI())) break;
            }
            next = next.getNext();
        }
        if (bestConfig == null) {
            if (this.DEBUG) {
                this.debug("Http handler not found for " + req.getRequestURI());
            }
            return null;
        }
        if (bestConfig.getInstance() == null) {
            HttpProtocolHandlerFactory fac = (HttpProtocolHandlerFactory)bestConfig.getFactoryInstance();
            bestConfig.setInstance(fac.createHandler(bestConfig));
        }
        HttpProtocolHandler bestHandler = (HttpProtocolHandler)bestConfig.getInstance();
        if (this.DEBUG) {
            this.debug(" FIND best handler for " + req.getRequestURI() + " configName: " + bestHandler.getConfigInfo().getName());
        }
        return bestHandler;
    }

    private HttpProtocolHandlerFactory getNextHttpFactory(HttpXProtocolHandlerFactory fac) {
        for (HttpXProtocolHandlerFactory next = fac; next != null; next = next.getNext()) {
            if (!(next instanceof HttpProtocolHandlerFactory)) continue;
            return (HttpProtocolHandlerFactory)next;
        }
        return null;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public abstract HttpProtocolHandler createHandler(HttpConfigInfo var1);
}

