/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.HttpOutboundHandler;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.IRoutingConfigListener;
import progress.message.broker.PublishLimiterNotify;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RouterManager;
import progress.message.msg.IMgram;
import progress.message.util.PriorityQueue;

public class HttpRemoteBroker
implements IRemoteBroker,
IRoutingConfigListener {
    private static boolean DEBUG = false;
    private static int MAX_HTTPQ_SIZE = 75000;
    public static final String GROUP_ID_PQ_STRING = "$group$";
    public static final String URL_PQ_STRING = "$url$";
    public static final String HTTP_PROT_START = "http://";
    public static final String HTTPS_PROT_START = "https://";
    public static final String DEFAULT_HTTP_PORT = ":80";
    public static final String DEFAULT_HTTPS_PORT = ":443";
    private static long IDLE_TIMEOUT = 300000L;
    private PriorityQueue m_httpQ = null;
    private int m_httpQSize = 0;
    private int m_httpQCount = 0;
    private volatile boolean m_isOkToSend = true;
    private Thread m_dispatchThread = null;
    private boolean m_hasGroupID = false;
    private boolean m_hasDestURL = false;
    private boolean m_groupByURL = true;
    private Object m_notifyTarget = null;
    private RoutingConnectionInfo m_connectInfo = null;
    private int m_routingConfigIndex = -1;
    private String m_directUrl = null;
    private String m_userid = null;
    private String m_password = null;
    private String m_node = null;
    private String m_brokerName = null;
    private String m_pendingQueueName = null;
    private long m_lastActive = 0L;
    private volatile boolean m_pendingQueueExists = false;
    private boolean m_waitForNextMessageIfEmpty = false;
    private HttpOutboundHandler m_handler;

    static void debugSetIdleTimeout(long timeout) {
        IDLE_TIMEOUT = timeout;
    }

    public void setPendingQueueExists(boolean flag) {
        this.m_pendingQueueExists = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWaitForNextMessageIfEmpty(boolean waitForNextMessageIfEmpty) {
        boolean cancelDequeueWait = false;
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            if (!waitForNextMessageIfEmpty && this.m_waitForNextMessageIfEmpty) {
                cancelDequeueWait = true;
            }
            this.m_waitForNextMessageIfEmpty = waitForNextMessageIfEmpty;
            if (cancelDequeueWait && this.isDispatching()) {
                this.m_httpQ.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDispatching() {
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            return this.m_dispatchThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDispatchThread(Thread dispatchThread, boolean waitForNextMessageIfEmpty) {
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            this.m_dispatchThread = dispatchThread;
            this.m_waitForNextMessageIfEmpty = waitForNextMessageIfEmpty;
        }
    }

    Thread getDispatchThread() {
        return this.m_dispatchThread;
    }

    public boolean isLowPriorityDestination() {
        return !this.m_hasGroupID && this.m_hasDestURL && this.m_groupByURL;
    }

    public HttpOutboundHandler getHandler() {
        return this.m_handler;
    }

    private static String getMainPartOfURL(String url) {
        String result = url;
        boolean https = false;
        result = result.replace('\\', '/');
        if ((result = result.toLowerCase()).startsWith(HTTPS_PROT_START)) {
            https = true;
        } else if (!result.startsWith(HTTP_PROT_START)) {
            return null;
        }
        int indx = 0;
        indx = https ? HTTPS_PROT_START.length() : HTTP_PROT_START.length();
        indx = result.indexOf(47, indx);
        if (indx > -1) {
            result = result.substring(0, indx);
        }
        if ((indx = (result = https ? HttpRemoteBroker.removePort(result, DEFAULT_HTTPS_PORT) : HttpRemoteBroker.removePort(result, DEFAULT_HTTP_PORT)).lastIndexOf(46)) > -1) {
            indx = result.lastIndexOf(46, indx - 1);
        }
        if (indx > -1) {
            result = https ? "https://*" + result.substring(indx) : "http://*" + result.substring(indx);
        }
        return result;
    }

    private static String removePort(String resultParam, String defaultPort) {
        String result = resultParam;
        if (result.endsWith(defaultPort)) {
            result = result.substring(0, result.length() - defaultPort.length());
        }
        return result;
    }

    public static String getHTTPDirectPendingQueueName(String nodeName, String groupIDParam, String destURLParam, boolean groupByURL) {
        String destURL = destURLParam;
        String groupID = groupIDParam;
        String mainPartOfURL = null;
        if (groupID != null) {
            groupID = groupID.trim();
        }
        if (destURL != null) {
            destURL = destURL.trim();
        }
        if (groupID != null && groupID.length() > 0) {
            return nodeName.concat(GROUP_ID_PQ_STRING).concat(groupID);
        }
        if (groupByURL && destURL != null && destURL.length() > 0) {
            mainPartOfURL = HttpRemoteBroker.getMainPartOfURL(destURL);
            if (mainPartOfURL == null) {
                return nodeName;
            }
            return nodeName.concat(URL_PQ_STRING).concat(mainPartOfURL);
        }
        return nodeName;
    }

    public HttpRemoteBroker(RouterManager rtmgr, RoutingConnectionInfo connectInfo, String pendingQueueName, HttpOutboundHandler handler) {
        this.m_handler = handler;
        this.m_connectInfo = connectInfo;
        if (this.m_connectInfo != null) {
            this.m_groupByURL = this.m_connectInfo.groupMessagesByUrl();
            this.m_brokerName = this.m_node = this.m_connectInfo.getRoutingNodeName();
            this.m_userid = this.m_connectInfo.getUserName();
            this.m_password = this.m_connectInfo.getPassword();
        }
        this.m_pendingQueueName = pendingQueueName;
        if (this.m_pendingQueueName.indexOf(GROUP_ID_PQ_STRING) != -1) {
            this.m_hasGroupID = true;
        }
        if (this.m_pendingQueueName.indexOf(URL_PQ_STRING) != -1) {
            this.m_hasDestURL = true;
        }
        this.m_httpQ = new PriorityQueue(13);
        this.m_lastActive = System.currentTimeMillis();
        AgentRegistrarHolder.AGENT_REGISTRAR.getRoutingConfig().addRoutingConfigListener(this);
    }

    public void disconnect(int reason) {
        AgentRegistrarHolder.AGENT_REGISTRAR.getRoutingConfig().removeRoutingConfigListener(this);
    }

    @Override
    public void sendThrough(IMgram m) {
        this.send(m);
    }

    @Override
    public boolean send(IMgram m) {
        try {
            this.enqueue(m, m.getPriority());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String getUserID() {
        return this.m_userid;
    }

    @Override
    public String getNodeName() {
        return this.m_node;
    }

    @Override
    public String getPendingQueueName() {
        return this.m_pendingQueueName;
    }

    public RoutingConnectionInfo getConnectInfo() {
        return this.m_connectInfo;
    }

    @Override
    public String getBrokerName() {
        return this.m_brokerName;
    }

    @Override
    public String getConnectURL() {
        return this.m_directUrl;
    }

    @Override
    public boolean isOkToDispatch(IMinEnqueuePriorityListener iMinEnqPrioListener) {
        return false;
    }

    @Override
    public boolean isOkToSend(PublishLimiterNotify notifyLimiter) {
        this.m_notifyTarget = notifyLimiter.getNotifyTarget();
        return this.m_isOkToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            return this.m_httpQ.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOkToRemove() {
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            long now = System.currentTimeMillis();
            if (this.m_notifyTarget == null) {
                return false;
            }
            Object object = this.m_notifyTarget;
            synchronized (object) {
                return this.m_httpQ.isEmpty() && !this.m_pendingQueueExists && now - this.m_lastActive >= IDLE_TIMEOUT;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(IMgram m, int prio) {
        boolean needDispatch = false;
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            if (this.m_httpQ.isEmpty() && this.m_dispatchThread == null) {
                needDispatch = true;
            }
            this.m_httpQ.enqueue(m, prio);
            this.m_httpQSize += m.memoryLength();
            ++this.m_httpQCount;
            this.m_lastActive = System.currentTimeMillis();
            if (this.m_httpQSize >= MAX_HTTPQ_SIZE) {
                this.m_isOkToSend = false;
            }
        }
        if (needDispatch) {
            AgentRegistrarHolder.AGENT_REGISTRAR.getQueueProc().getRemoteBrokerHelper().getHttpDispatchThreadPool().needDispatch(this.isLowPriorityDestination());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMgram dequeueAndNotify() throws InterruptedException {
        IMgram mgram = null;
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            while (this.m_waitForNextMessageIfEmpty && this.m_httpQ.isEmpty()) {
                this.m_httpQ.wait();
            }
            mgram = (IMgram)this.m_httpQ.dequeue();
            if (mgram == null) {
                return null;
            }
            this.m_httpQSize -= mgram.memoryLength();
            --this.m_httpQCount;
            if (this.m_httpQSize >= MAX_HTTPQ_SIZE) {
                return mgram;
            }
            if (!this.m_isOkToSend) {
                this.m_isOkToSend = true;
                if (this.m_notifyTarget != null) {
                    Object object = this.m_notifyTarget;
                    synchronized (object) {
                        this.m_notifyTarget.notifyAll();
                    }
                } else if (DEBUG) {
                    System.out.println("  no target to notify");
                }
            }
        }
        return mgram;
    }

    @Override
    public void IRoutingConfigChanged(RoutingConnectionInfo newRouting, RoutingConnectionInfo oldRouting) {
        if (newRouting == null) {
            return;
        }
        String nodeName = newRouting.getRoutingNodeName();
        if (nodeName != null && nodeName.equals(this.m_node)) {
            this.m_handler.updateRoutingConfig(newRouting, oldRouting);
        }
    }

    @Override
    public void setRoutingConfigIndex(int index) {
        this.m_routingConfigIndex = index;
    }

    @Override
    public int getRoutingConfigIndex() {
        return this.m_routingConfigIndex;
    }

    public String toString() {
        return "HttpRemoteBroker(URL:" + this.m_directUrl + ")";
    }

    @Override
    public long getClientID() {
        return -1L;
    }

    @Override
    public int getMinSendPriority(PublishLimiterNotify notifyLimiter) {
        return 0;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isConnecting() {
        return false;
    }

    public boolean isRegistered() {
        return true;
    }

    public synchronized boolean hasConnectionTimedOut() {
        return false;
    }

    @Override
    public boolean isNeighbor() {
        return false;
    }

    @Override
    public boolean isHttp() {
        return true;
    }

    @Override
    public boolean hasInDoubtState() {
        return false;
    }

    @Override
    public int getInDoubtQMsgsCount() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPendingQMsgsCount() {
        PriorityQueue priorityQueue = this.m_httpQ;
        synchronized (priorityQueue) {
            return this.m_httpQCount;
        }
    }

    @Override
    public long getInDoubtTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void setInDoubtTime(long time) {
    }

    @Override
    public void expireInDoubt() {
    }

    @Override
    public void expireSent() throws InterruptedException {
    }

    private static class AgentRegistrarHolder {
        private static final AgentRegistrar AGENT_REGISTRAR = AgentRegistrar.getAgentRegistrar();

        private AgentRegistrarHolder() {
        }
    }
}

