/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IAgentQueue;
import progress.message.msg.IMgram;
import progress.message.util.IndexedList;

public final class QueueMessageRestorer {
    private RestorationThread m_restorationThread;
    private BlockingPool m_restorationQueue = new BlockingPool();

    public QueueMessageRestorer() {
        this.m_restorationThread = new RestorationThread();
    }

    public void restore(IMgram mgram, String dest) {
        RestoreInfo info = new RestoreInfo(mgram, dest);
        this.m_restorationQueue.addPoolElement(info);
    }

    public void shutdown() {
        Thread t;
        if (this.m_restorationThread != null && (t = this.m_restorationThread.getThread()) != null) {
            t.interrupt();
        }
    }

    public class BlockingPool {
        private int m_numElements = 0;
        private PoolElement m_head = null;
        private PoolElement m_tail = null;

        public synchronized void addPoolElement(Object o) {
            PoolElement qElem = new PoolElement(o);
            if (this.m_head == null) {
                this.m_head = this.m_tail = qElem;
            } else {
                this.m_tail.next = qElem;
            }
            this.m_tail = qElem;
            ++this.m_numElements;
            this.notifyAll();
        }

        public synchronized Object nextElement() throws InterruptedException {
            while (!this.hasMoreElements()) {
                this.wait();
            }
            return this.configMHead();
        }

        public synchronized Object nextElement(long timeout) throws InterruptedException {
            long starttime;
            long endtime = starttime = System.currentTimeMillis();
            long timediff = 0L;
            while (!this.hasMoreElements() && timediff < timeout) {
                this.wait(timeout);
                timediff = System.currentTimeMillis() - starttime;
            }
            if (timediff >= timeout) {
                return null;
            }
            return this.configMHead();
        }

        private Object configMHead() {
            Object o = this.m_head.element;
            if (this.m_head.next != null) {
                this.m_head = this.m_head.next;
            } else {
                this.m_tail = null;
                this.m_head = null;
            }
            --this.m_numElements;
            return o;
        }

        public boolean hasMoreElements() {
            return this.m_numElements > 0;
        }

        public int length() {
            return this.m_numElements;
        }

        public void empty() {
            this.m_tail = null;
            this.m_head = null;
        }

        public class PoolElement {
            Object element = null;
            PoolElement next = null;

            public PoolElement(Object o) {
                this.element = o;
            }
        }
    }

    public class RestoreInfo {
        private IMgram mgram;
        private String dest;

        public RestoreInfo(IMgram mgram, String dest) {
            this.mgram = mgram;
            this.dest = dest;
        }

        public IMgram getMgram() {
            return this.mgram;
        }

        public String getDestination() {
            return this.dest;
        }
    }

    public class RestorationThread
    implements Runnable {
        private Thread myThread;
        private AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();

        public RestorationThread() {
            this.myThread = new Thread(this);
            this.myThread.setDaemon(true);
            this.myThread.start();
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    RestoreInfo info = (RestoreInfo)QueueMessageRestorer.this.m_restorationQueue.nextElement();
                    IMgram mgram = info.getMgram();
                    String dest = info.getDestination();
                    IAgentQueue q = this.aqp.getAgentQueue(dest);
                    if (q == null) continue;
                    IndexedList<IMgram> l = new IndexedList<IMgram>();
                    l.appendNoDup(mgram.getGuarenteedTrackingNum(), mgram);
                    q.restore(l, true, true);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }

        Thread getThread() {
            return this.myThread;
        }
    }
}

