/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpConstants;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;

public class SonicSoapVerifier {
    SOAPMessage m_soapMessage = null;
    SOAPConstants m_soapConstanst = null;
    String m_versionString = "";

    public SonicSoapVerifier(InputStream is, String contentType) throws Exception {
        try {
            MimeHeaders headers = new MimeHeaders();
            headers.setHeader("Content-Type", contentType);
            SOAPMessage sm = MessageFactory.newInstance().createMessage(headers, is);
            SOAPEnvelope soapEnvelope = (SOAPEnvelope)sm.getSOAPPart().getEnvelope();
            this.m_soapMessage = sm;
            this.m_soapConstanst = soapEnvelope.getSOAPConstants();
            this.m_versionString = this.m_soapConstanst instanceof SOAP12Constants ? "SOAP 1.2" : "SOAP 1.1";
            HttpConstants.DEBUG("InputStream contains valid SOAP, version = " + this.m_versionString, 0);
        }
        catch (Exception e) {
            String errMessage = this.processsErrMsg(e.getMessage());
            HttpConstants.DEBUG("InputStream contains invalid SOAP, reason: " + errMessage, 0);
            throw new Exception(errMessage);
        }
    }

    public final int getSoapMessageLength() {
        Message axisMsg = (Message)this.m_soapMessage;
        try {
            long msgLength = axisMsg.getContentLength();
            return (int)msgLength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public SOAPMessage getSoapMessage() {
        return this.m_soapMessage;
    }

    public String getSoapVersionString() {
        return this.m_versionString;
    }

    public SOAPConstants getSoapConstants() {
        return this.m_soapConstanst;
    }

    private String processsErrMsg(String errMsg) {
        String hostString = "UnknownHostException:";
        int index = errMsg.indexOf(hostString);
        if (index < 0) {
            return errMsg;
        }
        return errMsg.substring(0, index + hostString.length() - 1);
    }
}

