/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.DestinationLookupException;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.WSDLLookupException;
import com.sonicsw.net.http.direct.DirectHttpInConfig;
import com.sonicsw.net.http.soap.SoapHttpProtocolHandler;
import com.sonicsw.net.http.ws.SOAPUtils;
import com.sonicsw.net.http.ws.WSDLCache;
import com.sonicsw.net.http.ws.WSDLHelper;
import com.sonicsw.net.http.ws.WSHttpConfigInfo;
import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpInResponse;
import com.sonicsw.net.http.ws.prAccessor;
import com.sonicsw.ws.addressing.AddressingUtils;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.axis.handlers.WSBufferedMessageDeliveryService;
import com.sonicsw.ws.axis.handlers.WSService;
import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.ws.rm.common.CreateOperationContext;
import com.sonicsw.ws.rm.common.RMUtils;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.util.WSAClusteringHelper;
import com.sonicsw.wsdl.WSDLContext;
import com.sonicsw.wsp.OperationContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.server.AxisServer;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;
import org.w3c.dom.NodeList;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.msg.IMgram;
import progress.message.net.https.server.SonicHttpsConnection;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.zclient.Message;

public class WSHttpProtocolHandler
extends SoapHttpProtocolHandler {
    private String CAUGHTFAULT_PROPERTY = "org.apache.axis.SimpleChain.caughtFaultInResponse";
    private WSHttpConfigInfo m_configInfo = null;
    private WSService m_wsService = null;
    private WSBufferedMessageDeliveryService m_wsBufferedMessageDeliveryService = null;
    private AxisServer m_bufferedMessageEngine = null;
    private AxisServer m_engine = null;
    private WSAClusteringHelper m_wsaClusteringHelper = null;
    public static long BROKER_ID = AddrUtil.stringToClientId(Config.BROKER_NAME, "Broker");

    public WSHttpProtocolHandler(HttpConfigInfo config) {
        super(config);
        this.config = new DirectHttpInConfig(config);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("WSHttpProtocolHandler " + config.toString());
        }
        this.m_configInfo = (WSHttpConfigInfo)config;
        this.m_wsService = new WSService((Handler)new HttpInBrokerHandler());
        this.m_wsBufferedMessageDeliveryService = new WSBufferedMessageDeliveryService((Handler)new HttpInBrokerHandler(true));
        this.m_engine = this.createAxisServer();
        this.m_wsService.setEngine((AxisEngine)this.m_engine);
        this.m_bufferedMessageEngine = this.createAxisServer();
        this.m_wsBufferedMessageDeliveryService.setEngine((AxisEngine)this.m_bufferedMessageEngine);
        this.m_wsaClusteringHelper = WSAClusteringHelper.getWSAClusteringHelper();
    }

    @Override
    public HttpInRequest getInRequest(HttpServletRequest req) {
        return new WSHttpInRequest(req);
    }

    @Override
    public HttpInResponse getInResponse(HttpServletResponse res) {
        return new WSHttpInResponse(res);
    }

    @Override
    protected final AxisServer createAxisServer() {
        SimpleProvider axiscfg = new SimpleProvider();
        return new AxisServer((EngineConfiguration)axiscfg);
    }

    public MessageContext establishContext() throws AxisFault {
        MessageContext mctx = new MessageContext((AxisEngine)this.createAxisServer());
        mctx.setService((SOAPService)this.m_wsService);
        return mctx;
    }

    protected MessageContext createAxisMessageContext(AxisServer engine, HttpClientContext hctx, WSHttpInRequest request) throws AxisFault {
        MessageContext mctx = new MessageContext((AxisEngine)engine);
        mctx.setProperty("enableNamespacePrefixOptimization", (Object)new Boolean(false));
        String soapActionURI = request.getRequest().getHeader("SOAPAction");
        mctx.setSOAPActionURI(soapActionURI);
        mctx.setProperty("com.sonicsw.net.http.ws.WSHttpProtocolHandler", (Object)this);
        mctx.setProperty("com.sonicsw.net.http.HttpClientContext", (Object)hctx);
        mctx.setProperty("com.sonicsw.net.http.HttpInRequest", (Object)request);
        mctx.setService((SOAPService)this.m_wsService);
        SOAPMessage soapMessage = request.getSoapMessage();
        mctx.setRequestMessage((org.apache.axis.Message)soapMessage);
        if (HttpHelper.ENABLE_TRANSPORTBINDING_SUITE_CHECKING) {
            String cipherSuite = null;
            try {
                SonicHttpsConnection sonicHttpsConnection = HttpHelper.castToSonicHttpsConnection(request.getRequest());
                cipherSuite = sonicHttpsConnection.getCipherSuite();
            }
            catch (Exception e) {
                return null;
            }
            if (cipherSuite != null) {
                mctx.setProperty("X-HTTPS-WS-BindingCipherSuite", (Object)cipherSuite);
            }
        }
        return mctx;
    }

    protected MessageContext createAxisBufferedMessageContext(MessageContext orig) throws AxisFault {
        MessageContext mctx = new MessageContext((AxisEngine)this.m_bufferedMessageEngine);
        mctx.setSOAPActionURI(orig.getSOAPActionURI());
        mctx.setSOAPConstants(orig.getSOAPConstants());
        if (orig.getAllPropertyNames() != null) {
            Iterator ite = orig.getAllPropertyNames();
            while (ite.hasNext()) {
                String str = (String)ite.next();
                mctx.setProperty(str, orig.getProperty(str));
            }
        }
        mctx.removeProperty("COM_SONIC_RM_REMOVE_MESSAGE");
        mctx.removeProperty("com.sonicsw.net.http.HttpRequestContext");
        mctx.setService((SOAPService)this.m_wsBufferedMessageDeliveryService);
        mctx.setRequestMessage(orig.getRequestMessage());
        return mctx;
    }

    public void serviceGet(HttpInRequest req, HttpInResponse resp, HttpClientContext httpContext) {
        String requestPath = req.getRequest().getRequestURI();
        if (this.DEBUG) {
            this.debug("serviceGet() " + requestPath);
        }
        WSHttpInRequest wsreq = (WSHttpInRequest)req;
        WSHttpInResponse wsresp = (WSHttpInResponse)resp;
        if (!wsreq.isWSDLQuery()) {
            if (this.DEBUG) {
                this.debug("GET is not WSDL query, not supported");
            }
            try {
                resp.createResponse(501);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            String wsdlURL = wsreq.getWSDLLocation(this.config, requestPath);
            InputStream wsdlis = wsreq.getWSDLInputStream(wsdlURL);
            WSDLHelper wsdlHelper = new WSDLHelper(wsdlis);
            wsdlHelper.rewriteSoapAddressUrls(requestPath, req.getRequest().getRequestURL().toString(), this.m_configInfo);
            ByteArrayOutputStream wsdlOS = new ByteArrayOutputStream();
            wsdlHelper.writeWSDL(wsdlOS);
            wsresp.createByteArrayContentResponse(wsdlOS.toByteArray(), "text/xml");
        }
        catch (MalformedURLException e) {
            if (this.DEBUG) {
                this.debug("MalformedURLException: " + e.getMessage());
            }
            String emsg = prMessageFormat.format(prAccessor.getString("CONFIGURED_URL_INVALID"), new Object[]{e.getMessage()});
            resp.create404FileNotFoundResponse(emsg);
            return;
        }
        catch (MFRuntimeException e) {
            if (this.DEBUG) {
                this.debug("MFRuntimeException: " + e.getMessage(), e);
            }
            wsresp.create404FileNotFoundResponse(e.getMessage());
        }
        catch (WSDLLookupException e) {
            if (this.DEBUG) {
                this.debug("WSDLLookupException: " + e.getMessage(), e);
            }
            wsresp.create404FileNotFoundResponse(e.getMessage());
        }
        catch (Exception e) {
            if (this.DEBUG) {
                this.debug("Exception: " + e.getMessage(), e);
            }
            wsresp.createResponse(e);
            return;
        }
    }

    public void servicePost(HttpInRequest req, HttpInResponse resp, HttpClientContext httpContext) {
        String requestPath = req.getRequest().getRequestURI();
        if (this.DEBUG) {
            this.debug("servicePost() " + requestPath);
        }
        WSHttpInRequest wsreq = (WSHttpInRequest)req;
        WSHttpInResponse wsresp = (WSHttpInResponse)resp;
        try {
            wsreq.setXHTTPMappedURL(this.config, req.getRequest());
            this.setTrustStore(wsreq);
            this.setServiceIdentity(wsreq);
            this.setSoapActor(wsreq);
            WSDLContext wctx = null;
            wctx = this.getWSDLContext(wsreq, requestPath);
            this.dispatch(req, resp, httpContext, wctx);
        }
        catch (Exception e) {
            wsresp.createResponse(e);
        }
    }

    private boolean nonWSDLOperation(WSHttpInRequest wsreq) throws Exception {
        String action = wsreq.getRequest().getHeader("SOAPAction");
        if (action != null && action.length() > 0 && !action.equalsIgnoreCase("\"\"")) {
            return RMUtils.isRMAction(action) || AddressingUtils.isFaultURI(action);
        }
        return this.hasRMOperation(wsreq);
    }

    private boolean hasRMOperation(WSHttpInRequest wsreq) throws Exception {
        SOAPMessage soapmsg = WSHttpProtocolHandler.retrieveSoapMessage(wsreq);
        SOAPPart part = soapmsg.getSOAPPart();
        if (this.existsTag("http://schemas.xmlsoap.org/ws/2005/02/rm", "CreateSequence", part) || this.existsTag("http://schemas.xmlsoap.org/ws/2004/03/rm", "CreateSequence", part) || this.existsTag("http://schemas.xmlsoap.org/ws/2005/02/rm", "TerminateSequence", part) || this.existsTag("http://schemas.xmlsoap.org/ws/2004/03/rm", "TerminateSequence", part) || this.existsTag("http://schemas.xmlsoap.org/ws/2005/02/rm", "CreateSequenceResponse", part) || this.existsTag("http://schemas.xmlsoap.org/ws/2004/03/rm", "CreateSequenceResponse", part)) {
            return true;
        }
        AddressingHeaders ah = new AddressingHeaders(part.getEnvelope());
        Action action = ah.getAction();
        return action != null && (RMUtils.isRMAction(action.toString()) || AddressingUtils.isFaultURI(action.toString()));
    }

    private boolean existsTag(String ns, String tag, SOAPPart part) {
        NodeList list = part.getElementsByTagNameNS(ns, tag);
        return list != null && list.getLength() > 0;
    }

    private String getNodeValue(String ns, String tag, SOAPPart part) {
        NodeList list = part.getElementsByTagNameNS(ns, tag);
        if (list == null || list.getLength() <= 0) {
            return null;
        }
        return list.item(0).getNodeValue();
    }

    private WSDLContext getWSDLContext(WSHttpInRequest wsreq, String requestPath) throws MalformedURLException, IOException, Exception {
        if (this.nonWSDLOperation(wsreq) || AddressBinder.isInternallyGeneratedWSAAddress(requestPath)) {
            return null;
        }
        String wsdlURL = wsreq.getWSDLLocation(this.config, requestPath);
        if (wsdlURL == null) {
            String emsg = prMessageFormat.format(prAccessor.getString("WS_INBOUND_NO_WSDL"), new Object[]{requestPath});
            throw new IOException(emsg);
        }
        WSDLContext ctx = null;
        AgentRegistrar.getAgentRegistrar();
        WSDLCache wsdlCache = AgentRegistrar.getWSDLCache();
        if (wsdlCache != null) {
            ctx = wsdlCache.getWSDL(wsdlURL, requestPath);
        }
        if (ctx == null) {
            InputStream wsdlis = wsreq.getWSDLInputStream(wsdlURL);
            WSDLHelper wsdlHelper = new WSDLHelper(wsdlis);
            wsdlHelper.rewriteSoapAddressUrls(requestPath, wsreq.getRequest().getRequestURL().toString(), this.m_configInfo);
            ByteArrayOutputStream wsdlOS = new ByteArrayOutputStream();
            wsdlHelper.writeWSDL(wsdlOS);
            ctx = new WSDLContext(wsdlURL, wsdlHelper.getDefinition(), wsdlOS.toByteArray());
            if (wsdlCache != null) {
                wsdlCache.addWSDL(wsdlURL, requestPath, ctx);
            }
        }
        return ctx;
    }

    private boolean dispatchWSA(WSHttpInRequest wsreq, WSHttpInResponse wsresp, HttpClientContext httpContext) {
        String fullRequestURL = wsreq.getRequest().getRequestURI();
        try {
            if (!AddressBinder.isInternallyGeneratedWSAAddress(fullRequestURL)) {
                return false;
            }
            Destination dest = AddressBinder.getWSADestination(fullRequestURL);
            SOAPMessage soapmsg = WSHttpProtocolHandler.retrieveSoapMessage(wsreq);
            MessageContext mctx = this.createAxisMessageContext(this.m_engine, httpContext, wsreq);
            if (dest != null) {
                mctx.setProperty("DEST", (Object)dest);
            }
            this.sendToSOAPStack(mctx, httpContext);
            if (mctx.getResponseMessage() != null) {
                if (mctx.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") == null && mctx.isPropertyTrue(this.CAUGHTFAULT_PROPERTY)) {
                    wsresp.create500InternalErrorResponse(null);
                } else {
                    this.populateSoapAction(mctx, wsresp);
                }
                this.writeResponseMessage(wsresp, mctx);
            } else {
                wsresp.setCode(202);
            }
        }
        catch (MessageHandlingException e) {
            wsresp.createResponse(e);
        }
        catch (SOAPException e) {
            wsresp.createResponse(e);
        }
        catch (AxisFault e) {
            wsresp.createResponse(e);
        }
        catch (IOException e) {
            wsresp.createResponse(e);
        }
        return true;
    }

    public static Hashtable getJMSPropertySetFromHTTPFields(HttpServletRequest req) {
        Hashtable<String, String> set = new Hashtable<String, String>();
        Enumeration enumeration = req.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String value;
            String key = (String)enumeration.nextElement();
            if (key == null || HttpHelper.isIgnoredHTTPProperty(key) || (value = req.getHeader(key)) == null) continue;
            set.put(key, value);
        }
        return set;
    }

    public static void writePropertySetToStream(Hashtable ht, Message m) throws IOException {
        m.writeInt(ht.size());
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            m.writeUTF(key);
            m.writeUTF((String)ht.get(key));
        }
    }

    public static Hashtable readPropertySetFromStream(Message m) throws IOException {
        int sz = m.readInt();
        Hashtable<String, String> ht = new Hashtable<String, String>(sz);
        for (int i = 0; i < sz; ++i) {
            ht.put(m.readUTF(), m.readUTF());
        }
        return ht;
    }

    private boolean forwardWSA(WSHttpInRequest wsreq, WSHttpInResponse wsresp, HttpClientContext hctx) {
        String fullRequestURL = wsreq.getRequest().getRequestURI();
        if (!AddressBinder.isInternallyGeneratedWSAAddress(fullRequestURL)) {
            return false;
        }
        long node = AddressBinder.getWSABrokerId(fullRequestURL);
        if (node == BROKER_ID || this.m_wsaClusteringHelper == null) {
            return false;
        }
        if (!this.m_wsaClusteringHelper.isNeighbor(node)) {
            return false;
        }
        try {
            Message m = new Message();
            m.writeShort(0);
            String s = null;
            m.writeUTF(Config.BROKER_NAME);
            HttpServletRequest hr = wsreq.getRequest();
            m.writeUTF(hr.getRequestURL().toString());
            m.writeUTF(hr.getRequestURI());
            m.writeInt(hr.getContentLength());
            s = hr.getCharacterEncoding();
            m.writeUTF(s != null ? s : "");
            s = hr.getContentType();
            m.writeUTF(s != null ? s : "");
            s = hr.getMethod();
            m.writeUTF(s != null ? s : "");
            s = hr.getHeader("SOAPAction");
            m.writeUTF(s != null ? s : "");
            WSHttpProtocolHandler.writePropertySetToStream(WSHttpProtocolHandler.getJMSPropertySetFromHTTPFields(hr), m);
            hctx.getCSC().writeToStream(m, (short)-1);
            SOAPMessage soapmsg = WSHttpProtocolHandler.retrieveSoapMessage(wsreq);
            WSAClusteringHelper.soapToSonicMessage((org.apache.axis.Message)soapmsg, m);
            this.m_wsaClusteringHelper.forward(node, m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        wsresp.setCode(202);
        return true;
    }

    private void dispatch(HttpInRequest req, HttpInResponse resp, HttpClientContext httpContext, WSDLContext wctx) {
        WSHttpInRequest wsreq = (WSHttpInRequest)req;
        WSHttpInResponse wsresp = (WSHttpInResponse)resp;
        String requestPath = req.getRequest().getRequestURI();
        if (this.DEBUG) {
            this.debug("dispatch1() " + requestPath);
        }
        try {
            if (this.forwardWSA(wsreq, wsresp, httpContext)) {
                return;
            }
            if (this.dispatchWSA(wsreq, wsresp, httpContext)) {
                return;
            }
            SOAPMessage soapmsg = WSHttpProtocolHandler.retrieveSoapMessage(wsreq);
            MessageContext mctx = this.createAxisMessageContext(this.m_engine, httpContext, wsreq);
            mctx.setProperty("DEST", (Object)wsreq.getJMSDestination(this.config, requestPath));
            if (wctx != null) {
                mctx.setProperty("com.sonicsw.wsdl.WSDLContext", (Object)wctx);
            }
            HttpRequestContext reqContext = this.sendToSOAPStack(mctx, httpContext);
            if (mctx.getResponseMessage() != null) {
                if (mctx.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") == null && mctx.isPropertyTrue(this.CAUGHTFAULT_PROPERTY)) {
                    if (reqContext != null && reqContext.getHttpLock() != null && reqContext.getHttpLock().getErrorType() != 200) {
                        resp.setStatusWithReason(reqContext.getHttpLock().getErrorType(), reqContext.getHttpLock().getMessage());
                    } else {
                        resp.setStatusWithReason(500, prAccessor.getString("WS_INBOUND_INTERNAL_ERROR"));
                    }
                } else {
                    this.populateSoapAction(mctx, resp);
                }
                String cType = HttpHelper.resetCharset("text/xml", "utf-8");
                resp.setContentType(cType);
                this.writeResponseMessage(resp, mctx);
            } else {
                resp.setCode(202);
            }
        }
        catch (DestinationLookupException e) {
            BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, BrokerComponent.getLevelWarning().intValue());
            wsresp.createResponse(e);
        }
        catch (Throwable e) {
            BrokerComponent.getComponentContext().logMessage(e, BrokerComponent.getLevelWarning().intValue());
            wsresp.createResponse(e);
        }
    }

    private <T0 extends HttpInResponse> void populateSoapAction(MessageContext mctx, T0 resp) {
        String responseAction = (String)mctx.getProperty("addressing.responseAction");
        if (responseAction != null) {
            String httpSOAPActionHdr = WSHttpProtocolHandler.addResponseAction(responseAction);
            resp.setProperty("SOAPAction", httpSOAPActionHdr);
        }
    }

    private void writeResponseMessage(HttpInResponse resp, MessageContext mctx) throws IOException, SOAPException {
        OutputStream os = resp.getOutputStream();
        mctx.getResponseMessage().writeTo(os);
        os.flush();
    }

    private static SOAPMessage retrieveSoapMessage(WSHttpInRequest wsreq) throws MessageHandlingException {
        SOAPMessage soapmsg = wsreq.getSoapMessage();
        if (soapmsg == null) {
            soapmsg = wsreq.createSoapMessage();
        }
        return soapmsg;
    }

    private static String addResponseAction(String responseAction) {
        String httpSOAPActionHdr = responseAction;
        if (!responseAction.startsWith("\"")) {
            httpSOAPActionHdr = "\"" + responseAction + "\"";
        }
        return httpSOAPActionHdr;
    }

    @Override
    public void service(HttpInRequest req, HttpInResponse resp, HttpClientContext httpContext) throws IOException {
        WSHttpInRequest request = (WSHttpInRequest)req;
        WSHttpInResponse response = (WSHttpInResponse)resp;
        if (request.isGet()) {
            this.serviceGet(req, resp, httpContext);
        } else if (request.isPost()) {
            this.servicePost(req, resp, httpContext);
        } else {
            resp.create501NotSupportedResponse(null);
        }
    }

    public HttpRequestContext sendToSOAPStack(WSHttpInRequest request, HttpClientContext hctx) throws MessageHandlingException, AxisFault {
        MessageContext mctx = this.createAxisMessageContext(this.m_engine, hctx, request);
        return this.sendToSOAPStack(mctx, hctx);
    }

    public HttpRequestContext sendToSOAPStack(MessageContext mctx, HttpClientContext hctx) throws MessageHandlingException, AxisFault {
        try {
            this.m_engine.invoke(mctx);
        }
        catch (AxisFault af) {
            this.handleAxisFault(mctx, af);
        }
        HttpRequestContext reqContext = (HttpRequestContext)mctx.getProperty("com.sonicsw.net.http.HttpRequestContext");
        return reqContext;
    }

    public void sendBufferedMessageToSOAPStack(MessageContext mctx) throws MessageHandlingException, AxisFault {
        try {
            MessageContext mcp = this.createAxisBufferedMessageContext(mctx);
            this.m_bufferedMessageEngine.invoke(mcp);
            mctx.setProperty("com.sonicsw.net.http.HttpRequestContext", mcp.getProperty("com.sonicsw.net.http.HttpRequestContext"));
        }
        catch (AxisFault af) {
            this.handleAxisFault(mctx, af);
        }
    }

    private void handleAxisFault(MessageContext mctx, AxisFault af) throws AxisFault {
        if (mctx.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") == af) {
            DebugObjects.getHandlerDebug().debug("Fault Handled by Sonic");
        } else if (mctx.isPropertyTrue(this.CAUGHTFAULT_PROPERTY) && mctx.getResponseMessage() != null) {
            DebugObjects.getHandlerDebug().debug("Fault Handled and fault response set by Axis.");
        } else {
            throw af;
        }
    }

    public progress.message.jclient.Message createJmsMessage(MessageContext mctx) throws AxisFault, JMSException, MessageHandlingException, PropertyBadValueException, PropertyMissingException {
        WSHttpInRequest request = (WSHttpInRequest)mctx.getProperty("com.sonicsw.net.http.HttpInRequest");
        if (request.getMessage() != null) {
            return request.getMessage();
        }
        DirectHttpInConfig cloner = null;
        if (mctx.getProperty("DEST") != null) {
            cloner = this.config.clonedCopy();
            Object d = mctx.getProperty("DEST");
            Destination dest = (Destination)d;
            if (dest instanceof Queue) {
                cloner.destinationQueue = ((Queue)dest).getQueueName();
                cloner.destinationTopic = null;
            } else {
                cloner.destinationTopic = ((Topic)dest).getTopicName();
                cloner.destinationQueue = null;
            }
        }
        Object message = null;
        return request.createJMSMessage(cloner);
    }

    private void setTrustStore(WSHttpInRequest request) {
        request.setTrustStore(this.m_configInfo.getConfigEntry().getTrustStore(), this.m_configInfo.getConfigEntry().getCertificateToUsernameMapping());
    }

    private void setServiceIdentity(WSHttpInRequest request) {
        request.setServiceIdentity(this.m_configInfo.getConfigEntry().getX509Alias(), this.m_configInfo.getConfigEntry().getX509Password());
    }

    private void setSoapActor(WSHttpInRequest request) {
        request.setSoapActor(this.m_configInfo.getConfigEntry().getSOAPRoles());
    }

    private class HttpInBrokerHandler
    extends BasicHandler {
        private boolean m_bufferedDeliveryHandler = false;

        private HttpInBrokerHandler(boolean buffered) {
            this.m_bufferedDeliveryHandler = buffered;
        }

        private HttpInBrokerHandler() {
        }

        public void invoke(MessageContext mctx) throws AxisFault {
            WSHttpInRequest request = (WSHttpInRequest)mctx.getProperty("com.sonicsw.net.http.HttpInRequest");
            HttpClientContext hctx = (HttpClientContext)mctx.getProperty("com.sonicsw.net.http.HttpClientContext");
            String fullRequestURL = (String)mctx.getProperty("HTTP_IN_REQUEST_PATH");
            WSDLContext.RequestDispatchContext rctx = (WSDLContext.RequestDispatchContext)mctx.getProperty("com.sonicsw.wsdl.WSDLContext$DispatchContext");
            int style = 0;
            if (fullRequestURL == null && request != null) {
                fullRequestURL = request.getRequest().getRequestURI();
            }
            style = AddressBinder.isInternallyGeneratedWSAAddress(fullRequestURL) || rctx == null ? 1 : (rctx.hasResponse() ? 2 : 1);
            SequenceCapsule cap = (SequenceCapsule)mctx.getProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule");
            CreateOperationContext coc = (CreateOperationContext)mctx.getProperty("com.sonicsw.ws.rm.common.CreateOperationContext");
            Boolean anonymousReplyTo = (Boolean)mctx.getProperty("COM_SONIC_WS_ANONYMOUS_REPLYTO");
            Boolean removeMessage = (Boolean)mctx.getProperty("COM_SONIC_RM_REMOVE_MESSAGE");
            String mepCorrelator = (String)mctx.getProperty("COM_SONIC_WS_MESSAGEEXCHANGE_CORRELATOR");
            if (removeMessage != null && removeMessage.booleanValue()) {
                return;
            }
            if (RMUtils.hasConsumedRMRequestAction(mctx)) {
                return;
            }
            try {
                OperationContext oc;
                if (!HandlerUtils.hasSOAPEnvelope(mctx.getRequestMessage())) {
                    return;
                }
                progress.message.jclient.Message message = WSHttpProtocolHandler.this.createJmsMessage(mctx);
                if (cap != null) {
                    message.setStringProperty("JMSXGroupID", cap.getId());
                    message.setIntProperty("JMSXGroupSeq", cap.getNr().intValue());
                    message.setBooleanProperty("JMS_SonicMQ_lastMessageInGroup", cap.getLast().booleanValue());
                    if (cap.getReturnId() != null) {
                        message.setStringProperty("X-WS-ReturnGroupID", cap.getReturnId());
                    }
                    DebugObjects.getDeliveryDebug().debug("Delivering " + (this.m_bufferedDeliveryHandler ? "from re-order buffer " : "") + cap);
                } else if (coc != null && coc.getOfferContext() != null) {
                    message.setStringProperty("X-WS-ReturnGroupID", coc.getOfferContext().getId());
                }
                if (!message.propertyExists("X-HTTP-SOAPVersion")) {
                    String soapVersion = "SOAP 1.1";
                    SOAPConstants sc = mctx.getSOAPConstants();
                    if (sc != null && sc instanceof SOAP12Constants) {
                        soapVersion = "SOAP 1.2";
                    }
                    message.setStringProperty("X-HTTP-SOAPVersion", soapVersion);
                }
                if (mepCorrelator != null) {
                    message.setStringProperty("X-WS-MessageExchangeCorrelator", mepCorrelator);
                }
                if ((oc = (OperationContext)mctx.getProperty("COM_SONIC_WS_OPERATION_CONTEXT")) != null && oc.getJMSCorrelationID() != null) {
                    message.setJMSCorrelationID(oc.getJMSCorrelationID());
                }
                if (style == 2 && anonymousReplyTo != null && anonymousReplyTo.booleanValue()) {
                    WSHttpProtocolHandler.this.setRequestReplyTo(message, "SOAP", hctx);
                }
                HttpRequestContext reqContext = WSHttpProtocolHandler.this.sendMessageReusableLock(message, hctx, style);
                mctx.setProperty("com.sonicsw.net.http.HttpRequestContext", (Object)reqContext);
                HttpLock lock = reqContext.getHttpLock();
                if (lock.getContentReplyExpected() && reqContext.getMgram() != null) {
                    IMgram responseMgram = reqContext.getMgram();
                    mctx.setProperty("COM_SONIC_RESPONSEMGRAM", (Object)responseMgram);
                    mctx.setProperty("progress.message.msg.IMgram", null);
                    SOAPMessage soapResponse = SOAPUtils.createSOAPMessage(responseMgram);
                    mctx.setResponseMessage((org.apache.axis.Message)soapResponse);
                } else if ((lock.getErrorType() != 507 || cap == null) && lock.getErrorType() != 200 && lock.getErrorType() != 202) {
                    String emsg = prMessageFormat.format(prAccessor.getString("WS_INBOUND_UNDELIVERABLE_TO_JMS"), new Object[]{new Integer(lock.getErrorType()), lock.getMessage()});
                    throw new AxisFault(emsg);
                }
            }
            catch (PropertyBadValueException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (PropertyMissingException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (MessageHandlingException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (JMSException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
    }
}

