/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ws.WSHttpOutboundHandler;
import com.sonicsw.net.http.ws.prAccessor;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.wsp.OperationContext;
import com.sonicsw.wsp.OperationContextManager;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.To;
import org.apache.axis.types.URI;
import progress.message.broker.MgramURLHelper;
import progress.message.jclient.Queue;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;

public class AddressingFromJMSHandler
extends BasicHandler {
    public void invoke(MessageContext mc) throws AxisFault {
        WSHttpOutboundHandler handler;
        DebugObjects.getHandlerDebug().debug("AddressingFromJMSHandler:" + mc.hashCode());
        IMgram m = (IMgram)mc.getProperty("progress.message.msg.IMgram");
        Destination jmsReplyTo = null;
        boolean suppressWSA = false;
        Object suppressWSAO = m.getSidebandData().getProperty("X-WS-SuppressWSAHeaders");
        if (suppressWSAO != null) {
            if (suppressWSAO instanceof String) {
                String s = (String)suppressWSAO;
                try {
                    suppressWSA = Boolean.valueOf(s);
                }
                catch (Exception exception) {}
            } else if (suppressWSAO instanceof Boolean) {
                suppressWSA = (Boolean)suppressWSAO;
            }
        }
        if (suppressWSA) {
            String transportURL = this.evaluateTransportURL(mc);
            mc.setProperty("transport.url", (Object)transportURL);
            mc.setProperty("COM_SONIC_WSA_SUPRESS", (Object)"true");
            return;
        }
        String action = null;
        Object actionPropValue = m.getSidebandData().getProperty("SOAPAction");
        try {
            action = (String)actionPropValue;
        }
        catch (ClassCastException e) {
            BrokerComponent bc = BrokerComponent.getBrokerComponent();
            String messagePattern = prAccessor.getString("WS_OUTBOUND_PROPERTY_INVALID_TYPE");
            String message = prMessageFormat.format(messagePattern, new Object[]{"SOAPAction", String.class.getName(), actionPropValue.getClass().getName()});
            BrokerComponent.logMessage(message, new Integer(2));
        }
        if (m != null) {
            jmsReplyTo = AddressBinder.getReplyToDestination(m);
        }
        String acceptor = null;
        Object acceptorPropValue = m.getSidebandData().getProperty("X-WS-TransportAcceptor");
        try {
            acceptor = (String)acceptorPropValue;
        }
        catch (ClassCastException e) {
            BrokerComponent bc = BrokerComponent.getBrokerComponent();
            String messagePattern = prAccessor.getString("WS_OUTBOUND_PROPERTY_INVALID_TYPE");
            String message = prMessageFormat.format(messagePattern, new Object[]{"X-WS-TransportAcceptor", String.class.getName(), acceptorPropValue.getClass().getName()});
            BrokerComponent.logMessage(message, new Integer(2));
        }
        if ((acceptor == null || acceptor.trim().length() == 0) && (handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler")) != null) {
            acceptor = handler.getRoutingConnectionInfo().getRoutingAcceptor();
        }
        String transportURL = this.evaluateTransportURL(mc);
        AddressingHeaders headers = null;
        try {
            ArrayList refPropsQNames = new ArrayList(0);
            String actor = null;
            boolean process = false;
            boolean remove = true;
            boolean setmuc = true;
            boolean permitParseNonSpecificAction = true;
            headers = new AddressingHeaders((SOAPEnvelope)mc.getRequestMessage().getSOAPEnvelope(), actor, process, remove, setmuc, permitParseNonSpecificAction, refPropsQNames);
            if (headers.getAction() == null && action != null) {
                URI unspecified = new URI(null, action, true);
                headers.setAction(new Action(unspecified));
            }
            if (this.synchronousAction(headers.getAction())) {
                if (headers.getTo() == null) {
                    headers.setTo(new To(transportURL));
                }
                if (headers.getFrom() == null) {
                    headers.setFrom(AddressBinder.bindAnonymous());
                }
                if (headers.getReplyTo() == null) {
                    headers.setReplyTo(AddressBinder.bindAnonymous());
                }
            } else {
                OperationContext oc;
                String path;
                boolean soapAssignedReturnAddresses;
                if (headers.getTo() == null) {
                    headers.setTo(new To(transportURL));
                }
                EndpointReference soapFrom = headers.getFrom();
                EndpointReference soapFaultTo = headers.getFaultTo();
                EndpointReference soapReplyTo = headers.getReplyTo();
                boolean bl = soapAssignedReturnAddresses = soapFrom != null || soapFaultTo != null || soapReplyTo != null;
                if (soapAssignedReturnAddresses) {
                    this.filterReturnAddress(soapFrom, AddressBinder.bindFrom(acceptor, jmsReplyTo));
                    this.filterReturnAddress(soapFaultTo, AddressBinder.bindFaultsTo(acceptor, jmsReplyTo));
                    this.filterReturnAddress(soapReplyTo, AddressBinder.bindReplyTo(acceptor, jmsReplyTo));
                } else {
                    headers.setFrom(AddressBinder.bindAnonymous());
                    if (jmsReplyTo != null && !jmsReplyTo.equals("")) {
                        headers.setReplyTo(AddressBinder.bindReplyTo(acceptor, jmsReplyTo));
                        headers.setFaultTo(AddressBinder.bindFaultsTo(acceptor, jmsReplyTo));
                    }
                }
                Destination d = null;
                if (headers.getReplyTo() != null) {
                    path = headers.getReplyTo().getAddress().getPath();
                    if (path != null && AddressBinder.isInternallyGeneratedWSAReplyTo(path)) {
                        d = AddressBinder.getWSADestination(path);
                    }
                } else if (headers.getFrom() != null && AddressBinder.isInternallyGeneratedWSAFrom(path = headers.getFrom().getAddress().getPath())) {
                    d = AddressBinder.getWSADestination(path);
                }
                if (d != null && d instanceof Queue && (oc = this.getOperationContext(mc, m)) != null) {
                    String key = ((Queue)d).getName();
                    oc.setKey(key);
                    boolean log = true;
                    OperationContextManager.getOperationContextManager().addOperationContext(oc, log);
                }
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception e) {
            throw new AxisFault(e.toString(), (Throwable)e);
        }
        String corr = this.evaluateInitialMessageExchangeCorrelator(headers);
        if (corr != null) {
            mc.setProperty("COM_SONIC_WS_MESSAGEEXCHANGE_CORRELATOR", (Object)corr);
        }
        mc.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
        mc.setProperty("transport.url", (Object)transportURL);
        mc.setProperty("addressing.setMustUnderstand", (Object)Boolean.toString(false));
    }

    private OperationContext getOperationContext(MessageContext mc, IMgram m) {
        OperationContext oc = (OperationContext)mc.getProperty("COM_SONIC_WS_OPERATION_CONTEXT");
        String corrID = m.getSidebandData().getCorrelationID();
        if (corrID != null && corrID.length() > 0) {
            if (oc == null) {
                oc = new OperationContext();
            }
            oc.setJMSCorrelationID(corrID);
        }
        return oc;
    }

    private void filterReturnAddress(EndpointReference epr, EndpointReference replacement) {
        if (epr == null) {
            return;
        }
        if (epr.getAddress().toString().equalsIgnoreCase("urn:REQUEST_SYSTEM_ASSIGNED")) {
            epr.setAddress(replacement.getAddress());
        }
    }

    private boolean synchronousAction(Action action) {
        if (action == null) {
            return false;
        }
        String a = action.toString();
        return a.equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence") || a.equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/rm/TerminateSequence") || a.equalsIgnoreCase("\"http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence\"") || a.equalsIgnoreCase("\"http://schemas.xmlsoap.org/ws/2004/03/rm/TerminateSequence\"");
    }

    private String evaluateTransportURL(MessageContext mc) {
        WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
        IMgram m = (IMgram)mc.getProperty("progress.message.msg.IMgram");
        String messageURL = MgramURLHelper.getEffectiveURLDestination(m);
        if (messageURL == null || messageURL.equals("")) {
            messageURL = handler.getHttpRoutingInfo().getUrlString();
        }
        return messageURL;
    }

    public void onFault(MessageContext mc) {
        DebugObjects.getHandlerDebug().debug("AddressingFromJMSHandler:onFault:" + mc.hashCode());
    }

    private String evaluateInitialMessageExchangeCorrelator(AddressingHeaders ah) {
        if (ah != null) {
            if (ah.getRelatesTo() != null && ah.getRelatesTo().size() > 0) {
                return null;
            }
            MessageID mid = ah.getMessageID();
            if (mid == null) {
                return null;
            }
            return mid.toString();
        }
        return null;
    }
}

