/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.ws.axis.handlers.UniversalHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public class LogHandler
extends UniversalHandler {
    private String m_filename = null;
    private Object m_fLock = null;
    private static Hashtable m_fLocks = new Hashtable();

    public LogHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.m_filename == null) {
            this.setOptionDefault("filename", "axis.log");
            this.m_filename = (String)this.getOption("filename");
        }
        Hashtable hashtable = m_fLocks;
        synchronized (hashtable) {
            this.m_fLock = m_fLocks.get(this.m_filename);
            if (this.m_fLock == null) {
                if (new File(this.m_filename).exists()) {
                    new File(this.m_filename).delete();
                }
                this.m_fLock = new Object();
                m_fLocks.put(this.m_filename, this.m_fLock);
            }
        }
    }

    public LogHandler(String f) {
        this.m_filename = f;
    }

    @Override
    public void handleClientRequest(MessageContext mc) throws AxisFault {
        this.logMessage(mc.getRequestMessage(), this.fhdr(mc) + " REQ--->");
    }

    @Override
    public void handleClientResponse(MessageContext mc) throws AxisFault {
        this.logMessage(mc.getResponseMessage(), this.fhdr(mc) + " RSP<---");
    }

    @Override
    public void handleServerRequest(MessageContext mc) throws AxisFault {
        this.logMessage(mc.getRequestMessage(), this.fhdr(mc) + " REQ<---");
    }

    @Override
    public void handleServerResponse(MessageContext mc) throws AxisFault {
        this.logMessage(mc.getResponseMessage(), this.fhdr(mc) + " RSP--->");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logText(String txt) throws AxisFault {
        Object object = this.m_fLock;
        synchronized (object) {
            try {
                PrintWriter writer = null;
                writer = this.getWriter();
                if (txt != null) {
                    writer.println(txt);
                } else {
                    writer.println("null");
                }
                writer.close();
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
    }

    @Override
    public void onClientResponseFault(MessageContext mc) {
        this.debug("LogHandler:onClientResponseFault:" + mc.hashCode());
    }

    @Override
    public void onServerRequestFault(MessageContext mc) {
        this.debug("LogHandler:onServetRequestFault:" + mc.hashCode());
        this.handleServerRequestFault(mc);
    }

    @Override
    public void onClientRequestFault(MessageContext mc) {
        this.debug("LogHandler:onClientRequestFault:" + mc.hashCode());
        this.handleServerRequestFault(mc);
    }

    @Override
    public void onServerResponseFault(MessageContext mc) {
        this.debug("LogHandler:onServerResponseFault:" + mc.hashCode());
        this.handleServerRequestFault(mc);
    }

    private void handleServerRequestFault(MessageContext mc) {
        try {
            if (mc.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") != null && mc.getResponseMessage() != null) {
                this.logMessage(mc.getResponseMessage(), this.fhdr(mc) + " RSP--->");
            } else if (mc.getResponseMessage() != null) {
                this.logMessage(mc.getResponseMessage(), this.fhdr(mc) + " FAULT RSP--->");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessage(Message msg, String hdr) throws AxisFault {
        Object object = this.m_fLock;
        synchronized (object) {
            try {
                PrintWriter writer = null;
                writer = this.getWriter();
                writer.println(hdr);
                if (msg != null) {
                    writer.println(msg.getSOAPPartAsString());
                } else {
                    writer.println("null");
                }
                writer.close();
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
    }

    private PrintWriter getWriter() throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new FileWriter(this.m_filename, true), true);
        return writer;
    }

    protected String fhdr(MessageContext mc) {
        String u = (String)mc.getProperty("transport.url");
        return this.fdate() + " " + mc.hashCode() + (u != null ? " " + u : "");
    }

    protected String fdate() {
        Date dt = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss");
        String str = formatter.format(dt);
        return str;
    }
}

