/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.policy.WSRMPUtils;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.wsdl.WSDLContext;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicy2002Exception;
import com.sonicsw.wsp.WSPUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.ws.policy.Policy;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;
import org.xmlsoap.schemas.ws.x2005.x02.rm.policy.RMAssertionDocument;

public class PolicyFromWSDLHandler
extends BasicHandler {
    public void invoke(MessageContext mc) throws AxisFault {
        mc.setProperty("com.sonicsw.ws.axis.handlers.PolicyFromWSDLHandler", (Object)this);
    }

    public void getPolicy(MessageContext mc) throws AxisFault {
        block13: {
            DebugObjects.getHandlerDebug().debug("PolicyFromWSDLHandler:" + mc.hashCode());
            WSDLContext wctx = (WSDLContext)mc.getProperty("com.sonicsw.wsdl.WSDLContext");
            if (wctx == null) {
                return;
            }
            wctx.setOutMessagePolicyRequired(true);
            WSHttpInRequest wsreq = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
            SOAPMessage msg = wsreq.getSoapMessage();
            String wsaActionURI = null;
            String soapActionURI = null;
            try {
                AddressingHeaders ah = new AddressingHeaders(msg.getSOAPPart().getEnvelope());
                wsaActionURI = ah.getAction().toString();
            }
            catch (Exception e) {
                DebugObjects.getHandlerDebug().debug("PolicyFromWSDLHandler:" + e.getMessage());
            }
            soapActionURI = mc.getSOAPActionURI();
            String endpointURL = wsreq.getRequest().getRequestURL().toString();
            String soapEnvNSUri = mc.getSOAPConstants().getEnvelopeURI();
            try {
                WSDLContext.RequestDispatchContext rctx = wctx.getRequestDispatchContext(endpointURL, wsaActionURI, soapActionURI, (SOAPMessage)mc.getRequestMessage());
                mc.setProperty("com.sonicsw.wsdl.WSDLContext$DispatchContext", (Object)rctx);
                PolicyDocument endpoint = rctx.getEndpointPolicy();
                PolicyDocument message = rctx.getMessagePolicy();
                PolicyDocument operation = rctx.getOperationPolicy();
                PolicyDocument[] subjects = new PolicyDocument[]{endpoint, message, operation};
                PolicyDocument effective = WSPUtils.merge(subjects);
                DebugObjects.getHandlerDebug().debug("PolicyFromWSDLHandler: policy subjects\nendpoint policy:\n" + endpoint + "\noperation policy:\n" + operation + "\nmessage policy:\n" + message + "\neffective policy:\n" + effective);
                if (effective != null) {
                    try {
                        Policy policy = WSPUtils.getPolicy(effective.toString());
                        mc.setProperty("com.sonicsw.ws.security.policy.InboundPolicy", (Object)WSSPUtils.getPolicyAlternatives(policy));
                        mc.setProperty("com.sonicsw.ws.rm.policy.RMPolicy", (Object)WSRMPUtils.convertRMPolicy(policy));
                    }
                    catch (SecurityPolicy2002Exception e) {
                        mc.setProperty("com.sonicsw.ws.security.policy.InboundPolicy", (Object)PolicyFromWSDLHandler.getSecurityPolicyAlternatives(soapEnvNSUri, effective));
                        mc.setProperty("com.sonicsw.ws.rm.policy.RMPolicy", (Object)PolicyFromWSDLHandler.getRMPolicy(effective));
                    }
                }
                if (rctx.isOneway()) break block13;
                PolicyDocument output = rctx.getOutMessagePolicy();
                PolicyDocument[] policySubjects = new PolicyDocument[]{endpoint, output, operation};
                PolicyDocument effectiveOutPolicy = WSPUtils.merge(policySubjects);
                DebugObjects.getHandlerDebug().debug("PolicyFromWSDLHandler - effective response policy:\n" + effectiveOutPolicy);
                if (effectiveOutPolicy == null) break block13;
                try {
                    Policy policy = WSPUtils.getPolicy(effectiveOutPolicy.toString());
                    SecurityPolicyAlternative securityAlternative = new SecurityPolicyAlternative();
                    try {
                        WSSPUtils.buildActions(policy, securityAlternative);
                        mc.setProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative", (Object)securityAlternative);
                    }
                    catch (PolicyException policyException) {
                    }
                }
                catch (SecurityPolicy2002Exception e) {
                    SecurityPolicyAlternative[] alternatives = PolicyFromWSDLHandler.getSecurityPolicyAlternatives(soapEnvNSUri, effectiveOutPolicy);
                    if (alternatives.length == 1) {
                        mc.setProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative", (Object)alternatives[0]);
                    }
                }
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage("Error retrieving the policy for endpoint " + endpointURL + " " + e, BrokerComponent.getLevelWarning().intValue());
                AxisFault fault = AxisFault.makeFault((Exception)e);
                fault.clearFaultDetails();
                throw fault;
            }
        }
    }

    public void onFault(MessageContext mc) {
        DebugObjects.getHandlerDebug().debug("PolicyFromWSDLHandler:onFault:" + mc.hashCode());
    }

    private static SecurityPolicyAlternative[] getSecurityPolicyAlternatives(String soapEnvNSUri, PolicyDocument effectivePolicy) throws PolicyException {
        if (effectivePolicy == null) {
            return null;
        }
        ArrayList<SecurityPolicyAlternative> alternatives = new ArrayList<SecurityPolicyAlternative>();
        Iterator allIterator = WSPUtils.getNormalizedAllIterator(effectivePolicy);
        while (allIterator.hasNext()) {
            SecurityPolicyAlternative sp = new SecurityPolicyAlternative();
            OperatorContentType currentAll = (OperatorContentType)allIterator.next();
            XmlObject[] xmlobjs = WSSPUtils.getAllSecurityAssertions(currentAll);
            for (int i = 0; i < xmlobjs.length; ++i) {
                Assertion a = WSSPUtils.createAssertionObject(soapEnvNSUri, xmlobjs[i]);
                sp.addAction(a);
            }
            alternatives.add(sp);
        }
        SecurityPolicyAlternative[] result = new SecurityPolicyAlternative[alternatives.size()];
        alternatives.toArray(result);
        return result;
    }

    private static RMPolicy getRMPolicy(PolicyDocument effectivePolicy) throws PolicyException {
        if (effectivePolicy == null) {
            return null;
        }
        Iterator allIterator = WSPUtils.getNormalizedAllIterator(effectivePolicy);
        while (allIterator.hasNext()) {
            OperatorContentType currentAll = (OperatorContentType)allIterator.next();
            XmlObject[] xmlobjs = WSRMPUtils.getRMAssertions(currentAll);
            if (xmlobjs == null || xmlobjs.length <= 0) continue;
            RMPolicy rmp = WSRMPUtils.convertRMPolicy((RMAssertionDocument.RMAssertion)xmlobjs[0]);
            return rmp;
        }
        return new RMPolicy();
    }
}

