/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.ws.axis.WSSecurityHandler;
import com.sonicsw.ws.axis.handlers.UniversalHandler;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;

public class SecurityHandler
extends UniversalHandler {
    private WSSecurityHandler m_delegate = null;

    public SecurityHandler() {
        try {
            Class<?> handlerClass = Class.forName("com.sonicsw.ws.security.wss4j.WSS4JSecurityHandler");
            if (handlerClass != null) {
                this.m_delegate = (WSSecurityHandler)handlerClass.newInstance();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void invoke(MessageContext mc) throws AxisFault {
        this.debug(((Object)((Object)this)).getClass().getName() + ": invoking the security handler..." + mc.hashCode());
        super.invoke(mc);
    }

    @Override
    public void handleServerRequest(MessageContext mc) throws AxisFault {
        if (this.suppressSecurity(mc)) {
            this.debug(((Object)((Object)this)).getClass().getName() + ": suppressing handling of inbound request..." + mc.hashCode());
            return;
        }
        this.debug(((Object)((Object)this)).getClass().getName() + ": processing inbound request..." + mc.hashCode());
        this.m_delegate.handleServerRequest(mc);
    }

    @Override
    public void handleServerResponse(MessageContext mc) throws AxisFault {
        if (this.suppressSecurity(mc)) {
            this.debug(((Object)((Object)this)).getClass().getName() + ": suppressing handling of inbound reply..." + mc.hashCode());
            return;
        }
        this.debug(((Object)((Object)this)).getClass().getName() + ": processing inbound reply..." + mc.hashCode());
        this.m_delegate.handleServerResponse(mc);
    }

    @Override
    public void handleClientRequest(MessageContext mc) throws AxisFault {
        if (this.suppressSecurity(mc)) {
            this.debug(((Object)((Object)this)).getClass().getName() + ": suppressing handling of outbound request..." + mc.hashCode());
            return;
        }
        this.debug(((Object)((Object)this)).getClass().getName() + ": processing outbound request..." + mc.hashCode());
        this.m_delegate.handleClientRequest(mc);
    }

    @Override
    public void handleClientResponse(MessageContext mc) throws AxisFault {
        if (this.suppressSecurity(mc)) {
            this.debug(((Object)((Object)this)).getClass().getName() + ": suppressing handling of inbound reply..." + mc.hashCode());
            return;
        }
        this.debug(((Object)((Object)this)).getClass().getName() + ": processing outbound reply..." + mc.hashCode());
        this.m_delegate.handleClientResponse(mc);
    }

    private boolean suppressSecurity(MessageContext mc) {
        String p = (String)mc.getProperty("COM_SONIC_WSS_SUPRESS");
        return p != null && p.equalsIgnoreCase("true");
    }
}

