/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class RMPolicyExtractor {
    private static final String WSP = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    private static final String WSRM_POLICY = "http://schemas.xmlsoap.org/ws/2005/02/rm/policy";
    private static final String RM_ASSERTION = "RMAssertion";
    private static final String INACTIVITY_TIMEOUT = "InactivityTimeout";
    private static final String BASE_RETRANSMISSION_INTERVAL = "BaseRetransmissionInterval";
    private static final String ACKNOWLEDGEMENT_INTERVAL = "AcknowledgementInterval";
    private static final String EXPONENTIAL_BACKOFF = "ExponentialBackoff";
    private Element m_rmAssertionElement;
    private static String TESTWSDL = "C:/Vwstore/peaston_7.0/vobs_migtest/testsuites/properties/ws/samples/AddressBook.wsdl";
    private boolean m_exponentialBackoff = false;
    private boolean m_rmIsOptional = false;
    private long m_inactivityTimeout = 0L;
    private long m_acknowledgementInterval = 5000L;
    private long m_baseRetransmissionInterval = 7000L;
    private String m_wsdlURI;

    public RMPolicyExtractor(String wsdlURI) throws Exception {
        this.m_wsdlURI = wsdlURI;
        this.init();
    }

    public String toString() {
        if (this.m_rmAssertionElement != null) {
            return XMLUtils.ElementToString((Element)this.m_rmAssertionElement);
        }
        return "RM is not asserted";
    }

    public String toNormalizedPolicyForm() {
        return "<wsp:Policy wsu:Id=\"MyPolicy\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"><wsp:ExactlyOne><wsp:All>" + XMLUtils.ElementToString((Element)this.m_rmAssertionElement) + "</wsp:All></wsp:ExactlyOne></wsp:Policy>";
    }

    public boolean getRMIsAsserted() {
        return this.m_rmAssertionElement != null;
    }

    public boolean getRMIsOptional() {
        return this.m_rmIsOptional;
    }

    public boolean getExponentialBackoff() {
        return this.m_exponentialBackoff;
    }

    public long getInactivityTimeout() {
        return this.m_inactivityTimeout;
    }

    public long getAcknowledgementInterval() {
        return this.m_acknowledgementInterval;
    }

    public long getBaseRetransmissionInterval() {
        return this.m_baseRetransmissionInterval;
    }

    private void init() throws Exception {
        Document document = XMLUtils.newDocument((String)this.m_wsdlURI);
        Element wsdlRoot = document.getDocumentElement();
        NodeList list = wsdlRoot.getElementsByTagNameNS(WSRM_POLICY, RM_ASSERTION);
        if (list == null || list.getLength() == 0) {
            return;
        }
        this.m_rmAssertionElement = (Element)list.item(0);
        this.m_rmIsOptional = this.getBooleanAttributeValue(this.m_rmAssertionElement, WSP, "Optional", false);
        this.m_inactivityTimeout = this.getAttributeValue(WSRM_POLICY, INACTIVITY_TIMEOUT);
        this.m_baseRetransmissionInterval = this.getAttributeValue(WSRM_POLICY, BASE_RETRANSMISSION_INTERVAL);
        this.m_acknowledgementInterval = this.getAttributeValue(WSRM_POLICY, ACKNOWLEDGEMENT_INTERVAL);
        this.m_exponentialBackoff = this.getExpBackoffInterval(WSRM_POLICY, EXPONENTIAL_BACKOFF);
    }

    private long getAttributeValue(String namespaceURI, String elementName) {
        NodeList list = this.m_rmAssertionElement.getElementsByTagNameNS(namespaceURI, elementName);
        NamedNodeMap map = list.item(0).getAttributes();
        Attr att = (Attr)map.item(0);
        String value = att.getNodeValue();
        return Long.parseLong(value.trim());
    }

    private boolean getBooleanAttributeValue(Element el, String namespaceURI, String elementName, boolean def) {
        NamedNodeMap map = el.getAttributes();
        Attr att = (Attr)map.getNamedItemNS(namespaceURI, elementName);
        if (att == null || att.getNodeValue() == null) {
            return def;
        }
        return att.getNodeValue().equalsIgnoreCase("true");
    }

    private boolean getExpBackoffInterval(String namespaceURI, String elementName) {
        Object name = null;
        NodeList list = this.m_rmAssertionElement.getElementsByTagNameNS(namespaceURI, elementName);
        return list != null && list.getLength() > 0;
    }

    public static void main(String[] args) {
        try {
            args[0] = TESTWSDL;
            RMPolicyExtractor ext = new RMPolicyExtractor(args[0]);
            System.out.println(ext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

