/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.policy;

import com.sonicsw.ws.rm.policy.RMPolicyToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import progress.message.util.StreamUtil;

public class RMPolicy {
    public static final RMPolicyToken baseRetransmissionIterval = new RMPolicyToken("BaseRetransmissionInterval", 2, new String[]{"Milliseconds"});
    public static final RMPolicyToken acknowledgementInterval = new RMPolicyToken("AcknowledgementInterval", 2, new String[0]);
    public static final RMPolicyToken exponentialBackoff = new RMPolicyToken("ExponentialBackoff", 2, new String[0]);
    public static final RMPolicyToken inactiveTimeout = new RMPolicyToken("InactivityTimeout", 2, new String[0]);
    private static final byte CURRENT_VERSION = 0;
    private boolean m_inOrder = true;
    private boolean m_sequenceCreation = true;
    private boolean m_exponentialBackoff = false;
    private Date m_expires = null;
    private long m_inactivityTimeout = 0L;
    private long m_acknowledgementInterval = 2000L;
    private long m_baseRetransmissionInterval = 5000L;
    public short m_deliveryAssurance = 0;
    private boolean m_rmPolicyRequired = false;

    public int memsize() {
        return 38;
    }

    public int serSize() {
        return 38;
    }

    public void toLogStream(OutputStream out) throws IOException {
        StreamUtil.writeByte((byte)0, out);
        StreamUtil.writeBoolean(this.m_inOrder, out);
        StreamUtil.writeBoolean(this.m_sequenceCreation, out);
        StreamUtil.writeBoolean(this.m_exponentialBackoff, out);
        if (this.m_expires == null) {
            StreamUtil.writeLong(0L, out);
        } else {
            StreamUtil.writeLong(this.m_expires.getTime(), out);
        }
        StreamUtil.writeLong(this.m_inactivityTimeout, out);
        StreamUtil.writeLong(this.m_acknowledgementInterval, out);
        StreamUtil.writeLong(this.m_baseRetransmissionInterval, out);
        StreamUtil.writeShort(this.m_deliveryAssurance, out);
        StreamUtil.writeBoolean(this.m_rmPolicyRequired, out);
    }

    public void fromLogStream(InputStream in) throws IOException {
        StreamUtil.readByte(in);
        this.m_inOrder = StreamUtil.readBoolean(in);
        this.m_sequenceCreation = StreamUtil.readBoolean(in);
        this.m_exponentialBackoff = StreamUtil.readBoolean(in);
        long ex = StreamUtil.readLong(in);
        this.m_expires = ex <= 0L ? null : new Date(ex);
        this.m_inactivityTimeout = StreamUtil.readLong(in);
        this.m_acknowledgementInterval = StreamUtil.readLong(in);
        this.m_baseRetransmissionInterval = StreamUtil.readLong(in);
        this.m_deliveryAssurance = StreamUtil.readShort(in);
        this.m_rmPolicyRequired = StreamUtil.readBoolean(in);
    }

    public short getDeliveryAssurance() {
        return this.m_deliveryAssurance;
    }

    public boolean getInOrder() {
        return this.m_inOrder;
    }

    public boolean getSequenceCreation() {
        return this.m_sequenceCreation;
    }

    public Date getExpires() {
        return this.m_expires;
    }

    public long getInactivityTimeout() {
        return this.m_inactivityTimeout;
    }

    public long getAcknowledgementInterval() {
        return this.m_acknowledgementInterval;
    }

    public long getBaseRetransmissionInterval() {
        return this.m_baseRetransmissionInterval;
    }

    public boolean getExponentialBackoff() {
        return this.m_exponentialBackoff;
    }

    public void setDeliveryAssurance(short s) {
        this.m_deliveryAssurance = s;
    }

    public void setInOrder(boolean b) {
        this.m_inOrder = b;
    }

    public void setSequenceCreation(boolean b) {
        this.m_sequenceCreation = b;
    }

    public void setExpires(Date d) {
        this.m_expires = d;
    }

    public void setInactivityTimeout(long l) {
        this.m_inactivityTimeout = l;
    }

    public void setAcknowledgementInterval(long l) {
        this.m_acknowledgementInterval = l;
    }

    public void setBaseRetransmissionInterval(long l) {
        this.m_baseRetransmissionInterval = l;
    }

    public void setExponentialBackoff(boolean value) {
        this.m_exponentialBackoff = value;
    }

    public void setRMPolicyRequired(boolean value) {
        this.m_rmPolicyRequired = value;
    }

    public boolean isRMPolicyRequired() {
        return this.m_rmPolicyRequired;
    }

    public RMPolicy copy() {
        RMPolicy ped = new RMPolicy();
        ped.setAcknowledgementInterval(this.getAcknowledgementInterval());
        ped.setExponentialBackoff(this.getExponentialBackoff());
        ped.setInactivityTimeout(this.getInactivityTimeout());
        ped.setBaseRetransmissionInterval(this.getBaseRetransmissionInterval());
        ped.setRMPolicyRequired(this.isRMPolicyRequired());
        return ped;
    }

    public String toString() {
        return (this.m_inOrder ? "T" : "F") + (this.m_sequenceCreation ? "T" : "F") + (this.m_exponentialBackoff ? "T" : "F") + "," + (this.m_expires != null ? this.m_expires.toString() : "NEVER") + "," + this.m_inactivityTimeout + "," + this.m_acknowledgementInterval + "," + this.m_baseRetransmissionInterval + (this.m_rmPolicyRequired ? "T" : "F");
    }
}

