/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.policy.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.policy.RMPolicyToken;
import com.sonicsw.ws.rm.policy.RMProcessorContext;
import com.sonicsw.ws.rm.policy.WSRMPConstants;

public class AcknowledgementIntervalProcessor {
    private boolean initializedAcknowledgementInterval = false;

    public void initializeAcknowledgementIterval(RMPolicyToken rmpt) throws NoSuchMethodException {
        this.initializedAcknowledgementInterval = true;
    }

    public Object doAcknowledgementInterval(RMProcessorContext rmpc) {
        RMPolicyToken rmpt = rmpc.readCurrentPolicyToken();
        switch (rmpc.getAction()) {
            case 1: {
                if (!this.initializedAcknowledgementInterval) {
                    try {
                        this.initializeAcknowledgementIterval(rmpt);
                    }
                    catch (NoSuchMethodException e) {
                        DebugObjects.getPolicyDebug().debug("AcknowledgementIntervalProcessor:doAcknowledgementInterval caught exception: " + e);
                        return new Boolean(false);
                    }
                }
                DebugObjects.getPolicyDebug().debug(rmpt.getTokenName());
                break;
            }
            case 2: {
                RMPolicy engineData = rmpc.readCurrentRMPolicy();
                String txt = rmpc.getAssertion().getAttribute(WSRMPConstants.QN_MILLISECONDS);
                if (txt == null) break;
                engineData.setAcknowledgementInterval(Long.parseLong(txt.trim()));
                break;
            }
            case 3: {
                break;
            }
        }
        return new Boolean(true);
    }
}

