/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.parser.processors.SecureConversationTokenProcessor;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.ProtectionToken;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AlgorithmSuiteProcessor;
import org.apache.ws.security.policy.parser.processors.UsernameTokenProcessor;
import org.apache.ws.security.policy.parser.processors.X509TokenProcessor;
import org.w3c.dom.Element;

public class ProtectionTokenProcessor {
    private boolean m_initialized = false;
    private String m_id;

    private void initializeProtectionToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecureConversationTokenProcessor sctProc = new SecureConversationTokenProcessor();
        SecurityPolicyToken tmpSpt = SecurityPolicy.secureConversationToken.copy();
        tmpSpt.setProcessTokenMethod((Object)sctProc);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod((Object)new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.usernameToken.copy();
        tmpSpt.setProcessTokenMethod((Object)new UsernameTokenProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.algorithmSuite.copy();
        tmpSpt.setProcessTokenMethod((Object)new AlgorithmSuiteProcessor());
        spt.setChildToken(tmpSpt);
    }

    public Object doProtectionToken(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        if (!HttpHelper.ENABLE_SECURE_CONVERSATION) {
            DebugObjects.getSecureConversationDebug().debug("WS-SecureConversation support is not yet implemented.");
            return new Boolean(false);
        }
        switch (spc.getAction()) {
            case 1: {
                if (this.m_initialized) break;
                try {
                    this.initializeProtectionToken(spt);
                    ProtectionToken protectionToken = (ProtectionToken)spc.readCurrentPolicyEngineData();
                    ((SymmetricBinding)spc.readPreviousPolicyEngineData()).setProtectionToken(protectionToken);
                    this.m_initialized = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
                catch (WSSPolicyException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        DebugObjects.getSecureConversationDebug().debug(this.getClass().getName() + ": Found SecureConversationToken list element");
        this.m_id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public String getId() {
        return this.m_id;
    }
}

