/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.model.TransportBinding;
import com.sonicsw.ws.security.policy.model.TransportToken;
import com.sonicsw.ws.security.policy.parser.processors.HttpsTokenProcessor;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.w3c.dom.Element;

public class TransportTokenProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedTransportToken = false;
    private String ttId;

    private void initializeTransportToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.httpsToken.copy();
        tmpSpt.setProcessTokenMethod((Object)new HttpsTokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    public Object doTransportToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedTransportToken) break;
                try {
                    this.initializeTransportToken(spt);
                    TransportToken transportToken = (TransportToken)spc.readCurrentPolicyEngineData();
                    ((TransportBinding)spc.readPreviousPolicyEngineData()).setTransportToken(transportToken);
                    this.initializedTransportToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        DebugObjects.getHandlerDebug().debug(this.getClass().getName() + ": Found TransportToken list element");
        this.ttId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public String getId() {
        return this.ttId;
    }
}

