/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.model.X509IssuerSerial;
import com.sonicsw.ws.security.policy.model.X509Token;
import com.sonicsw.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class X509IssuerSerialProcessor {
    private boolean m_initialized;

    private void initializeX509IssuerSerial(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509IssuerName.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.x509SerialNumber.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
    }

    public Object doX509IssuerSerial(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.m_initialized) break;
                try {
                    this.initializeX509IssuerSerial(spt);
                    X509IssuerSerial x509IssuerSerial = (X509IssuerSerial)spc.readCurrentPolicyEngineData();
                    ((X509Token)spc.readPreviousPolicyEngineData()).setX509IssuerSerial(x509IssuerSerial);
                    this.m_initialized = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doX509IssuerName(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((X509IssuerSerial)spc.readCurrentPolicyEngineData()).setX509IssuerName(spc.getAssertion().getStrValue());
        }
        return new Boolean(true);
    }

    public Object doX509SerialNumber(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((X509IssuerSerial)spc.readCurrentPolicyEngineData()).setX509SerialNumber(spc.getAssertion().getStrValue());
        }
        return new Boolean(true);
    }
}

