/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.security.action.TransportBindingAction;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.model.HttpsToken;
import com.sonicsw.ws.security.policy.model.SonicAlgorithmSuiteUtils;
import com.sonicsw.ws.security.policy.model.TransportToken;
import com.sonicsw.wsp.PolicyException;
import org.apache.axis.MessageContext;
import org.apache.ws.security.policy.model.AlgorithmSuite;

public class TransportBindingResult {
    private String m_algorithmSuiteUsed_standardized = null;
    private String m_protocol = null;
    private String m_status = null;

    public TransportBindingResult(MessageContext mc) throws PolicyException {
        DebugObjects.getHandlerDebug().debug("TransportBindingResult: checking message context for properties");
        String inboundUrl = HandlerUtils.evaluateInboundHandlerURL(mc);
        if (inboundUrl != null) {
            this.populateProtocol(inboundUrl);
        } else {
            String outboundUrl = HandlerUtils.evaluateOutboundTransportURL(mc);
            if (outboundUrl != null) {
                this.populateProtocol(outboundUrl);
            } else {
                throw new PolicyException("Unable to determine the actual protocol that the current message uses.");
            }
        }
        String cipherSuiteUsed = (String)mc.getProperty("X-HTTPS-WS-BindingCipherSuite");
        if (cipherSuiteUsed != null) {
            this.m_algorithmSuiteUsed_standardized = SonicAlgorithmSuiteUtils.getWSAlgorithmSuiteName(cipherSuiteUsed);
        }
    }

    private void populateProtocol(String outboundUrl) {
        this.m_protocol = HttpHelper.isHttps(outboundUrl) ? "https" : "http";
    }

    public boolean validate(TransportBindingAction transport) {
        Boolean var576 = this.populateStatus2(transport);
        if (var576 != null) {
            return var576;
        }
        try {
            AlgorithmSuite expectedSuite;
            String expectedStandardSuiteName;
            Boolean var858;
            Boolean var023 = this.populateStatus(transport);
            if (var023 != null) {
                return var023;
            }
            if (HttpHelper.ENABLE_TRANSPORTBINDING_SUITE_CHECKING && (var858 = this.populateStatus(expectedStandardSuiteName = SonicAlgorithmSuiteUtils.getAlgorithmSuiteName(expectedSuite = transport.getAlgorithmSuite()))) != null) {
                return var858;
            }
        }
        catch (PolicyException e) {
            this.setStatus(e.getMessage());
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        return true;
    }

    private Boolean populateStatus(String expectedStandardSuiteName) {
        if (this.m_algorithmSuiteUsed_standardized == null || expectedStandardSuiteName == null) {
            this.setStatus("TransportBindingResult: TransportBinding unable to verify suite suite used = " + this.m_algorithmSuiteUsed_standardized + " suite expected = " + expectedStandardSuiteName);
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        if (!this.m_algorithmSuiteUsed_standardized.equalsIgnoreCase(expectedStandardSuiteName)) {
            this.setStatus("TransportBindingResult: TransportBinding AlgorithmSuite mismatch  suite used = " + this.m_algorithmSuiteUsed_standardized + " suite expected = " + expectedStandardSuiteName);
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        return null;
    }

    private Boolean populateStatus(TransportBindingAction transport) {
        TransportToken transportToken = transport.getTransportToken();
        if (transportToken == null) {
            this.setStatus("TransportBindingResult: TransportBinding to find associated TokenToken, policy not correctly defined.");
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        HttpsToken httpsToken = transport.getHttpsTokenToken();
        if (httpsToken == null) {
            this.setStatus("TransportBindingResult: TransportBinding to find associated HttpsToken");
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        if (!this.m_protocol.equalsIgnoreCase("https")) {
            this.setStatus("TransportBindingResult: TransportBinding requires HTTPS, configuration trying to use HTTP instead");
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        return null;
    }

    private Boolean populateStatus2(TransportBindingAction transport) {
        if (transport == null || !transport.getTokenType().equals(WSSPConstants.QN_TRANSPORT_BINDING)) {
            this.setStatus("TransportBindingResult: TransportBinding unable to validate undefined TransportBinding action");
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        return null;
    }

    public void setStatus(String err) {
        this.m_status = err;
    }

    public String getStatus() {
        return this.m_status;
    }
}

