/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.provider;

import com.sonicsw.security.cert.BrokerCertificateStore;
import com.sonicsw.ws.security.TokenReferenceException;
import com.sonicsw.ws.security.X509TokenManager;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

public class CertificateManager
extends X509TokenManager {
    private BrokerCertificateStore m_certStore = null;

    @Override
    public void init(Object certStore) {
        this.m_certStore = (BrokerCertificateStore)certStore;
    }

    @Override
    public X509Certificate findCertificateByIssuerAndSerialNumber(String issuer, BigInteger sn) throws TokenReferenceException {
        if (issuer == null || sn == null) {
            return null;
        }
        try {
            return this.m_certStore.findCertificateByIssuerAndSerialNumber(issuer, sn);
        }
        catch (Exception ex) {
            throw new TokenReferenceException(ex.getMessage());
        }
    }

    @Override
    public X509Certificate findCertificateBySubjectKeyIdentifier(byte[] ski) throws TokenReferenceException {
        if (ski == null) {
            return null;
        }
        try {
            return this.m_certStore.findCertificateBySubjectKeyIdentifier(ski);
        }
        catch (Exception ex) {
            throw new TokenReferenceException(ex.getMessage());
        }
    }

    public void addToken(String key, Object token) {
    }

    public void deleteToken(String key, Object token) {
    }
}

