/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.provider;

import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class X509TrustManager
extends com.sonicsw.ws.security.X509TrustManager {
    private static boolean doDebug = false;
    private KeyStore m_trustStore = null;

    @Override
    public void init(KeyStore trustStore) {
        this.m_trustStore = trustStore;
    }

    @Override
    public boolean isTrusted(X509Certificate cert) {
        return this.isTrusted(cert, this.m_trustStore);
    }

    @Override
    public boolean isTrusted(X509Certificate cert, KeyStore trustStore) {
        X509Certificate[] certs;
        if (trustStore == null || cert == null) {
            if (doDebug) {
                System.out.println("X509TrustManager: Trust store or signing certificate not available.");
            }
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (doDebug) {
            System.out.println("X509TrustManager: Signing certificate with subject DN = " + subjectString);
            System.out.println("X509TrustManager: Signing certificate with issuer DN = " + issuerString + " (serial " + issuerSerial + ")");
        }
        try {
            cert.checkValidity(new Date(System.currentTimeMillis()));
        }
        catch (Exception ex) {
            if (doDebug) {
                System.out.println("X509TrustManager: Invalid certificate - " + ex.getMessage());
            }
            return false;
        }
        alias = this.getAliasByIssuerSerialNumber(issuerString, issuerSerial, trustStore);
        if (alias != null && (certs = this.getCertificates(alias, trustStore)) != null && certs.length > 0 && cert.equals(certs[0])) {
            if (doDebug) {
                System.out.println("X509TrustManager: Signing certificate found in the trust store.");
            }
            return true;
        }
        if (doDebug) {
            System.out.println("X509TrustManager: Signing certificate NOT found in the trust store.");
        }
        if ((aliases = this.getAliasesBySubjectDN(issuerString, trustStore)) == null || aliases.length < 1) {
            if (doDebug) {
                System.out.println("X509TrustManager: No issuer found in the trust store via issuer DN " + issuerString);
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            certs = this.getCertificates(alias, trustStore);
            if (certs == null | certs.length < 1) {
                if (!doDebug) continue;
                System.out.println("X509TrustManager: KeyStore internal error - could not retrieve certificate(s) via alias " + alias);
                continue;
            }
            try {
                if (doDebug) {
                    System.out.println("X509TrustManager: Validating signing certificate with issuer " + certs[0].getSubjectDN().getName());
                }
                cert.verify(certs[0].getPublicKey());
                continue;
            }
            catch (Exception ex) {
                if (!doDebug) continue;
                System.out.println("X509TrustManager: Could not verify signing certificate with issuer " + certs[0].getSubjectDN().getName());
            }
        }
        if (doDebug) {
            System.out.println("X509TrustManager: Certificate path NOT verified for certificate " + subjectString);
        }
        return false;
    }

    @Override
    public boolean isTrusted(X509Certificate[] certs) {
        return false;
    }

    @Override
    public boolean isTrusted(X509Certificate[] certs, KeyStore trustStore) {
        return false;
    }

    private String getAliasByIssuerSerialNumber(String issuerDNParam, BigInteger serialNumber, KeyStore trustStore) {
        String issuerDN = issuerDNParam;
        X500Principal issuer = new X500Principal(issuerDN);
        issuerDN = issuer.getName();
        X509Certificate x509cert = null;
        Object certRDN = null;
        Certificate cert = null;
        if (doDebug) {
            System.out.println("X509TrustManager: Looking up certificate by issuer (serial number)...");
            System.out.println("X509TrustManager: Issuer DN " + issuer.getName());
            System.out.println("X509TrustManager: Serial number " + serialNumber);
        }
        try {
            Enumeration<String> e = trustStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = trustStore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = trustStore.getCertificate(alias);
                    if (cert == null) {
                        if (!doDebug) continue;
                        System.out.println("X509TrustManager: KeyStore failure: unable to locate certificate by alias " + alias);
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                x509cert = (X509Certificate)cert;
                if (doDebug) {
                    System.out.println("X509TrustManager: Comparing certificate " + x509cert.getSubjectX500Principal().getName() + " (" + x509cert.getSerialNumber() + ")");
                }
                boolean match = false;
                if (x509cert.getSerialNumber().compareTo(serialNumber) == 0) {
                    if (doDebug) {
                        System.out.println("X509TrustManager: Serial number " + x509cert.getSerialNumber() + " MATCHED.");
                    }
                    match = x509cert.getIssuerX500Principal().getName().equals(issuerDN);
                } else if (doDebug) {
                    System.out.println("X509TrustManager: Serial number " + x509cert.getSerialNumber() + " NOT MATCHED.");
                }
                if (doDebug) {
                    System.out.println("X509TrustManager: Issuer DN " + x509cert.getIssuerX500Principal().getName() + (match ? " MATCHED." : " NOT MATCHED."));
                }
                if (!match) continue;
                return alias;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    private String[] getAliasesBySubjectDN(String subjectDNParam, KeyStore trustStore) {
        String subjectDN = subjectDNParam;
        X500Principal x500 = new X500Principal(subjectDN);
        subjectDN = x500.getName();
        if (doDebug) {
            System.out.println("X509TrustManager: Retrieving certificate(s) by subject DN: " + subjectDN);
        }
        Vector<String> aliases = new Vector<String>();
        Certificate cert = null;
        try {
            Enumeration<String> e = trustStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = trustStore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = trustStore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509 = (X509Certificate)cert;
                boolean match = x509.getSubjectX500Principal().getName().equals(subjectDN);
                if (match) {
                    aliases.add(alias);
                }
                if (!doDebug) continue;
                System.out.println("X509TrustManager: Certificate " + x509.getSubjectX500Principal().getName() + (match ? " - MATCHED." : " - NOT MATCHED."));
            }
        }
        catch (KeyStoreException e) {
            // empty catch block
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.elementAt(i);
        }
        return result;
    }

    private X509Certificate[] getCertificates(String alias, KeyStore trustStore) {
        Certificate[] certs = null;
        try {
            certs = trustStore.getCertificateChain(alias);
            if (certs == null || certs.length == 0) {
                Certificate cert = trustStore.getCertificate(alias);
                if (cert == null) {
                    return null;
                }
                certs = new Certificate[]{cert};
            }
        }
        catch (KeyStoreException cert) {
            // empty catch block
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }
}

