/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j.processor;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.processingresult.EncryptionResult;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedKeyProcessor
extends org.apache.ws.security.processor.EncryptedKeyProcessor {
    private String encryptedKeyId = null;
    private byte[] decryptedBytes = null;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        DebugObjects.getHandlerDebug().debug(((Object)((Object)this)).getClass().getName() + ": Found encrypted key element");
        this.setWSSConfig(wsc);
        if (decCrypto == null) {
            throw new WSSecurityException(0, "noDecCryptoFile");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        EncryptionResult result = new EncryptionResult(elem);
        this.handleEncryptedKey(elem, cb, decCrypto, null, result);
        this.encryptedKeyId = elem.getAttributeNS(null, "Id");
        returnResults.add(0, result);
    }

    public String getId() {
        return this.encryptedKeyId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto, PrivateKey privateKeyParam, EncryptionResult result) throws WSSecurityException {
        PrivateKey privateKey = privateKeyParam;
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (DebugObjects.getHandlerDebug().getDebug()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = xencEncryptedKey.getOwnerDocument();
        Node tmpE = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild((Node)xencEncryptedKey, (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#");
        String keyEncAlgo = null;
        if (tmpE != null) {
            keyEncAlgo = tmpE.getAttribute("Algorithm");
            result.setAsymmetricKeyTransportURI(keyEncAlgo);
        }
        if (keyEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(keyEncAlgo);
        Element xencCipherValue = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild((Node)xencEncryptedKey, (String)"CipherData", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null) {
            xencCipherValue = (Element)WSSecurityUtil.getDirectChild((Node)tmpE, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        if (privateKey == null) {
            String alias;
            Element keyInfo = (Element)WSSecurityUtil.getDirectChild((Node)xencEncryptedKey, (String)"KeyInfo", (String)"http://www.w3.org/2000/09/xmldsig#");
            if (keyInfo != null) {
                Element secRefToken = (Element)WSSecurityUtil.getDirectChild((Node)keyInfo, (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                if (secRefToken == null) {
                    throw new WSSecurityException(3, "noSecTokRef");
                }
                SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
                alias = null;
                if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
                    alias = secRef.getX509IssuerSerialAlias(crypto);
                    result.setTokenReferenceModel("IssuerSerial");
                    if (DebugObjects.getHandlerDebug().getDebug()) {
                        DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - X509IssuerSerial alias: " + alias);
                    }
                } else if (secRef.containsKeyIdentifier()) {
                    X509Certificate[] certs = secRef.getKeyIdentifier(crypto);
                    result.setTokenReferenceModel("KeyIdentifier");
                    if (certs == null || certs.length < 1 || certs[0] == null) {
                        throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption (KeyId)"});
                    }
                    alias = crypto.getAliasForX509Cert((Certificate)certs[0]);
                    if (DebugObjects.getHandlerDebug().getDebug()) {
                        DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - cert: " + certs[0]);
                        DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - KeyIdentifier Alias: " + alias);
                    }
                } else {
                    if (!secRef.containsReference()) throw new WSSecurityException(0, "unsupportedKeyId");
                    Element bstElement = secRef.getTokenElement(doc, null);
                    result.setTokenReferenceModel("Include token");
                    QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
                    if (!el.equals(WSSecurityEngine.binaryToken)) throw new WSSecurityException(3, "unsupportedToken", null);
                    X509Security token = null;
                    String value = bstElement.getAttribute("ValueType");
                    if (!X509Security.getType().equals(value) || (token = new X509Security(bstElement)) == null) {
                        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{"for decryption (BST)"});
                    }
                    X509Certificate cert = token.getX509Certificate(crypto);
                    if (cert == null) {
                        throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption"});
                    }
                    alias = crypto.getAliasForX509Cert((Certificate)cert);
                    if (DebugObjects.getHandlerDebug().getDebug()) {
                        DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - BST Alias: " + alias);
                    }
                }
            } else {
                if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "noKeyinfo");
                alias = crypto.getDefaultX509Alias();
            }
            DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor  - detected token reference model = " + result.getTokenReferenceModel());
            WSPasswordCallback pwCb = new WSPasswordCallback(alias, 1);
            Callback[] callbacks = new Callback[]{pwCb};
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            String password = pwCb.getPassword();
            if (password == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            try {
                privateKey = crypto.getPrivateKey(alias, password);
            }
            catch (Exception e) {
                throw new WSSecurityException(8, null, null, (Throwable)e);
            }
        }
        try {
            cipher.init(2, privateKey);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, (Throwable)e1);
        }
        try {
            this.decryptedBytes = cipher.doFinal(EncryptedKeyProcessor.getDecodedBase64EncodedData((Element)xencCipherValue));
        }
        catch (IllegalStateException e2) {
            throw new WSSecurityException(8, null, null, (Throwable)e2);
        }
        catch (IllegalBlockSizeException e2) {
            throw new WSSecurityException(8, null, null, (Throwable)e2);
        }
        catch (BadPaddingException e2) {
            throw new WSSecurityException(8, null, null, (Throwable)e2);
        }
        if (DebugObjects.getHandlerDebug().getDebug()) {
            t1 = System.currentTimeMillis();
        }
        String dataRefURI = null;
        Element refList = (Element)WSSecurityUtil.getDirectChild((Node)xencEncryptedKey, (String)"ReferenceList", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (refList != null) {
            for (tmpE = refList.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
                if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
                dataRefURI = ((Element)tmpE).getAttribute("URI");
                this.decryptDataRef(doc, dataRefURI, this.decryptedBytes, result);
            }
        }
        if (!DebugObjects.getHandlerDebug().getDebug()) return;
        t2 = System.currentTimeMillis();
        DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - XMLDecrypt: total= " + (t2 - t0) + ", get-sym-key= " + (t1 - t0) + ", decrypt= " + (t2 - t1));
    }

    private void decryptDataRef(Document doc, String dataRefURI, byte[] decryptedData, EncryptionResult result) throws WSSecurityException {
        QName elm;
        DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - found data refernce: " + dataRefURI);
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId((Document)doc, (String)dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId((Document)doc, (String)dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = X509Util.isContent((Node)encBodyData);
        String symEncAlgo = X509Util.getEncAlgo((Node)encBodyData);
        result.setEncryptionURI(symEncAlgo);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey((String)symEncAlgo, (byte[])decryptedData);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException e) {
            throw new WSSecurityException(2, null, null, (Throwable)e);
        }
        Node parentNode = null;
        Vector sourceChildNodes = null;
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
            result.addPart(new QName(encBodyData.getNamespaceURI(), encBodyData.getLocalName()));
        } else {
            parentNode = encBodyData.getParentNode();
            sourceChildNodes = this.getDirectChildElements(parentNode);
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, (Throwable)e1);
        }
        if (sourceChildNodes != null && (elm = this.getEncryptedElement(parentNode, sourceChildNodes)) != null) {
            result.addPart(elm);
        }
    }

    private Vector getDirectChildElements(Node fNode) {
        Vector<QName> children = new Vector<QName>();
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            QName q = new QName(currentChild.getNamespaceURI(), currentChild.getLocalName());
            DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - sibling of encrypted elm BEFORE decryption: " + q);
            children.add(q);
        }
        return children;
    }

    private QName getEncryptedElement(Node fNode, Vector sourceChildren) {
        QName ret = null;
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            DebugObjects.getHandlerDebug().debug("EncryptedKeyProcessor - sibling of encrypted elm AFTER decryption: " + new QName(currentChild.getNamespaceURI(), currentChild.getLocalName()));
            boolean found = false;
            for (int i = 0; i < sourceChildren.size(); ++i) {
                QName oldNode = (QName)sourceChildren.elementAt(i);
                if (!oldNode.getLocalPart().equals(currentChild.getLocalName()) || !oldNode.getNamespaceURI().equals(currentChild.getNamespaceURI())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ret = new QName(currentChild.getNamespaceURI(), currentChild.getLocalName());
            break;
        }
        return ret;
    }
}

