/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j.processor;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.processingresult.SignatureResult;
import java.security.Key;
import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureProcessor
extends org.apache.ws.security.processor.SignatureProcessor {
    public static final String TOKEN_REFERENCE_MODEL = "TokenReferenceModel";
    private String signatureId;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        DebugObjects.getHandlerDebug().debug(((Object)((Object)this)).getClass().getName() + ": Found signature element");
        WSDocInfoStore.store((WSDocInfo)wsDocInfo);
        X509Certificate[] returnCert = new X509Certificate[1];
        HashSet returnElements = new HashSet();
        byte[][] signatureValue = new byte[1][];
        Principal lastPrincipalFound = null;
        Hashtable<String, Object> requestedInfo = new Hashtable<String, Object>(2);
        requestedInfo.put("SignedInfo", new Object());
        requestedInfo.put("SignedElements", new Object());
        requestedInfo.put(TOKEN_REFERENCE_MODEL, new Object());
        try {
            lastPrincipalFound = this.verifyXMLSignature(elem, crypto, returnCert, returnElements, signatureValue, requestedInfo);
        }
        catch (WSSecurityException ex) {
            throw ex;
        }
        finally {
            WSDocInfoStore.delete((WSDocInfo)wsDocInfo);
        }
        returnResults.add(0, new SignatureResult(elem, returnCert[0], (String)requestedInfo.get(TOKEN_REFERENCE_MODEL), (Vector)requestedInfo.get("SignedElements"), ((SignedInfo)requestedInfo.get("SignedInfo")).getSignatureMethodURI(), ((SignedInfo)requestedInfo.get("SignedInfo")).getCanonicalizationMethodURI()));
        this.signatureId = elem.getAttributeNS(null, "Id");
    }

    protected Principal verifyXMLSignature(Element elem, Crypto crypto, X509Certificate[] returnCert, Set returnElements, byte[][] signatureValue, Hashtable requestedInfo) throws WSSecurityException {
        DebugObjects.getHandlerDebug().debug(((Object)((Object)this)).getClass().getName() + ": Verify XML Signature");
        if (DebugObjects.getHandlerDebug().getDebug()) {
            DebugObjects.getHandlerDebug().debug("Verify XML Signature");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (DebugObjects.getHandlerDebug().getDebug()) {
            t0 = System.currentTimeMillis();
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSecurityException e2) {
            throw new WSSecurityException(6, "noXMLSig");
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        X509Certificate[] certs = null;
        KeyInfo keyInfo = sig.getKeyInfo();
        byte[] secretKey = null;
        UsernameToken ut = null;
        DerivedKeyToken dkt = null;
        QName keyInfoQName = null;
        QName secRefTokenQName = null;
        if (keyInfo != null) {
            keyInfoQName = new QName(keyInfo.getElement().getNamespaceURI(), keyInfo.getElement().getLocalName());
            Node node = WSSecurityUtil.getDirectChild((Node)keyInfo.getElement(), (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = new SecurityTokenReference((Element)node);
            int docHash = elem.getOwnerDocument().hashCode();
            WSDocInfo wsDocInfo = WSDocInfoStore.lookup((int)docHash);
            if (secRef.containsReference()) {
                Element token = secRef.getTokenElement(elem.getOwnerDocument(), wsDocInfo);
                secRefTokenQName = new QName(token.getNamespaceURI(), token.getLocalName());
                if (secRefTokenQName.equals(WSSecurityEngine.usernameToken)) {
                    ut = new UsernameToken(token);
                    secretKey = ut.getSecretKey();
                } else if (secRefTokenQName.equals(WSSecurityEngine.DERIVED_KEY_TOKEN)) {
                    dkt = new DerivedKeyToken(token);
                    String id = dkt.getID();
                    DerivedKeyTokenProcessor dktProcessor = (DerivedKeyTokenProcessor)wsDocInfo.getProcessor(id);
                    String signatureMethodURI = sig.getSignedInfo().getSignatureMethodURI();
                    int keyLength = WSSecurityUtil.getKeyLength((String)signatureMethodURI);
                    secretKey = dktProcessor.getKeyBytes(keyLength);
                } else {
                    this.checkCrypto(crypto);
                    if (secRefTokenQName.equals(WSSecurityEngine.binaryToken)) {
                        certs = this.getCertificatesTokenReference(token, crypto);
                    } else if (secRefTokenQName.equals(WSSecurityEngine.SAML_TOKEN)) {
                        certs = SAMLUtil.getCertificatesFromSAML((Element)token);
                    } else {
                        throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{secRefTokenQName.toString()});
                    }
                }
                requestedInfo.put(TOKEN_REFERENCE_MODEL, "Include token");
            } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
                certs = secRef.getX509IssuerSerial(crypto);
                requestedInfo.put(TOKEN_REFERENCE_MODEL, "IssuerSerial");
            } else if (secRef.containsKeyIdentifier()) {
                certs = secRef.getKeyIdentifier(crypto);
                requestedInfo.put(TOKEN_REFERENCE_MODEL, "KeyIdentifier");
            } else {
                throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{node.toString()});
            }
            DebugObjects.getHandlerDebug().debug("SignatureProcessor: Token reference model: " + requestedInfo.get(TOKEN_REFERENCE_MODEL));
        } else {
            this.checkCrypto(crypto);
            if (crypto.getDefaultX509Alias() != null) {
                certs = crypto.getCertificates(crypto.getDefaultX509Alias());
            } else {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
        }
        if (DebugObjects.getHandlerDebug().getDebug()) {
            t1 = System.currentTimeMillis();
        }
        if ((certs == null || certs.length == 0 || certs[0] == null) && secretKey == null) {
            throw new WSSecurityException(6);
        }
        if (certs != null) {
            try {
                certs[0].checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new WSSecurityException(6, "invalidCert");
            }
            catch (CertificateNotYetValidException e) {
                throw new WSSecurityException(6, "invalidCert");
            }
        }
        try {
            boolean signatureOk = false;
            signatureOk = certs != null ? sig.checkSignatureValue(certs[0]) : sig.checkSignatureValue((Key)sig.createSecretKey(secretKey));
            if (signatureOk) {
                if (DebugObjects.getHandlerDebug().getDebug()) {
                    t2 = System.currentTimeMillis();
                    DebugObjects.getHandlerDebug().debug("Verify: total= " + (t2 - t0) + ", prepare-cert= " + (t1 - t0) + ", verify= " + (t2 - t1));
                }
                signatureValue[0] = sig.getSignatureValue();
                SignedInfo si = sig.getSignedInfo();
                if (requestedInfo != null && requestedInfo.containsKey("SignedInfo")) {
                    requestedInfo.put("SignedInfo", si);
                }
                int numReferences = si.getLength();
                Vector<QName> qvec = null;
                if (requestedInfo != null && requestedInfo.containsKey("SignedElements")) {
                    qvec = new Vector<QName>(numReferences);
                    requestedInfo.put("SignedElements", qvec);
                }
                for (int i = 0; i < numReferences; ++i) {
                    Reference siRef;
                    try {
                        siRef = si.item(i);
                    }
                    catch (XMLSecurityException e3) {
                        throw new WSSecurityException(6);
                    }
                    String uri = siRef.getURI();
                    Element se = WSSecurityUtil.getElementByWsuId((Document)elem.getOwnerDocument(), (String)uri);
                    if (se == null) {
                        se = WSSecurityUtil.getElementByGenId((Document)elem.getOwnerDocument(), (String)uri);
                    }
                    if (se == null) {
                        throw new WSSecurityException(6);
                    }
                    if (qvec != null) {
                        QName qn = new QName(se.getNamespaceURI(), se.getLocalName());
                        qvec.add(qn);
                        if (qn.equals(secRefTokenQName) || secRefTokenQName == null && qn.equals(keyInfoQName)) {
                            qvec.add(WSSPConstants.QN_SIGNING_TOKEN);
                            DebugObjects.getHandlerDebug().debug("QName representing the signing token is signed: " + qn.toString() + "\nAdding reserved QName for signing token: " + WSSPConstants.QN_SIGNING_TOKEN.toString());
                        }
                    }
                    returnElements.add(WSSecurityUtil.getIDfromReference((String)uri));
                }
                if (certs != null) {
                    returnCert[0] = certs[0];
                    return certs[0].getSubjectDN();
                }
                if (ut != null) {
                    WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(ut.getName(), ut.isHashed());
                    principal.setNonce(ut.getNonce());
                    principal.setPassword(ut.getPassword());
                    principal.setCreatedTime(ut.getCreated());
                    return principal;
                }
                if (dkt != null) {
                    WSDerivedKeyTokenPrincipal principal = new WSDerivedKeyTokenPrincipal(dkt.getID());
                    principal.setNonce(dkt.getNonce());
                    principal.setLabel(dkt.getLabel());
                    principal.setLength(dkt.getLength());
                    principal.setOffset(dkt.getOffset());
                    return principal;
                }
                throw new WSSecurityException("Cannot determine principal");
            }
            throw new WSSecurityException(6);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(6);
        }
    }

    private void checkCrypto(Crypto crypto) throws WSSecurityException {
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
    }

    public String getId() {
        return this.signatureId;
    }
}

