/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.util;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpClientContextManager;
import com.sonicsw.net.http.soap.SonicSoapVerifier;
import com.sonicsw.net.http.ws.ForwardedWSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpProtocolHandler;
import com.sonicsw.ws.rm.common.AddressBinder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.URI;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.w3c.dom.NodeList;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.IClientContext;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerSession;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.Session;

public class WSAClusteringHelper {
    public static final short VERSION = 0;
    public static final String WSA_SUBJECT_PREFIX = "$ISYS.WSA.";
    public static final String WSA_INBOUND_MESSAGE_SUBJECT = "$ISYS.WSA.inboundMessage";
    private InterbrokerSession m_ssn;
    private int m_localId = Config.BROKER_NAME.hashCode();

    public static WSAClusteringHelper getWSAClusteringHelper() {
        return AgentRegistrar.getAgentRegistrar().getWSAClusteringHelper();
    }

    public void start() {
        try {
            this.subscribePropagationSubjects();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void subscribePropagationSubjects() throws IOException {
        this.m_ssn = Interbroker.getInterbroker().getIBSession();
        Label reliablelab = new Label();
        reliablelab.setPersistent(true);
        Label unreliablelab = new Label();
        unreliablelab.setPersistent(false);
        unreliablelab.setGuaranteed(false);
        this.m_ssn.submitSubscription(WSA_INBOUND_MESSAGE_SUBJECT, reliablelab);
    }

    public void setUpAdminHandlers() throws IOException {
        AgentAdminConnection conn = AgentRegistrar.getAgentRegistrar().getAdminConnection();
        MessageHandler mh = new MessageHandler(new IMessageHandler(){

            @Override
            public void handleMessage(Session s, Envelope env) {
            }
        });
        mh.setName("WSA clustering handler");
        mh.bind(WSA_INBOUND_MESSAGE_SUBJECT, (IMessageHandler)new WSAInboundMessageHandler());
        mh.setGuaranteed(true);
        conn.addMessageHandler(mh);
    }

    public static void soapToSonicMessage(org.apache.axis.Message soap, Message sonic) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        soap.writeTo((OutputStream)bos);
        byte[] msg = bos.toByteArray();
        sonic.writeInt(msg.length);
        sonic.write(msg);
    }

    public static org.apache.axis.Message soapFromSonicMessage(Message sonic) throws Exception {
        String contentType = "text/xml";
        byte[] data = new byte[sonic.readInt()];
        sonic.read(data);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        SonicSoapVerifier verifier = new SonicSoapVerifier(bin, contentType);
        SOAPMessage sm = verifier.getSoapMessage();
        SOAPConstants sc = verifier.getSoapConstants();
        org.apache.axis.Message axisMsg = new org.apache.axis.Message((Object)sm.getSOAPPart().getEnvelope());
        MessageContext mctx = new MessageContext((AxisEngine)new AxisClient());
        mctx.setSOAPConstants(sc);
        mctx.setRequestMessage(axisMsg);
        return axisMsg;
    }

    public boolean isNeighbor(long brokerId) {
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(brokerId);
            return cc != null && cc.isInterbroker();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void forward(long brokerId, Message msg) {
        block2: {
            try {
                msg.setSubject(WSA_INBOUND_MESSAGE_SUBJECT);
                this.m_ssn.publish(brokerId, msg, 0, true);
            }
            catch (Exception ex) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, BrokerComponent.getLevelWarning().intValue());
            }
        }
    }

    class WSAInboundMessageHandler
    implements IMessageHandler {
        WSAInboundMessageHandler() {
        }

        private WSHttpProtocolHandler locateHandler(HttpServletRequest req, String hostUrl) throws IOException {
            Enumeration e = AcceptorHolder.getAcceptorHolder().getAcceptors();
            while (e.hasMoreElements()) {
                Hashtable ht = (Hashtable)e.nextElement();
                Enumeration e2 = ht.elements();
                while (e2.hasMoreElements()) {
                    HttpConnectionHandler han;
                    IHttpRequestHandler hndlr;
                    Acceptor a = (Acceptor)e2.nextElement();
                    if (!(a instanceof HTTPAcceptor)) continue;
                    HTTPAcceptor ha = (HTTPAcceptor)a;
                    String u = ha.getExternalURL();
                    if (u == null) {
                        u = ha.getURL();
                    }
                    if (!hostUrl.startsWith(u) || (hndlr = (han = ha.getHttpConnectionHandler()).loadMatchingHandler(null, req, null, null)) == null || !(hndlr instanceof WSHttpProtocolHandler)) continue;
                    return (WSHttpProtocolHandler)hndlr;
                }
            }
            return null;
        }

        private String getNodeValue(String ns, String tag, SOAPPart part) {
            NodeList list = part.getElementsByTagNameNS(ns, tag);
            if (list == null || list.getLength() <= 0) {
                return null;
            }
            return list.item(0).getFirstChild().toString();
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            try {
                env.getMessage().readShort();
                String origin = env.getMessage().readUTF();
                if (origin.equalsIgnoreCase(Config.BROKER_NAME)) {
                    return;
                }
                Message me = env.getMessage();
                String hostURL = me.readUTF();
                String path = me.readUTF();
                int contentLength = me.readInt();
                String characterEncoding = me.readUTF();
                String contentType = me.readUTF();
                String method = me.readUTF();
                String action = me.readUTF();
                Hashtable ht = WSHttpProtocolHandler.readPropertySetFromStream(me);
                ClientSecurityContext csc = ClientSecurityContext.getClientSecurityContext(env.getMessage(), (short)-1);
                org.apache.axis.Message axisMsg = WSAClusteringHelper.soapFromSonicMessage(env.getMessage());
                AddressingHeaders ah = new AddressingHeaders((SOAPEnvelope)axisMsg.getSOAPEnvelope());
                String wsaTo = ah.getTo().toString();
                ProgressPasswordUser ppu = AgentRegistrar.getAgentRegistrar().getSecurityBean() == null ? new ProgressPasswordUser(csc.getUid(), "") : AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(csc.getUid());
                HttpClientContext hctx = HttpClientContextManager.getInstance().connect(ppu);
                if (hctx == null) {
                    return;
                }
                Request req = new Request(null, null);
                req.setContextPath(hostURL);
                req.setMethod(method);
                req.setContentType(contentType);
                req.getHttpFields().add(HttpHeader.CONTENT_LENGTH, "" + contentLength);
                req.setCharacterEncoding(characterEncoding);
                Enumeration flds = ht.keys();
                while (flds.hasMoreElements()) {
                    String key = (String)flds.nextElement();
                    req.getHttpFields().add(key, (String)ht.get(key));
                }
                WSHttpProtocolHandler ph = this.locateHandler((HttpServletRequest)req, wsaTo);
                if (ph != null) {
                    String SOAPVER = "SOAP 1.1";
                    if (axisMsg.getMessageContext().getSOAPConstants() instanceof SOAP12Constants) {
                        SOAPVER = "SOAP 1.2";
                    }
                    ForwardedWSHttpInRequest wsreq = new ForwardedWSHttpInRequest((HttpServletRequest)req, (SOAPMessage)axisMsg, SOAPVER, action);
                    MessageContext mc = ph.establishContext();
                    mc.setRequestMessage(axisMsg);
                    URI u = new URI(wsaTo);
                    if (AddressBinder.isInternallyGeneratedWSAAddress(u.getPath())) {
                        Destination dest = AddressBinder.getWSADestination(u.getPath());
                        mc.setProperty("DEST", (Object)dest);
                    }
                    mc.setProperty("com.sonicsw.net.http.HttpClientContext", (Object)hctx);
                    mc.setProperty("com.sonicsw.net.http.HttpInRequest", (Object)wsreq);
                    mc.setSOAPActionURI(action);
                    ph.sendToSOAPStack(mc, hctx);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
            }
        }
    }
}

