/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.util.xml;

import com.sonicsw.ws.util.xml.Namespace;
import com.sonicsw.ws.util.xml.NamespaceContextImpl;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.JAXPXPathStaticContext;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtils {
    private TransformerFactory m_tfrmFactory;
    private NamespaceContextImpl m_namespaceContext;
    private Configuration m_configuration = new Configuration();

    public XMLUtils() throws TransformerConfigurationException {
        this.m_namespaceContext = new NamespaceContextImpl();
        this.m_tfrmFactory = new TransformerFactoryImpl(this.m_configuration);
        this.m_tfrmFactory.setAttribute("http://saxon.sf.net/feature/version-warning", false);
        this.m_tfrmFactory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "none");
    }

    public void setNamespaces(Map nameSpaces) {
        if (nameSpaces != null) {
            for (String prefix : nameSpaces.keySet()) {
                String uri = (String)nameSpaces.get(prefix);
                this.m_namespaceContext.declareNamespace(prefix, uri);
            }
        }
    }

    public void setNamespaces(List nameSpaces) {
        if (nameSpaces != null) {
            for (Namespace ns : nameSpaces) {
                this.m_namespaceContext.declareNamespace(ns.getPrefix(), ns.getNamespaceUri());
            }
        }
    }

    public SequenceExtent computeXPath(String value, String xpathExpression) throws TransformerException {
        InputSource is = new InputSource(new StringReader(value));
        SAXSource ss = new SAXSource(is);
        DocumentInfo node = this.m_configuration.buildDocument((Source)ss);
        return this.computeXPath((NodeInfo)node, xpathExpression);
    }

    public SequenceExtent computeXPath(Element value, String xpathExpression) throws TransformerException {
        DocumentWrapper node = new DocumentWrapper((Node)value.getOwnerDocument(), "", this.m_configuration);
        return this.computeXPath(node.getRootNode(), xpathExpression);
    }

    public SequenceExtent computeXPath(NodeInfo nodeInfo, String xpathExpression) throws TransformerException {
        XPathEvaluator xpe = new XPathEvaluator(nodeInfo.getConfiguration());
        JAXPXPathStaticContext staticContext = xpe.getStaticContext();
        staticContext.setBackwardsCompatibilityMode(true);
        staticContext.setNamespaceContext((NamespaceContext)this.m_namespaceContext);
        try {
            XPathExpressionImpl expr = (XPathExpressionImpl)xpe.compile(xpathExpression);
            XPathContextMajor context = new XPathContextMajor((Item)nodeInfo, new Executable(this.m_configuration));
            context.openStackFrame(expr.getStackFrameMap());
            return new SequenceExtent(expr.getInternalExpression().iterate((XPathContext)context));
        }
        catch (XPathExpressionException xpee) {
            throw new TransformerException(xpee);
        }
    }

    public String computeXSLT(String doc, StreamSource xsltSS) throws TransformerException {
        StreamSource xsltDoc = new StreamSource(new StringReader(doc));
        Transformer transformer = this.m_tfrmFactory.newTransformer(xsltSS);
        StringWriter result = new StringWriter();
        transformer.transform(xsltDoc, new StreamResult(result));
        return result.toString();
    }

    public String computeXSLT(String doc, String xsltExpression) throws TransformerException {
        StreamSource xsltDoc = new StreamSource(new StringReader(doc));
        StreamSource xsltSS = new StreamSource(new StringReader(xsltExpression));
        Transformer transformer = this.m_tfrmFactory.newTransformer(xsltSS);
        StringWriter result = new StringWriter();
        transformer.transform(xsltDoc, new StreamResult(result));
        return result.toString();
    }

    public String computeXSLT(Source docSource, Reader inputStream) throws TransformerException {
        InputSource xslt = new InputSource(inputStream);
        SAXSource xsltSS = new SAXSource(xslt);
        Transformer transformer = this.m_tfrmFactory.newTransformer(xsltSS);
        StringWriter result = new StringWriter();
        transformer.transform(docSource, new StreamResult(result));
        return result.toString();
    }

    public Document createDOMDocument(Reader rdr) throws TransformerException {
        NodeInfo n = this.createNodeInfo(rdr);
        NodeOverNodeInfo node = NodeOverNodeInfo.wrap((NodeInfo)n);
        return node.getOwnerDocument();
    }

    public NodeInfo createNodeInfo(Reader rdr) throws TransformerException {
        SAXSource inputDocSource = new SAXSource(new InputSource(rdr));
        NodeInfo nodeInfo = this.m_configuration.buildDocumentTree((Source)inputDocSource).getRootNode();
        return nodeInfo;
    }

    public static Node getDOMNode(NodeInfo n) {
        return NodeOverNodeInfo.wrap((NodeInfo)n);
    }

    public static TransformerFactory getTransformerFactory() {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        factory.setAttribute("http://saxon.sf.net/feature/version-warning", (Object)false);
        return factory;
    }

    public static SAXParserFactory getSAXParserFactory() {
        return new SAXParserFactoryImpl();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return new DocumentBuilderFactoryImpl();
    }
}

