/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.wsp;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.util.xml.Namespace;
import com.sonicsw.ws.util.xml.SaxonSerializationUtils;
import com.sonicsw.ws.util.xml.XMLUtils;
import com.sonicsw.wsdl.WSDLContext;
import com.sonicsw.wsdl.extensions.wsp.WSPPolicyReference;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicy2002Exception;
import com.sonicsw.wsp.SecurityPolicyException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.SequenceExtent;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.DOMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyReferenceDocument;

public class WSPUtils {
    private static final String WSSP_2002_URI = "http://schemas.xmlsoap.org/ws/2002/12/secext";
    private static final String WSSP_2005_URI = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    public static final int SP_UNKNOWN = 0;
    public static final int SP_2002 = 2002;
    public static final int SP_2005 = 2005;
    private static HashMap m_xpathCache = new HashMap();

    public static PolicyDocument newNormalizedPolicyDocument() {
        PolicyDocument pdoc = PolicyDocument.Factory.newInstance();
        PolicyDocument.Policy policy = pdoc.addNewPolicy();
        OperatorContentType xone = policy.addNewExactlyOne();
        OperatorContentType all = xone.addNewAll();
        return pdoc;
    }

    public static PolicyDocument newPolicyDocument() {
        PolicyDocument pdoc = PolicyDocument.Factory.newInstance();
        pdoc.addNewPolicy();
        return pdoc;
    }

    public static PolicyDocument newNullPolicyDocument() {
        PolicyDocument pdoc = PolicyDocument.Factory.newInstance();
        PolicyDocument.Policy policy = pdoc.addNewPolicy();
        policy.addNewExactlyOne();
        return pdoc;
    }

    public static PolicyDocument getPolicyDocument(String xml) throws ParserConfigurationException, SAXException, XmlException, IOException {
        PolicyDocument policy = PolicyDocument.Factory.parse((String)xml);
        return policy;
    }

    public static PolicyDocument getPolicyDocumentFromURL(WSDLContext wctx, String uri) throws ParserConfigurationException, SAXException, XmlException, IOException, PolicyException {
        String policyString = WSPUtils.getPolicySource(wctx, wctx.getWSDLUri(), uri);
        PolicyDocument policy = PolicyDocument.Factory.parse((String)policyString);
        return policy;
    }

    public static Policy getPolicy(String xml) throws ParserConfigurationException, SAXException, IOException, PolicyException {
        Document doc = WSPUtils.getPolicyAsDOM(xml);
        int spVersion = WSPUtils.getSPVersion(doc);
        if (spVersion == 2002) {
            throw new SecurityPolicy2002Exception();
        }
        DOMPolicyReader policyReader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
        Policy policy = policyReader.readPolicy(doc.getDocumentElement());
        return (Policy)policy.normalize();
    }

    public static String getStreamContentsAsString(InputStream in) throws IOException {
        String inputLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringWriter out = new StringWriter();
        while ((inputLine = reader.readLine()) != null) {
            out.write(inputLine);
            out.write("\n");
        }
        reader.close();
        return out.toString();
    }

    public static String getURLContentsAsString(URL url) throws IOException {
        return WSPUtils.getStreamContentsAsString(url.openStream());
    }

    private static boolean isEmbeddedPolicyUri(URL wsdlUrl, URL policyUrl) throws MalformedURLException {
        return wsdlUrl.equals(policyUrl);
    }

    private static String getEmbeddedXmlBase(String doc, URL policyUrl) throws PolicyException {
        try {
            String id = policyUrl.getRef();
            ArrayList<Namespace> nspaces = new ArrayList<Namespace>();
            nspaces.add(new Namespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"));
            nspaces.add(new Namespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy"));
            XMLUtils util = new XMLUtils();
            util.setNamespaces(nspaces);
            String baseurl = policyUrl.toExternalForm();
            baseurl = baseurl.substring(0, baseurl.lastIndexOf(35));
            String expr = "//wsp:Policy[starts-with(\"" + baseurl + "\", @xml:base) and @wsu:Id = \"" + policyUrl.getRef() + "\"]";
            SequenceExtent v = util.computeXPath(doc, expr);
            int xpLen = v.getLength();
            if (xpLen == 0) {
                return null;
            }
            return WSPUtils.appendNodeData(xpLen, v, id);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private static String serialize(NodeInfo item) {
        StringWriter sw = new StringWriter();
        SaxonSerializationUtils.serializeNodeToWriter(item, (Writer)sw);
        return sw.toString();
    }

    private static String getEmbeddedByRef(String doc, URL policyUrl) throws PolicyException {
        try {
            String id = policyUrl.getRef();
            ArrayList<Namespace> nspaces = new ArrayList<Namespace>();
            nspaces.add(new Namespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"));
            nspaces.add(new Namespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy"));
            XMLUtils util = new XMLUtils();
            util.setNamespaces(nspaces);
            String expr = "//wsp:Policy[@wsu:Id=\"" + id + "\"]";
            SequenceExtent v = util.computeXPath(doc, expr);
            int xpLen = v.getLength();
            return WSPUtils.appendNodeData(xpLen, v, id);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private static String appendNodeData(int xpLen, SequenceExtent v, String id) throws PolicyException {
        String result = "";
        for (int i = 0; i < xpLen; ++i) {
            Item item = v.itemAt(i);
            if (!(item instanceof NodeInfo)) {
                throw new PolicyException("Policy reference does not refer to a node; id=" + id, null);
            }
            result = result + WSPUtils.serialize((NodeInfo)item);
        }
        return result;
    }

    static String getPolicySource(WSDLContext wctx, String baseLocation, String policyUri) throws PolicyException, XmlException, IOException {
        try {
            URL wsdlUrl = new URL(baseLocation);
            URL policyUrl = new URL(wsdlUrl, policyUri);
            if (WSPUtils.isEmbeddedPolicyUri(wsdlUrl, policyUrl)) {
                String wsdl = WSPUtils.getStreamContentsAsString(wctx.getWSDLInputStream());
                String policy = WSPUtils.getEmbeddedByRef(wsdl, policyUrl);
                return policy;
            }
            String wsdl = WSPUtils.getStreamContentsAsString(wctx.getWSDLInputStream());
            String policy = WSPUtils.getEmbeddedXmlBase(wsdl, policyUrl);
            if (policy != null) {
                return policy;
            }
            try {
                String policyDoc = WSPUtils.getURLContentsAsString(policyUrl);
                policy = WSPUtils.getEmbeddedByRef(policyDoc, policyUrl);
                return policy;
            }
            catch (IOException e) {
                throw new PolicyException("Unable to resolve external policy URL: ", e);
            }
        }
        catch (UnknownHostException e) {
            throw new PolicyException("Unable to resolve PolicyURI: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    public static boolean isSingleton(PolicyDocument pdoc) {
        if (!WSPUtils.isNormalized(pdoc)) {
            return false;
        }
        PolicyDocument.Policy policy = pdoc.getPolicy();
        OperatorContentType xone = policy.getExactlyOneArray(0);
        OperatorContentType[] alls = xone.getAllArray();
        return alls.length == 1;
    }

    private static OperatorContentType getNormalizedExactlyOne(PolicyDocument pdoc) {
        PolicyDocument.Policy policy = pdoc.getPolicy();
        OperatorContentType[] xones = policy.getExactlyOneArray();
        return xones[0];
    }

    public static XmlObject[] getAssertionsByQName(OperatorContentType op, QName qname) {
        String xpath = WSPUtils.childElementXPath(qname);
        return op.selectPath(xpath);
    }

    public static OperatorContentType getNormalizedAllByIndex(PolicyDocument policy, int index) {
        OperatorContentType xone = WSPUtils.getNormalizedExactlyOne(policy);
        return xone.getAllArray(index);
    }

    public static int getNormalizedAllCount(PolicyDocument policy, int index) {
        OperatorContentType xone = WSPUtils.getNormalizedExactlyOne(policy);
        return xone.getAllArray().length;
    }

    public static Iterator getNormalizedAllIterator(PolicyDocument policy) {
        OperatorContentType xone = WSPUtils.getNormalizedExactlyOne(policy);
        OperatorContentType[] alls = xone.getAllArray();
        ArrayList<OperatorContentType> list = new ArrayList<OperatorContentType>();
        for (int i = 0; i < alls.length; ++i) {
            list.add(alls[i]);
        }
        return list.iterator();
    }

    public static boolean isNormalized(PolicyDocument pdoc) {
        PolicyDocument.Policy policy = pdoc.getPolicy();
        OperatorContentType[] alls = policy.getAllArray();
        if (alls.length > 0) {
            return false;
        }
        PolicyDocument.Policy[] policys = policy.getPolicyArray();
        if (policys.length > 0) {
            return false;
        }
        PolicyReferenceDocument.PolicyReference[] policyrefs = policy.getPolicyReferenceArray();
        if (policyrefs.length > 0) {
            return false;
        }
        OperatorContentType[] xones = policy.getExactlyOneArray();
        if (xones.length != 1) {
            return false;
        }
        OperatorContentType xone = xones[0];
        if ((xones = xone.getExactlyOneArray()).length > 0) {
            return false;
        }
        policyrefs = xone.getPolicyReferenceArray();
        return policyrefs.length <= 0;
    }

    private static void mergeContent(OperatorContentType from, OperatorContentType to) throws XmlException {
        PolicyDocument fromPolicyDocument = WSPUtils.newPolicyDocument();
        fromPolicyDocument.getPolicy().set((XmlObject)from);
        Document fromDomDocument = (Document)fromPolicyDocument.newDomNode();
        PolicyDocument toPolicyDocument = WSPUtils.newPolicyDocument();
        toPolicyDocument.getPolicy().set((XmlObject)to);
        Document toDomDocument = (Document)toPolicyDocument.newDomNode();
        Document toOwnerDocument = toDomDocument.getOwnerDocument();
        if (toOwnerDocument == null) {
            toOwnerDocument = toDomDocument;
        }
        NodeList fromChildNodes = fromDomDocument.getDocumentElement().getChildNodes();
        for (int i = 0; i < fromChildNodes.getLength(); ++i) {
            Node fromChildNode = fromChildNodes.item(i);
            if (fromChildNode.getNodeType() != 1) continue;
            Node fromChildNodeImported = toOwnerDocument.importNode(fromChildNode, true);
            toDomDocument.getDocumentElement().appendChild(fromChildNodeImported);
        }
        PolicyDocument tempTo = PolicyDocument.Factory.parse((Node)toDomDocument, (XmlOptions)new XmlOptions().setSaveNamespacesFirst());
        to.set((XmlObject)tempTo.getPolicy());
    }

    public static PolicyDocument merge(PolicyDocument left, PolicyDocument right) throws XmlException {
        if (left == null && right == null) {
            return null;
        }
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        if (!WSPUtils.isNormalized(left)) {
            throw new IllegalArgumentException("Product-left policy not normalized");
        }
        if (!WSPUtils.isNormalized(right)) {
            throw new IllegalArgumentException("Product-right policy not normalized");
        }
        PolicyDocument result = WSPUtils.newNullPolicyDocument();
        OperatorContentType resultExactlyOne = WSPUtils.getNormalizedExactlyOne(result);
        Iterator leftIterator = WSPUtils.getNormalizedAllIterator(left);
        while (leftIterator.hasNext()) {
            OperatorContentType leftAll = (OperatorContentType)leftIterator.next();
            Iterator rightIterator = WSPUtils.getNormalizedAllIterator(right);
            while (rightIterator.hasNext()) {
                OperatorContentType rightAll = (OperatorContentType)rightIterator.next();
                OperatorContentType resultAll = resultExactlyOne.addNewAll();
                resultAll.set((XmlObject)((OperatorContentType)leftAll.copy()));
                WSPUtils.mergeContent(rightAll, resultAll);
            }
        }
        return result;
    }

    public static PolicyDocument merge(PolicyDocument[] components) throws XmlException {
        if (components.length == 0) {
            return null;
        }
        PolicyDocument result = components[0];
        for (int i = 1; i <= components.length - 1; ++i) {
            result = WSPUtils.merge(result, components[i]);
        }
        return result;
    }

    public static void collapse(PolicyDocument from, PolicyDocument to) {
        if (!WSPUtils.isNormalized(from)) {
            throw new IllegalArgumentException("Collapse-from policy not normalized");
        }
        if (!WSPUtils.isNormalized(to)) {
            throw new IllegalArgumentException("Collapse-to policy not normalized");
        }
        OperatorContentType toExactlyOne = WSPUtils.getNormalizedExactlyOne(to);
        Iterator fromIterator = WSPUtils.getNormalizedAllIterator(from);
        while (fromIterator.hasNext()) {
            OperatorContentType fromAll = (OperatorContentType)fromIterator.next();
            OperatorContentType toAll = toExactlyOne.addNewAll();
            toAll.set((XmlObject)fromAll);
        }
    }

    public static PolicyDocument collapse(PolicyDocument[] components) {
        PolicyDocument resultDoc = WSPUtils.newPolicyDocument();
        PolicyDocument.Policy resultPolicy = resultDoc.getPolicy();
        OperatorContentType all = resultPolicy.addNewAll();
        for (int i = 0; i < components.length; ++i) {
            PolicyDocument.Policy compPolicy = components[i].getPolicy();
            PolicyDocument.Policy child = all.addNewPolicy();
            child.set((XmlObject)compPolicy);
        }
        return resultDoc;
    }

    public static OperatorContentType getPolicyAlternative(PolicyDocument policy, int index) {
        if (!WSPUtils.isNormalized(policy)) {
            throw new IllegalArgumentException("Policy must be normalized");
        }
        return WSPUtils.getNormalizedAllByIndex(policy, index);
    }

    public static PolicyDocument[] dereference(WSDLContext wctx, WSPPolicyReference[] refs) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        PolicyDocument[] docs = new PolicyDocument[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            docs[i] = refs[i].getPolicyDocument(wctx);
        }
        return docs;
    }

    public void normalize(PolicyDocument pdoc) {
        PolicyDocument.Policy pol = pdoc.getPolicy();
        OperatorContentType[] alls = pol.getAllArray();
        this.normalizeAlls(alls);
        OperatorContentType[] xones = pol.getExactlyOneArray();
        this.normalizeXones(xones);
    }

    public void normalize(OperatorContentType content) {
        OperatorContentType[] alls = content.getAllArray();
        this.normalizeAlls(alls);
        OperatorContentType[] xones = content.getExactlyOneArray();
        this.normalizeXones(xones);
        PolicyDocument.Policy[] pols = content.getPolicyArray();
        this.normalizeOperatorContentTypes((OperatorContentType[])pols);
    }

    private void normalizeAlls(OperatorContentType[] alls) {
        this.normalizeOperatorContentTypes(alls);
    }

    private void normalizeXones(OperatorContentType[] xones) {
        this.normalizeOperatorContentTypes(xones);
    }

    private void normalizeOperatorContentTypes(OperatorContentType[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.normalize(data[i]);
        }
    }

    public static XmlObject[] getAssertions(OperatorContentType content, QName name) {
        return content.selectPath(WSPUtils.childElementXPath(name));
    }

    public static XmlObject[] getAssertions(OperatorContentType content, String namespaceURI) {
        return content.selectPath(WSPUtils.childElementXPath(namespaceURI));
    }

    public static XmlObject getFirstAssertion(OperatorContentType content, QName name) {
        XmlObject[] assertions = WSPUtils.getAssertions(content, name);
        if (assertions != null && assertions.length > 0) {
            return assertions[0];
        }
        return null;
    }

    public static String childElementXPath(QName name) {
        String xpath = (String)m_xpathCache.get(name);
        if (xpath == null) {
            StringBuffer buf = WSPUtils.appendNameSpaceURI(name);
            buf.append("' ./");
            xpath = WSPUtils.appendLocalPart(buf, name);
        }
        return xpath;
    }

    public static String childElementXPath(String namespaceURI) {
        String xpath = (String)m_xpathCache.get(namespaceURI);
        if (xpath == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("declare namespace temp = '");
            buf.append(namespaceURI);
            buf.append("' ./temp:*");
            xpath = buf.toString();
            m_xpathCache.put(namespaceURI, xpath);
        }
        return xpath;
    }

    public static String childElementXPath(QName[] names) {
        String xpath = (String)m_xpathCache.get(names);
        if (xpath == null) {
            int i;
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < names.length; ++i) {
                buf.append("declare namespace ");
                buf.append(names[i].getPrefix());
                buf.append("='");
                buf.append(names[i].getNamespaceURI());
                buf.append("' ");
            }
            for (i = 0; i < names.length; ++i) {
                if (i != 0) {
                    buf.append(" | ");
                }
                buf.append(" ./");
                buf.append(names[i].getPrefix());
                buf.append(":");
                buf.append(names[i].getLocalPart());
            }
            xpath = buf.toString();
            m_xpathCache.put(names, xpath);
        }
        return xpath;
    }

    public static String childAttributeXPath(QName name) {
        String xpath = (String)m_xpathCache.get(name);
        if (xpath == null) {
            StringBuffer buf = WSPUtils.appendNameSpaceURI(name);
            buf.append("' ./@");
            xpath = WSPUtils.appendLocalPart(buf, name);
        }
        return xpath;
    }

    private static StringBuffer appendNameSpaceURI(QName name) {
        StringBuffer buf = new StringBuffer();
        buf.append("declare namespace ");
        buf.append(name.getPrefix());
        buf.append("='");
        buf.append(name.getNamespaceURI());
        return buf;
    }

    private static String appendLocalPart(StringBuffer buf, QName name) {
        buf.append(name.getPrefix());
        buf.append(":");
        buf.append(name.getLocalPart());
        String xpath = buf.toString();
        m_xpathCache.put(name, xpath);
        return xpath;
    }

    public static String declareNamespaceXPath(String prefix, String uri) {
        StringBuffer buf = new StringBuffer();
        buf.append("declare namespace ");
        buf.append(prefix);
        buf.append("='");
        buf.append(uri);
        buf.append("'; ");
        return buf.toString();
    }

    public static String qname(String prefix, String lname) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(":");
        buf.append(lname);
        return buf.toString();
    }

    public static String embeddedPolicyXPath(String id) {
        String cacheKey = "embeddedPolicy-" + id;
        String xpath = (String)m_xpathCache.get(cacheKey);
        if (xpath == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(WSPUtils.declareNamespaceXPath("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy"));
            buf.append(WSPUtils.declareNamespaceXPath("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"));
            buf.append("//");
            buf.append(WSPUtils.qname("wsp", "Policy"));
            buf.append("[@").append(WSPUtils.qname("wsu", "Id"));
            buf.append("=\"" + id + "\"]");
            xpath = buf.toString();
            m_xpathCache.put(cacheKey, xpath);
        }
        return xpath;
    }

    public static OperatorContentType getSingletonAll(PolicyDocument pdoc) {
        PolicyDocument.Policy policy = pdoc.getPolicy();
        OperatorContentType xone = policy.getExactlyOneArray(0);
        OperatorContentType all = xone.getAllArray(0);
        return all;
    }

    private static void listPrimitiveAssertions(Assertion assertion, List paList, String prepend) {
        DebugObjects.getPolicyDebug().debug(prepend + "Assertion " + assertion + " type: " + assertion.getType());
        if (assertion.getType() == 1) {
            paList.add(assertion);
        } else {
            List terms = assertion.getTerms();
            if (!terms.isEmpty()) {
                prepend.concat("  ");
            }
            for (int i = 0; i < terms.size(); ++i) {
                Assertion childAssertion = (Assertion)terms.get(i);
                if (childAssertion.getType() == 1) {
                    DebugObjects.getPolicyDebug().debug(prepend + "PrimitiveAssertion " + childAssertion + " name: " + ((PrimitiveAssertion)childAssertion).getName());
                    paList.add(childAssertion);
                    continue;
                }
                WSPUtils.listPrimitiveAssertions(childAssertion, paList, prepend);
            }
        }
    }

    public static void walkAssertions(Assertion assertion, String prepend) {
        if (!DebugObjects.getPolicyDebug().getDebug()) {
            return;
        }
        DebugObjects.getPolicyDebug().debug(prepend + "Walking assertion: " + assertion + " size: " + assertion.size());
        ArrayList paList = new ArrayList();
        WSPUtils.listPrimitiveAssertions(assertion, paList, new String(prepend.concat("  ")));
        for (int i = 0; i < paList.size(); ++i) {
            PrimitiveAssertion primitiveAssertion = (PrimitiveAssertion)paList.get(i);
            List terms = primitiveAssertion.getTerms();
            for (int j = 0; j < terms.size(); ++j) {
                WSPUtils.walkAssertions((Assertion)terms.get(j), new String(prepend.concat("  ")));
            }
        }
    }

    public static Policy getPolicyFromURL(WSDLContext wctx, String uri) throws ParserConfigurationException, SAXException, XmlException, IOException, PolicyException {
        String policyString = WSPUtils.getPolicySource(wctx, wctx.getWSDLUri(), uri);
        Document doc = WSPUtils.getPolicyAsDOM(policyString);
        ByteArrayInputStream pis = new ByteArrayInputStream(policyString.getBytes());
        DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
        return (Policy)reader.readPolicy(doc.getDocumentElement()).normalize();
    }

    public static int getNumberOfPolicyAlternatives(Policy policy) {
        if (!policy.isNormalized()) {
            throw new RuntimeException("Policy is not in normalized format");
        }
        XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
        return xor.getTerms().size();
    }

    public static Policy[] getPolicyAlternatives(Policy policyParam) {
        Policy policy = policyParam;
        if (!policy.isNormalized()) {
            policy = (Policy)policy.normalize();
        }
        XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
        List listOfPolicyAlternatives = xor.getTerms();
        int numberOfAlternatives = listOfPolicyAlternatives.size();
        Policy[] policies = new Policy[numberOfAlternatives];
        for (int i = 0; i < listOfPolicyAlternatives.size(); ++i) {
            Assertion policyAlternative = (Assertion)listOfPolicyAlternatives.get(i);
            Policy altPolicy = new Policy();
            altPolicy.addTerm(policyAlternative);
            policies[i] = (Policy)altPolicy.normalize();
        }
        return policies;
    }

    private static Document getPolicyAsDOM(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = null;
        doc = db.parse(new ByteArrayInputStream(xml.getBytes()));
        return doc;
    }

    private static int getSPVersion(Document doc) throws SecurityPolicyException {
        int spVersion = 0;
        if (doc != null) {
            NodeList nodeList = doc.getElementsByTagNameNS(WSSP_2002_URI, "*");
            if (nodeList.getLength() > 0) {
                spVersion = 2002;
                WSPUtils.checkPolicyNamespace(nodeList);
            }
            if ((nodeList = doc.getElementsByTagNameNS(WSSP_2005_URI, "*")).getLength() > 0) {
                if (spVersion != 0) {
                    throw new SecurityPolicyException("Incompatible namespaces used in policy: http://schemas.xmlsoap.org/ws/2002/12/secext and http://schemas.xmlsoap.org/ws/2005/07/securitypolicy");
                }
                spVersion = 2005;
                WSPUtils.checkPolicyNamespace(nodeList);
            }
        }
        return spVersion;
    }

    private static void checkPolicyNamespace(NodeList nodeList) {
        if (DebugObjects.getPolicyDebug().getDebug()) {
            DebugObjects.getPolicyDebug().debug("Policy contains the following elements that use the namespace http://schemas.xmlsoap.org/ws/2002/12/secext");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                DebugObjects.getPolicyDebug().debug(node.getLocalName());
            }
        }
    }
}

