/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import progress.message.broker.Acceptor;
import progress.message.broker.HTTPAcceptor;

public class AcceptorHolder {
    private static volatile AcceptorHolder s_acceptorHolder;
    private static final Object ACCEPTORHOLDER_OBJ;
    private Hashtable m_acceptors = new Hashtable(8);
    private Acceptor m_primaryAcceptor = null;
    private Acceptor m_interbrokerAcceptor = null;
    private String m_defaultRoutingURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcceptorHolder() {
        if (s_acceptorHolder == null) {
            Object object = ACCEPTORHOLDER_OBJ;
            synchronized (object) {
                if (s_acceptorHolder == null) {
                    s_acceptorHolder = this;
                }
            }
        }
    }

    public static AcceptorHolder getAcceptorHolder() {
        return s_acceptorHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptor(String acceptorName, String acceptorConfigID, Acceptor acceptor, boolean isPrimaryAcceptor, boolean isInterbrokerAcceptor) {
        AcceptorHolder acceptorHolder = this;
        synchronized (acceptorHolder) {
            Hashtable<String, Acceptor> acceptors = (Hashtable<String, Acceptor>)this.m_acceptors.get(acceptorName);
            if (acceptors == null) {
                acceptors = new Hashtable<String, Acceptor>(4);
                this.m_acceptors.put(acceptorName, acceptors);
            }
            acceptors.put(acceptorConfigID, acceptor);
        }
        if (isPrimaryAcceptor) {
            this.m_primaryAcceptor = acceptor;
        }
        if (isInterbrokerAcceptor) {
            this.m_interbrokerAcceptor = acceptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcceptor(String acceptorConfigID) {
        AcceptorHolder acceptorHolder = this;
        synchronized (acceptorHolder) {
            for (Map.Entry entry : this.m_acceptors.entrySet()) {
                Hashtable table = (Hashtable)entry.getValue();
                if (!table.containsKey(acceptorConfigID)) continue;
                table.remove(acceptorConfigID);
                if (table.size() < 1) {
                    this.m_acceptors.remove(entry.getKey());
                }
                return;
            }
        }
    }

    public Enumeration getAcceptors() {
        return this.m_acceptors.elements();
    }

    public Enumeration getAcceptorNames() {
        return this.m_acceptors.keys();
    }

    public Enumeration getAcceptors(String name) {
        Hashtable m = (Hashtable)this.m_acceptors.get(name);
        if (m == null) {
            return null;
        }
        return m.elements();
    }

    public Acceptor getAcceptor(String configID) {
        Enumeration acceptors = this.m_acceptors.elements();
        while (acceptors.hasMoreElements()) {
            for (Map.Entry entry : ((Hashtable)acceptors.nextElement()).entrySet()) {
                if (!entry.getKey().equals(configID)) continue;
                return (Acceptor)entry.getValue();
            }
        }
        return null;
    }

    public Acceptor getPrimaryAcceptor() {
        return this.m_primaryAcceptor;
    }

    public String getDefaultRoutingURL() {
        return this.m_defaultRoutingURL;
    }

    public void setDefaultRoutingURL(String defaultRoutingURL) {
        this.m_defaultRoutingURL = defaultRoutingURL;
    }

    public Acceptor getInterbrokerAcceptor() {
        return this.m_interbrokerAcceptor;
    }

    public void setPrimaryAcceptor(Acceptor paAcceptor) {
        if (this.m_primaryAcceptor != paAcceptor) {
            this.m_primaryAcceptor = paAcceptor;
        }
    }

    public void setInterbrokerAcceptor(Acceptor iaAcceptor) {
        if (this.m_interbrokerAcceptor != iaAcceptor) {
            this.m_interbrokerAcceptor = iaAcceptor;
        }
    }

    public int count() {
        return this.m_acceptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        AcceptorHolder acceptorHolder = this;
        synchronized (acceptorHolder) {
            Enumeration acceptors = this.m_acceptors.elements();
            while (acceptors.hasMoreElements()) {
                Hashtable table = (Hashtable)acceptors.nextElement();
                Enumeration entries = table.elements();
                while (entries.hasMoreElements()) {
                    ((Acceptor)entries.nextElement()).shutdown();
                }
            }
            this.m_acceptors.clear();
        }
        this.m_primaryAcceptor = null;
        this.m_interbrokerAcceptor = null;
        this.m_defaultRoutingURL = null;
    }

    public HTTPAcceptor findHttpAcceptor(int port) {
        Enumeration acceptors = this.m_acceptors.elements();
        while (acceptors.hasMoreElements()) {
            for (Map.Entry entry : ((Hashtable)acceptors.nextElement()).entrySet()) {
                HTTPAcceptor acceptor;
                if (!(entry.getValue() instanceof HTTPAcceptor) || (acceptor = (HTTPAcceptor)entry.getValue()).getPort() != port) continue;
                return acceptor;
            }
        }
        return null;
    }

    static {
        ACCEPTORHOLDER_OBJ = new Object();
    }
}

